/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.mixed;

import com.ibm.ccl.sca.composite.emf.sca.Composite;
import com.ibm.ccl.sca.composite.emf.sca.Include;
import com.ibm.ccl.sca.composite.ui.custom.mixed.HasChildrenFilter;
import com.ibm.ccl.sca.composite.ui.custom.mixed.HasSameComponentFilter;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedComponent;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedComposite;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedItem;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MultiFilter;
import com.ibm.ccl.sca.composite.ui.custom.target.ComponentAlreadyInListFilter;
import com.ibm.ccl.sca.composite.ui.custom.target.TargetAlreadyInListFilter;
import com.ibm.ccl.sca.composite.ui.custom.util.ResourceUtil;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAFilter;
import com.ibm.ccl.sca.core.model.SCAModelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class MixedUtils {
    public static List<MixedComposite> combineComposites(List<org.apache.tuscany.sca.assembly.Composite> scaComposites, List<Composite> emfComposites, ISCAFilter<MixedComposite> compositeFilter, ISCAFilter<MixedComponent> componentFilter, ISCAFilter<MixedItem> itemFilter) {
        MixedComposite newComposite;
        ArrayList<MixedComposite> mixedCompositeList = new ArrayList<MixedComposite>();
        for (Composite composite : emfComposites) {
            newComposite = new MixedComposite(composite);
            newComposite.setFilters(componentFilter, itemFilter);
            if (compositeFilter != null && !compositeFilter.accept((Object)newComposite)) continue;
            mixedCompositeList.add(newComposite);
        }
        for (org.apache.tuscany.sca.assembly.Composite composite : scaComposites) {
            newComposite = new MixedComposite(composite);
            newComposite.setFilters(componentFilter, itemFilter);
            if (compositeFilter != null && !compositeFilter.accept((Object)newComposite)) continue;
            mixedCompositeList.add(newComposite);
        }
        return mixedCompositeList;
    }

    public static ISCAFilter<MixedComponent> getComponentMultiFilter(EObject parent) {
        ArrayList filterList = new ArrayList();
        filterList.add(new HasChildrenFilter(true));
        filterList.add(new ComponentAlreadyInListFilter(parent));
        return new MultiFilter<MixedComponent>(filterList);
    }

    public static ISCAFilter<MixedItem> getItemMultiFilter(EObject parent) {
        ArrayList filterList = new ArrayList();
        filterList.add(new HasSameComponentFilter(parent));
        filterList.add(new TargetAlreadyInListFilter(parent));
        return new MultiFilter<MixedItem>(filterList);
    }

    public static List<String> addStrings(String newString, List<String> nameList) {
        TreeSet<String> nameSet = new TreeSet<String>();
        nameSet.add(newString);
        if (nameList != null) {
            nameSet.addAll(nameList);
        }
        return new ArrayList<String>(nameSet);
    }

    public static List<MixedComposite> getRootComposites(EObject parent, ISCAFilter<MixedComposite> compositeFilter, ISCAFilter<MixedComponent> componentFilter, ISCAFilter<MixedItem> itemFilter) {
        ISCAComposite scaComposite = SCAModelUtil.getComposite((IFile)ResourceUtil.getEmfIFile(parent));
        Composite emfComposite = ScaUtil.getComposite(parent);
        List includeList = SCAModelUtil.getIncludedComposites((ISCAComposite)scaComposite, MixedUtils.getEmfIncludes(emfComposite));
        ArrayList<Composite> emfList = new ArrayList<Composite>();
        emfList.add(emfComposite);
        return MixedUtils.combineComposites(MixedUtils.convertToModelList(includeList), emfList, compositeFilter, componentFilter, itemFilter);
    }

    private static List<QName> getEmfIncludes(Composite emfComposite) {
        ArrayList<QName> qnames = new ArrayList<QName>();
        EList includes = emfComposite.getInclude();
        for (Include include : includes) {
            qnames.add(include.getName());
        }
        return qnames;
    }

    private static List<org.apache.tuscany.sca.assembly.Composite> convertToModelList(List<ISCAComposite> compositeList) {
        ArrayList<org.apache.tuscany.sca.assembly.Composite> modelList = new ArrayList<org.apache.tuscany.sca.assembly.Composite>();
        for (ISCAComposite comp : compositeList) {
            try {
                modelList.add((org.apache.tuscany.sca.assembly.Composite)comp.getModelObject());
            }
            catch (CoreException exc) {
                exc.printStackTrace();
            }
        }
        return modelList;
    }
}

