/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.mixed;

import com.ibm.ccl.sca.composite.emf.sca.Composite;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedComponent;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedElement;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedItem;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedService;
import com.ibm.ccl.sca.core.model.ISCAFilter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Service;
import org.eclipse.emf.common.util.EList;

public class MixedComposite
implements MixedElement {
    private Composite emfComposite;
    private org.apache.tuscany.sca.assembly.Composite scaComposite;
    private ISCAFilter<MixedComponent> componentFilter;
    private ISCAFilter<MixedItem> itemFilter;

    public MixedComposite(org.apache.tuscany.sca.assembly.Composite composite) {
        this.scaComposite = composite;
    }

    public MixedComposite(Composite composite) {
        this.emfComposite = composite;
    }

    public void setFilters(ISCAFilter<MixedComponent> compFilter, ISCAFilter<MixedItem> itemFilter) {
        this.componentFilter = compFilter;
        this.itemFilter = itemFilter;
    }

    @Override
    public boolean hasMixedItem(boolean forServiceItems, boolean useFilter) {
        boolean result = false;
        for (MixedComponent component : this.getComponents()) {
            if (!component.hasMixedItem(forServiceItems, useFilter)) continue;
            result = true;
            break;
        }
        return result;
    }

    public QName getName() {
        QName result = null;
        if (this.scaComposite != null) {
            result = this.scaComposite.getName();
        } else if (this.emfComposite != null) {
            result = new QName(this.emfComposite.getTargetNamespace(), this.emfComposite.getName());
        }
        return result;
    }

    public String getDisplayName() {
        QName name = this.getName();
        return String.valueOf(name.getLocalPart()) + " - " + name.getNamespaceURI();
    }

    public List<MixedService> getServices() {
        ArrayList<MixedService> result;
        block3: {
            block2: {
                result = new ArrayList<MixedService>();
                if (this.scaComposite == null) break block2;
                List services = this.scaComposite.getServices();
                for (Service service : services) {
                    result.add(new MixedService(service));
                }
                break block3;
            }
            if (this.emfComposite == null) break block3;
            EList services = this.emfComposite.getService();
            for (com.ibm.ccl.sca.composite.emf.sca.Service service : services) {
                result.add(new MixedService(service));
            }
        }
        return result;
    }

    public List<MixedComponent> getComponents() {
        ArrayList<MixedComponent> result;
        block3: {
            block2: {
                result = new ArrayList<MixedComponent>();
                if (this.scaComposite == null) break block2;
                List compList = this.scaComposite.getComponents();
                for (Component comp : compList) {
                    MixedComponent newComponent = new MixedComponent(comp, this);
                    newComponent.setFilter(this.itemFilter);
                    if (this.componentFilter != null && !this.componentFilter.accept((Object)newComponent)) continue;
                    result.add(newComponent);
                }
                break block3;
            }
            if (this.emfComposite == null) break block3;
            EList compList = this.emfComposite.getComponent();
            for (com.ibm.ccl.sca.composite.emf.sca.Component comp : compList) {
                MixedComponent newComponent = new MixedComponent(comp, this);
                newComponent.setFilter(this.itemFilter);
                if (this.componentFilter != null && !this.componentFilter.accept((Object)newComponent)) continue;
                result.add(newComponent);
            }
        }
        return result;
    }
}

