/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.layout;

import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentRelatedFigureConstants;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class VerticalComponentChildGroupingFigureLayout
extends FlowLayout {
    public VerticalComponentChildGroupingFigureLayout() {
        super(false);
        this.setMajorSpacing(0);
        this.setMinorSpacing(0);
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        int index = 0;
        while (index < this.data.rowCount) {
            IFigure item = this.data.row[index];
            if (item.equals(child)) break;
            ++index;
        }
        int y = index * ComponentRelatedFigureConstants.VERTICAL_CHEVRON_COMPONENT_SPACING;
        Rectangle b = new Rectangle(bounds.x, y += bounds.y, bounds.width, bounds.height);
        child.setBounds(new Rectangle(b));
    }

    public void layout(IFigure parent) {
        super.layout(parent);
    }

    protected Dimension calculatePreferredSize(IFigure container, int hint, int hint2) {
        int totalHeight = 0;
        int maxChildWidth = 0;
        int combinedChildHeight = 0;
        int numberOfChildren = 0;
        for (IFigure fig : container.getChildren()) {
            Dimension figDimension = fig.getPreferredSize();
            combinedChildHeight += figDimension.height;
            if (figDimension.width > maxChildWidth) {
                maxChildWidth = figDimension.width;
            }
            ++numberOfChildren;
        }
        if (numberOfChildren > 1) {
            int spacing = (numberOfChildren - 1) * ComponentRelatedFigureConstants.VERTICAL_CHEVRON_COMPONENT_SPACING;
            totalHeight = spacing + combinedChildHeight;
        } else if (numberOfChildren == 1) {
            totalHeight = combinedChildHeight;
        }
        return new Dimension(maxChildWidth, totalHeight);
    }
}

