/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.layout;

import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentReferenceGroupingFigure;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentRelatedFigureConstants;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentServiceGroupingFigure;
import com.ibm.ccl.sca.composite.ui.custom.figures.InnerComponentFigure;
import com.ibm.ccl.sca.composite.ui.custom.figures.PropertiesComponentFigure;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class ComponentFigureLayout
extends AbstractLayout {
    protected Dimension calculatePreferredSize(IFigure container, int hint, int hint2) {
        int width = 0;
        int height = 0;
        for (Object o : container.getParent().getChildren()) {
            IFigure fig = (IFigure)o;
            if (o.equals(container)) continue;
            Dimension dimension = fig.getPreferredSize(hint, hint2);
            if (fig instanceof ComponentReferenceGroupingFigure || fig instanceof ComponentServiceGroupingFigure) {
                dimension = new Dimension(dimension.width, dimension.height + ComponentRelatedFigureConstants.VERTICAL_CHEVRON_COMPONENT_TOP_MARGIN + ComponentRelatedFigureConstants.VERTICAL_CHEVRON_COMPONENT_BOTTOM_MARGIN - 4);
            }
            if (dimension.width > width) {
                width = dimension.width;
            }
            if (dimension.height <= height) continue;
            height = dimension.height;
        }
        if (width != 0 && height != 0) {
            return new Dimension(width, height);
        }
        return new Dimension(ComponentRelatedFigureConstants.COMPONENT_MINIMUM_WIDTH, ComponentRelatedFigureConstants.COMPONENT_WITH_HUMP_MINIMUM_HEIGHT);
    }

    public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
        return this.calculatePreferredSize(container, wHint, hHint);
    }

    public void layout(IFigure container) {
        List children = container.getChildren();
        Rectangle componentBounds = container.getBounds();
        int index = 0;
        while (index < children.size()) {
            if (children.get(index) instanceof PropertiesComponentFigure) {
                IFigure propertiesFigure = (IFigure)children.get(index);
                propertiesFigure.setLocation(this.calculatePropertiesLocation(componentBounds, propertiesFigure));
                propertiesFigure.setSize(propertiesFigure.getPreferredSize());
            } else if (children.get(index) instanceof InnerComponentFigure) {
                IFigure figg = (IFigure)children.get(index);
                figg.setLocation(this.calculateInnerComponentFigureLocation(componentBounds, figg));
                figg.setSize(this.calculateInnerComponentSize(componentBounds));
            }
            ++index;
        }
    }

    protected Point calculateImplImageLocation(Rectangle parentBounds, IFigure fig) {
        Rectangle imageFigureBounds = fig.getBounds();
        int imageX = parentBounds.x + parentBounds.width / 2 - imageFigureBounds.width / 2;
        int imageY = parentBounds.y + parentBounds.height - imageFigureBounds.height;
        return new Point(imageX, imageY);
    }

    protected Point calculatePropertiesLocation(Rectangle parentBounds, IFigure child) {
        int x = parentBounds.x + parentBounds.width / 2 - child.getPreferredSize().width / 2;
        int y = parentBounds.y;
        return new Point(x, y);
    }

    protected Point calculateInnerComponentFigureLocation(Rectangle parentBounds, IFigure child) {
        return new Point(parentBounds.x, parentBounds.y + ComponentRelatedFigureConstants.INNER_COMPONENT_FIGURE_TOP_VERTICAL_OFFSET);
    }

    protected Dimension calculateInnerComponentSize(Rectangle parentBounds) {
        int width = parentBounds.width;
        int innerHeight = parentBounds.height - ComponentRelatedFigureConstants.INNER_COMPONENT_FIGURE_TOP_VERTICAL_OFFSET;
        innerHeight -= ComponentRelatedFigureConstants.INNER_COMPONENT_FIGURE_BOTTOM_VERTICAL_OFFSET;
        return new Dimension(width, innerHeight -= ComponentRelatedFigureConstants.VERTICAL_IMPLEMENTATION_BOTTOM_HUMP);
    }
}

