/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.figures;

import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentRelatedFigureConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.swt.graphics.Color;

public class ComponentFigure
extends DefaultSizeNodeFigure {
    private Label tooltipLabel;
    private IFigure componentFigure;
    private boolean myUseLocalCoordinates = false;
    int innerBorderWidth = 2;
    int outerBorderWidth = 1;
    int totalBorderWidth = this.innerBorderWidth + this.outerBorderWidth;

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds();
        r = new Rectangle(r.x, r.y, r.width - 1, r.height - 1);
        g.setForegroundColor(ComponentRelatedFigureConstants.COMPONENT_FOREGROUND_COLOR);
        this.drawRoundedRectangle(g, r, ComponentRelatedFigureConstants.IMPLEMENTATION_HUMP_HORIZONTAL_WIDTH, ComponentRelatedFigureConstants.COMPONENT_ARC_WIDTH, ComponentRelatedFigureConstants.COMPONENT_ARC_HEIGHT, 1);
        this.componentFigure = this;
    }

    public ComponentFigure() {
        super(ComponentRelatedFigureConstants.COMPONENT_MINIMUM_WIDTH, ComponentRelatedFigureConstants.COMPONENT_WITH_HUMP_MINIMUM_HEIGHT);
        this.tooltipLabel = new Label();
    }

    protected boolean useLocalCoordinates() {
        return this.myUseLocalCoordinates;
    }

    protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
        this.myUseLocalCoordinates = useLocalCoordinates;
    }

    protected void drawRoundedRectangle(Graphics g, Rectangle rectangle, int implHorizontalWidth, int arcWidth, int arcHeight, int lineWidth) {
        int x = rectangle.x;
        int y = rectangle.y;
        int width = rectangle.width;
        int height = rectangle.height;
        g.setLineWidth(lineWidth);
        height = height < ComponentRelatedFigureConstants.COMPONENT_WITH_HUMP_MINIMUM_HEIGHT ? ComponentRelatedFigureConstants.COMPONENT_MINIMUM_HEIGHT : (height -= ComponentRelatedFigureConstants.VERTICAL_IMPLEMENTATION_BOTTOM_HUMP);
        int spacing = implHorizontalWidth + 8;
        if (arcWidth < width) {
            g.drawLine(x + arcWidth / 2, y, x + width - arcWidth / 2, y);
            int spacingStartX = x + width / 2 - spacing / 2;
            int spacingEndX = x + width / 2 + spacing / 2 + 1;
            g.drawLine(x + arcWidth / 2, y + height, spacingStartX, y + height);
            g.drawLine(spacingEndX, y + height, x + width - arcWidth / 2, y + height);
            int xIndex = 0;
            int yIndex = 1;
            int humpX = spacingStartX;
            int humpY = y + height;
            int[] hump = new int[18];
            hump[0] = humpX;
            hump[1] = humpY;
            hump[xIndex += 2] = hump[xIndex - 2] + 1;
            hump[yIndex += 2] = hump[yIndex - 2] + 1;
            hump[xIndex += 2] = hump[xIndex - 2] + 1;
            hump[yIndex += 2] = hump[yIndex - 2] + 3;
            hump[xIndex += 2] = hump[xIndex - 2] + 2;
            hump[yIndex += 2] = hump[yIndex - 2] + 1;
            hump[xIndex += 2] = hump[xIndex - 2] + implHorizontalWidth;
            hump[yIndex += 2] = hump[yIndex - 2];
            hump[xIndex += 2] = hump[xIndex - 2] + 2;
            hump[yIndex += 2] = hump[yIndex - 2] - 1;
            hump[xIndex += 2] = hump[xIndex - 2] + 1;
            hump[yIndex += 2] = hump[yIndex - 2] - 3;
            hump[xIndex += 2] = hump[xIndex - 2] + 1;
            hump[yIndex += 2] = hump[yIndex - 2] - 1;
            hump[xIndex += 2] = hump[xIndex - 2] + 1;
            hump[yIndex += 2] = hump[yIndex - 2];
            g.drawPolyline(hump);
        }
        if (arcHeight < height) {
            g.drawLine(x, y + arcHeight / 2, x, y + height - arcHeight / 2);
            g.drawLine(x + width, y + arcHeight / 2, x + width, y + height - arcHeight / 2);
        }
        if (arcWidth != 0 && arcHeight != 0) {
            g.drawArc(x, y, arcWidth, arcHeight, 90, 90);
            g.drawArc(x + width - arcWidth, y, arcWidth, arcHeight, 0, 90);
            g.drawArc(x + width - arcWidth, y + height - arcHeight, arcWidth, arcHeight, 0, -90);
            g.drawArc(x, y + height - arcHeight, arcWidth, arcHeight, 180, 90);
        }
    }

    private void drawTopBorderLine(Graphics g, int x, int y, int width, int height, int arcWidth, int borderWidth, Color color) {
        int[] p;
        p = new int[]{x + this.totalBorderWidth + arcWidth / 2 - 2, y, x + this.totalBorderWidth + width - arcWidth / 2 - 2 * this.totalBorderWidth + 2, p[1], p[2], p[3] + borderWidth, p[0], p[5], p[0], p[1]};
        g.setBackgroundColor(color);
        g.fillPolygon(p);
    }

    private void drawLeftBorderLine(Graphics g, int x, int y, int width, int height, int lineWidth, Color color) {
        int[] p;
        p = new int[]{x, y + this.totalBorderWidth, p[0], p[1] + height - 2 * this.totalBorderWidth, p[2] + lineWidth, p[3], p[4], p[1], p[0], p[1]};
        g.setBackgroundColor(color);
        g.fillPolygon(p);
    }

    private void drawRightBorderLine(Graphics g, int x, int y, int width, int height, Color color) {
        int[] p;
        p = new int[]{x + width - this.totalBorderWidth, y + this.totalBorderWidth, p[0] + 2, p[1], p[2], y + height - this.totalBorderWidth, p[0], p[5], p[0], p[1]};
        g.setBackgroundColor(color);
        g.fillPolygon(p);
        g.setForegroundColor(color);
        g.drawLine(x + width - 1, p[1], x + width - 1, p[5]);
    }

    private void drawBottomLeftBorderLine(Graphics g, int x, int y, int width, int height, int arcWidth, int lineWidth, int spacingStartX, Color color) {
        int[] p;
        p = new int[]{x + 1 + arcWidth / 2, y + height - this.totalBorderWidth + 1, spacingStartX, p[1], p[2], p[3] + 2, p[0], p[5], p[0], p[1]};
        g.setBackgroundColor(color);
        g.fillPolygon(p);
        g.setForegroundColor(color);
        g.drawLine(p[0], p[5], p[2], p[5]);
    }

    private void drawBottomRightBorderLine(Graphics g, int x, int y, int width, int height, int arcWidth, int lineWidth, int spacingEndX, Color color) {
        int[] p;
        p = new int[]{spacingEndX - this.totalBorderWidth, y + height - this.totalBorderWidth + 1, x + width - arcWidth / 2 - 1, p[1], p[2], p[3] + lineWidth, p[0], p[5], p[0], p[1]};
        g.setBackgroundColor(color);
        g.setForegroundColor(color);
        g.fillPolygon(p);
        g.drawLine(p[0], p[5], p[2], p[5]);
    }

    private void drawImplementationHumpBorderLine(Graphics g, int spacingStartX, int y, int implHorizontalWidth, int height, Color color) {
        int xIndex = 0;
        int yIndex = 1;
        int humpX = spacingStartX + 1;
        int humpY = y + height - 2;
        int[] hump = new int[38];
        hump[0] = humpX;
        hump[1] = humpY;
        hump[xIndex += 2] = hump[xIndex - 2] + 1;
        hump[yIndex += 2] = hump[yIndex - 2] + 1;
        hump[xIndex += 2] = hump[xIndex - 2] + 1;
        hump[yIndex += 2] = hump[yIndex - 2] + 3;
        hump[xIndex += 2] = hump[xIndex - 2] + 2;
        hump[yIndex += 2] = hump[yIndex - 2] + 1;
        hump[xIndex += 2] = hump[xIndex - 2] + implHorizontalWidth - 2;
        hump[yIndex += 2] = hump[yIndex - 2];
        hump[xIndex += 2] = hump[xIndex - 2] + 2;
        hump[yIndex += 2] = hump[yIndex - 2] - 1;
        hump[xIndex += 2] = hump[xIndex - 2] + 1;
        hump[yIndex += 2] = hump[yIndex - 2] - 3;
        hump[xIndex += 2] = hump[xIndex - 2] + 1;
        hump[yIndex += 2] = hump[yIndex - 2] - 1;
        hump[xIndex += 2] = hump[xIndex - 2] + 2;
        hump[yIndex += 2] = hump[yIndex - 2];
        hump[xIndex += 2] = hump[xIndex - 2];
        hump[yIndex += 2] = hump[yIndex - 2] + 2;
        hump[xIndex += 2] = hump[xIndex - 2] - 1;
        hump[yIndex += 2] = hump[yIndex - 2] + 3;
        hump[xIndex += 2] = hump[xIndex - 2] - 2;
        hump[yIndex += 2] = hump[yIndex - 2] + 2;
        hump[xIndex += 2] = hump[xIndex - 2] - 1;
        hump[yIndex += 2] = hump[yIndex - 2] + 1;
        hump[xIndex += 2] = hump[xIndex - 2] - implHorizontalWidth - 1;
        hump[yIndex += 2] = hump[yIndex - 2];
        hump[xIndex += 2] = hump[xIndex - 2] - 1;
        hump[yIndex += 2] = hump[yIndex - 2] - 1;
        hump[xIndex += 2] = hump[xIndex - 2] - 2;
        hump[yIndex += 2] = hump[yIndex - 2] - 2;
        hump[xIndex += 2] = hump[xIndex - 2];
        hump[yIndex += 2] = hump[yIndex - 2] - 2;
        hump[xIndex += 2] = hump[xIndex - 2] - 1;
        hump[yIndex += 2] = hump[yIndex - 2] - 3;
        hump[xIndex += 2] = hump[0];
        hump[yIndex += 2] = hump[1];
        g.setBackgroundColor(color);
        g.fillPolygon(hump);
    }

    private void drawImplementationHumpBorderLine2(Graphics g, int spacingStartX, int y, int implHorizontalWidth, int height, Color color) {
        int xIndex = 0;
        int yIndex = 1;
        int humpX = spacingStartX + 2;
        int humpY = y + height - 1;
        int[] hump = new int[34];
        hump[0] = humpX;
        hump[1] = humpY;
        hump[xIndex += 2] = hump[xIndex - 2] + 1;
        hump[yIndex += 2] = hump[yIndex - 2] + 1;
        hump[xIndex += 2] = hump[xIndex - 2] + 1;
        hump[yIndex += 2] = hump[yIndex - 2] + 3;
        hump[xIndex += 2] = hump[xIndex - 2] + 2;
        hump[yIndex += 2] = hump[yIndex - 2] + 1;
        hump[xIndex += 2] = hump[xIndex - 2] + implHorizontalWidth - 3;
        hump[yIndex += 2] = hump[yIndex - 2];
        hump[xIndex += 2] = hump[xIndex - 2] + 2;
        hump[yIndex += 2] = hump[yIndex - 2] - 1;
        hump[xIndex += 2] = hump[xIndex - 2] + 1;
        hump[yIndex += 2] = hump[yIndex - 2] - 3;
        hump[xIndex += 2] = hump[xIndex - 2] + 1;
        hump[yIndex += 2] = hump[yIndex - 2] - 1;
        hump[xIndex += 2] = hump[xIndex - 2] + 1;
        hump[yIndex += 2] = hump[yIndex - 2];
        hump[xIndex += 2] = hump[xIndex - 2] - 1;
        hump[yIndex += 2] = hump[yIndex - 2] + 2;
        hump[xIndex += 2] = hump[xIndex - 2] - 1;
        hump[yIndex += 2] = hump[yIndex - 2] + 3;
        hump[xIndex += 2] = hump[xIndex - 2] - 3;
        hump[yIndex += 2] = hump[yIndex - 2] + 1;
        hump[xIndex += 2] = hump[xIndex - 2] - implHorizontalWidth + 5 - 2;
        hump[yIndex += 2] = hump[yIndex - 2];
        hump[xIndex += 2] = hump[xIndex - 2] - 3;
        hump[yIndex += 2] = hump[yIndex - 2] - 1;
        hump[xIndex += 2] = hump[xIndex - 2] - 1;
        hump[yIndex += 2] = hump[yIndex - 2] - 3;
        hump[xIndex += 2] = hump[xIndex - 2] - 1;
        hump[yIndex += 2] = hump[yIndex - 2] - 2;
        hump[xIndex += 2] = hump[0];
        hump[yIndex += 2] = hump[1];
        g.setBackgroundColor(color);
        g.fillPolygon(hump);
    }

    protected void drawRoundedRectangleBorder(Graphics g, Rectangle rectangle, int implHorizontalWidth, int arcWidth, int arcHeight, ZoomManager zoomManager, Color outerBorderColor, Color innerBorderColor) {
        int x = rectangle.x;
        int y = rectangle.y;
        int width = rectangle.width;
        int height = rectangle.height;
        Color originalBackgroundColor = g.getBackgroundColor();
        height = height < ComponentRelatedFigureConstants.COMPONENT_WITH_HUMP_MINIMUM_HEIGHT ? ComponentRelatedFigureConstants.COMPONENT_MINIMUM_HEIGHT : (height -= ComponentRelatedFigureConstants.VERTICAL_IMPLEMENTATION_BOTTOM_HUMP);
        int spacing = implHorizontalWidth + 8;
        int spacingStartX = x + width / 2 - spacing / 2;
        int spacingEndX = x + width / 2 + spacing / 2 + 1;
        this.drawTopBorderLine(g, x, y - 1, width, height, arcWidth, 1, outerBorderColor);
        this.drawTopBorderLine(g, x, y, width, height, arcWidth, 2, innerBorderColor);
        this.drawBottomLeftBorderLine(g, x - 1, y + 1, width, height, arcWidth, 2, spacingStartX + this.totalBorderWidth - 3, outerBorderColor);
        this.drawLeftBorderLine(g, x - 1, y, width, height + 1, 1, outerBorderColor);
        this.drawLeftBorderLine(g, x, y, width, height, 2, innerBorderColor);
        this.drawRightBorderLine(g, x + 1, y - 1, width, height + 2, outerBorderColor);
        this.drawRightBorderLine(g, x, y, width, height, innerBorderColor);
        this.drawImplementationHumpBorderLine(g, spacingStartX, y, implHorizontalWidth, height, innerBorderColor);
        this.drawImplementationHumpBorderLine2(g, spacingStartX - 2, y + 1, implHorizontalWidth + 4, height, outerBorderColor);
        this.drawBottomRightBorderLine(g, x, y + 1, width, height, arcWidth, 2, spacingEndX + 3, outerBorderColor);
        this.drawBottomRightBorderLine(g, x, y, width, height, arcWidth, 2, spacingEndX, innerBorderColor);
        this.drawBottomLeftBorderLine(g, x, y, width, height, arcWidth, 2, spacingStartX + this.totalBorderWidth - 1, innerBorderColor);
        g.setBackgroundColor(outerBorderColor);
        g.fillArc(x - 1, y - 1, arcWidth + 5, arcHeight + 5, 90, 90);
        g.setBackgroundColor(innerBorderColor);
        g.fillArc(x, y, arcWidth + 4, arcHeight + 4, 90, 90);
        g.setBackgroundColor(outerBorderColor);
        g.fillArc(x + width - arcWidth - 3, y - 1, arcWidth + 4, arcHeight + 4, 0, 90);
        g.setBackgroundColor(innerBorderColor);
        g.fillArc(x + width - arcWidth - 4, y, arcWidth + 4, arcHeight + 3, 0, 90);
        g.setBackgroundColor(outerBorderColor);
        g.fillArc(x + width - arcWidth - 2 - 1, y + height - arcHeight - 3, arcWidth + 3 + 1, arcHeight + 5, 0, -90);
        g.setBackgroundColor(innerBorderColor);
        g.fillArc(x + width - arcWidth - 3, y + height - arcHeight - 3, arcWidth + 3, arcHeight + 4, 0, -90);
        g.setBackgroundColor(outerBorderColor);
        g.fillArc(x - 1, y + height - arcHeight - 2, arcWidth + 3, arcHeight + 4, 180, 90);
        g.setBackgroundColor(innerBorderColor);
        g.fillArc(x, y + height - arcHeight - 3, arcWidth + 3, arcHeight + 4, 180, 90);
        g.setBackgroundColor(originalBackgroundColor);
        g.fillArc(x + 2, y + 2, arcWidth + 1, arcHeight + 1, 90, 90);
        g.fillArc(x + width - arcWidth - 9, y + 2, arcWidth + 7, arcHeight, 0, 90);
        g.fillArc(x + width - arcWidth - 2, y + height - arcHeight - 7, arcWidth, arcHeight + 6, 0, -90);
        g.fillArc(x + 2, y + height - arcHeight - 2, arcWidth + 4, arcHeight + 1, 180, 90);
    }

    public IFigure getSelectionFeedbackFigure(ZoomManager zoomManager) {
        return new ComponentFeedbackFigure(zoomManager, true);
    }

    public IFigure getHoverFeedbackFigure(ZoomManager zoomManager) {
        return new ComponentFeedbackFigure(zoomManager, false);
    }

    public void setHoverTooltipString(String string) {
        if (string == null) {
            this.setToolTip(null);
        } else {
            if (this.getToolTip() == null) {
                this.setToolTip((IFigure)this.tooltipLabel);
            }
            this.tooltipLabel.setText(string);
        }
    }

    public class ComponentFeedbackFigure
    extends Figure {
        private ZoomManager zoomManager;
        Color innerBorderColor;
        Color outerBorderColor;

        public ComponentFeedbackFigure(ZoomManager zoomManager, boolean isSelection) {
            this.zoomManager = zoomManager;
            if (isSelection) {
                this.innerBorderColor = ComponentRelatedFigureConstants.COMPONENT_SELECTION_INNER_BORDER_COLOR;
                this.outerBorderColor = ComponentRelatedFigureConstants.COMPONENT_SELECTION_OUTER_BORDER_COLOR;
            } else {
                this.innerBorderColor = ComponentRelatedFigureConstants.COMPONENT_HOVER_INNER_BORDER_COLOR;
                this.outerBorderColor = ComponentRelatedFigureConstants.COMPONENT_HOVER_OUTER_BORDER_COLOR;
            }
        }

        public Rectangle getBounds() {
            if (ComponentFigure.this.componentFigure == null) {
                return new Rectangle(0, 0, 0, 0);
            }
            Rectangle componentBounds = ComponentFigure.this.componentFigure.getBounds();
            Rectangle newBounds = new Rectangle();
            newBounds.x = componentBounds.x - ComponentFigure.this.totalBorderWidth;
            newBounds.y = componentBounds.y - ComponentFigure.this.totalBorderWidth;
            newBounds.width = componentBounds.width + ComponentFigure.this.totalBorderWidth * 2 + 1;
            newBounds.height = componentBounds.height + ComponentFigure.this.totalBorderWidth * 2;
            return newBounds;
        }

        public void paintFigure(Graphics g) {
            Rectangle borderBounds = this.getBounds();
            Rectangle paintBorderBounds = new Rectangle();
            paintBorderBounds.x = borderBounds.x;
            paintBorderBounds.y = borderBounds.y;
            paintBorderBounds.width = borderBounds.width - 1;
            paintBorderBounds.height = borderBounds.height - 1;
            Rectangle bounds2 = new Rectangle();
            bounds2.x = paintBorderBounds.x + 1;
            bounds2.y = paintBorderBounds.y + 1;
            bounds2.width = paintBorderBounds.width - 2;
            bounds2.height = paintBorderBounds.height - 2;
            Rectangle r = this.getBounds();
            r = new Rectangle(r.x, r.y, r.width - 1, r.height - 1);
            ComponentFigure.this.drawRoundedRectangleBorder(g, bounds2, ComponentRelatedFigureConstants.IMPLEMENTATION_HUMP_HORIZONTAL_WIDTH + 2, ComponentRelatedFigureConstants.COMPONENT_ARC_WIDTH, ComponentRelatedFigureConstants.COMPONENT_ARC_HEIGHT, this.zoomManager, this.outerBorderColor, this.innerBorderColor);
        }
    }
}

