/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.interfaze;

import com.ibm.ccl.sca.composite.emf.sca.Interface;
import com.ibm.ccl.sca.composite.emf.sca.JavaInterface;
import com.ibm.ccl.sca.composite.emf.sca.WSDLPortType;
import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAAddAndSetJavaInterfaceAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAAddAndSetWSDLInterfaceAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAAddJavaInterfaceAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAAddWSDLInterfaceAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAEditInterfaceCallbackAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAEditInterfaceValueAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCALaunchSelectionDialogAction;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.core.interfacetypes.InterfaceType;
import com.ibm.ccl.sca.core.plugin.SCAToolsCorePlugin;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialog;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialogFactory;
import com.ibm.ccl.sca.ui.contributions.UIContributionRegistry;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class SCAInterfaceExtensibilityUtil {
    private static String WSDL = "WSDL";
    private static String JAVA = "Java";

    public List<String> getInterfaceLabels() {
        List types = SCAToolsCorePlugin.getInstance().getInterfaceRegistry().getInterfaceTypes();
        ArrayList<String> labels = new ArrayList<String>();
        int i = 0;
        while (i < types.size()) {
            labels.add(((InterfaceType)types.get(i)).getName());
            ++i;
        }
        return labels;
    }

    public String getInterfaceLabel(Object object) {
        if (object instanceof JavaInterface) {
            return JAVA;
        }
        if (object instanceof WSDLPortType) {
            return WSDL;
        }
        return "";
    }

    public String getInterfaceValue(Object object) {
        if (object instanceof JavaInterface) {
            return ((JavaInterface)object).getInterface();
        }
        if (object instanceof WSDLPortType) {
            return ((WSDLPortType)object).getInterface();
        }
        return "";
    }

    public String getCallbackInterfaceValue(Object object) {
        if (object instanceof JavaInterface) {
            return ((JavaInterface)object).getCallbackInterface();
        }
        if (object instanceof WSDLPortType) {
            return ((WSDLPortType)object).getCallbackInterface();
        }
        return "";
    }

    public SCALaunchSelectionDialogAction getSelectInterfaceDialogAction(String label) {
        ISelectionDialogFactory wsdlDialogFactory;
        UIContributionRegistry uiContributionRegistry = SCAToolsUIPlugin.getUIContributionRegistry();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        HashMap<String, IFile> dataMap = new HashMap<String, IFile>();
        dataMap.put("CURRENT_RESOURCE", ScaUtil.getIFile());
        if (label.equals(JAVA)) {
            ISelectionDialogFactory javaDialogFactory = uiContributionRegistry.getInterfaceSelectionDialogFactoryById("com.ibm.ccl.sca.core.interfacetype.java");
            if (javaDialogFactory != null) {
                ISelectionDialog dialog = javaDialogFactory.createSelectionDialog(shell, dataMap);
                return new SCALaunchSelectionDialogAction(this.getWorkbenchPart(), dialog);
            }
        } else if (label.equals(WSDL) && (wsdlDialogFactory = uiContributionRegistry.getInterfaceSelectionDialogFactoryById("com.ibm.ccl.sca.core.interfacetype.wsdl")) != null) {
            ISelectionDialog dialog2 = wsdlDialogFactory.createSelectionDialog(shell, dataMap);
            return new SCALaunchSelectionDialogAction(this.getWorkbenchPart(), dialog2);
        }
        return null;
    }

    public Action getSetCallbackInterfaceValueAction(String label, Interface interfaze, String newValue) {
        if (label.equals(JAVA)) {
            SCAEditInterfaceCallbackAction action = new SCAEditInterfaceCallbackAction(this.getWorkbenchPart(), Messages.SCABaseInterfacePropertySection_18, interfaze, newValue);
            return action;
        }
        if (label.equals(WSDL)) {
            SCAEditInterfaceCallbackAction action = new SCAEditInterfaceCallbackAction(this.getWorkbenchPart(), Messages.SCABaseInterfacePropertySection_18, interfaze, newValue);
            return action;
        }
        return null;
    }

    public Action getAddInterfaceAction(String label, Object parentObject) {
        if (label.equals(JAVA)) {
            SCAAddJavaInterfaceAction action = new SCAAddJavaInterfaceAction(this.getWorkbenchPart(), parentObject);
            return action;
        }
        if (label.equals(WSDL)) {
            SCAAddWSDLInterfaceAction action = new SCAAddWSDLInterfaceAction(this.getWorkbenchPart(), parentObject);
            return action;
        }
        return null;
    }

    public Action getSetInterfaceValueAction(String label, Interface interfaze, String newValue) {
        if (label.equals(JAVA)) {
            SCAEditInterfaceValueAction action = new SCAEditInterfaceValueAction(this.getWorkbenchPart(), Messages.SCABaseInterfacePropertySection_18, interfaze, newValue);
            return action;
        }
        if (label.equals(WSDL)) {
            SCAEditInterfaceValueAction action = new SCAEditInterfaceValueAction(this.getWorkbenchPart(), Messages.SCABaseInterfacePropertySection_18, interfaze, newValue);
            return action;
        }
        return null;
    }

    public Action getAddAndSetInterfaceAction(String label, Object parentObject) {
        ISelectionDialogFactory wsdlDialogFactory;
        UIContributionRegistry uiContributionRegistry = SCAToolsUIPlugin.getUIContributionRegistry();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        HashMap<String, IFile> dataMap = new HashMap<String, IFile>();
        dataMap.put("CURRENT_RESOURCE", ScaUtil.getIFile());
        if (label.equals(JAVA)) {
            ISelectionDialogFactory javaDialogFactory = uiContributionRegistry.getInterfaceSelectionDialogFactoryById("com.ibm.ccl.sca.core.interfacetype.java");
            if (javaDialogFactory != null) {
                ISelectionDialog dialog = javaDialogFactory.createSelectionDialog(shell, dataMap);
                SCAAddAndSetJavaInterfaceAction action = new SCAAddAndSetJavaInterfaceAction(this.getWorkbenchPart(), Messages.SCABaseInterfacePropertySection_20, parentObject);
                action.setDialog(dialog);
                return action;
            }
        } else if (label.equals(WSDL) && (wsdlDialogFactory = uiContributionRegistry.getInterfaceSelectionDialogFactoryById("com.ibm.ccl.sca.core.interfacetype.wsdl")) != null) {
            SCAAddAndSetWSDLInterfaceAction action = new SCAAddAndSetWSDLInterfaceAction(this.getWorkbenchPart(), Messages.SCABaseInterfacePropertySection_22, parentObject);
            ISelectionDialog dialog2 = wsdlDialogFactory.createSelectionDialog(shell, dataMap);
            action.setDialog(dialog2);
            return action;
        }
        return null;
    }

    public Image getInterfaceIcon(String label) {
        if (!label.equals(JAVA)) {
            label.equals(WSDL);
        }
        return null;
    }

    private IWorkbenchPart getWorkbenchPart() {
        return ScaUtil.getActiveEditor();
    }
}

