/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.composite;

import com.ibm.ccl.sca.composite.emf.sca.Component;
import com.ibm.ccl.sca.composite.emf.sca.Implementation;
import com.ibm.ccl.sca.composite.emf.sca.SCAImplementation;
import com.ibm.ccl.sca.composite.emf.sca.SCAPackage;
import com.ibm.ccl.sca.composite.emf.sca.impl.SCAImplementationImpl;
import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAAddAndSetCompositeImplementationAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAAddCompositeImplementationAction;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.SCAXMLMapInfo;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.IImplementationUIProvider;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.base.controls.IPropertiesSectionAreaExtender;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.composite.CompositeImplPropertiesSectionAreaExtender;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorPlugin;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelManager;
import com.ibm.ccl.sca.core.model.SCAModelUtil;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeSelectionControlFactory;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionDialog;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLInfoImpl;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class CompositeImplementationUIProvider
implements IImplementationUIProvider {
    private RenderedImage renderedImage;
    private CompositeImplPropertiesSectionAreaExtender extender;

    @Override
    public boolean appliesTo(Object object) {
        return object instanceof SCAImplementation;
    }

    @Override
    public IPropertiesSectionAreaExtender getPropertiesSectionAreaExtender() {
        if (this.extender == null) {
            this.extender = new CompositeImplPropertiesSectionAreaExtender();
        }
        return this.extender;
    }

    @Override
    public Action getAddImplementationAction(Component component) {
        IEditorPart part = ScaUtil.getActiveEditor();
        SCAAddCompositeImplementationAction action = new SCAAddCompositeImplementationAction((IWorkbenchPart)part, component);
        return action;
    }

    @Override
    public Action getAddAndSetImplementationAction(Component component) {
        Shell topShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IEditorPart part = ScaUtil.getActiveEditor();
        ICompositeSelectionDialog selectDialog = CompositeSelectionControlFactory.createCompositeSelectionDialogWithSingleSelectTree((Shell)topShell);
        SCAAddAndSetCompositeImplementationAction actionComp = new SCAAddAndSetCompositeImplementationAction((IWorkbenchPart)part, Messages.SCAContextMenuProvider_2, component);
        ImageDescriptor desc = ImageDescriptor.createFromImage((Image)ScaDiagramEditorPlugin.getInstance().getImage("icons/composite_impl_obj.gif"));
        actionComp.setImageDescriptor(desc);
        actionComp.setDialog(selectDialog);
        return actionComp;
    }

    @Override
    public Class getApplicableClass() {
        return SCAImplementationImpl.class;
    }

    @Override
    public String getLabel() {
        return Messages.SCAContextMenuProvider_2;
    }

    @Override
    public RenderedImage getScalableImage() {
        if (this.renderedImage == null) {
            URL url = FileLocator.find((Bundle)ScaDiagramEditorPlugin.getInstance().getBundle(), (IPath)new Path("icons/svg/composite.svg"), null);
            this.renderedImage = RenderedImageFactory.getInstance((URL)url);
        }
        return this.renderedImage;
    }

    @Override
    public void openImplementationEditor(Implementation impl) {
        if (impl instanceof SCAImplementation) {
            SCAImplementation scaImpl = (SCAImplementation)impl;
            String localName = scaImpl.getName().getLocalPart();
            String tns = scaImpl.getName().getNamespaceURI();
            IProject iProject = this.getCurrentIProject((Implementation)scaImpl);
            if (iProject != null) {
                try {
                    IEditorDescriptor editor;
                    SCAModelUtil.getSCAProjectsList();
                    ISCAProject scaProject = SCAModelManager.getLoadedProject((IProject)iProject);
                    Iterator it = SCAModelManager.getComposites((ISCAProject)scaProject).iterator();
                    IFile iFileToOpen = null;
                    while (it.hasNext()) {
                        ISCAComposite iSCAComposite = (ISCAComposite)it.next();
                        if (iSCAComposite.getName() == null) continue;
                        String itemLocalName = iSCAComposite.getName().getLocalPart();
                        String itemTNS = iSCAComposite.getName().getNamespaceURI();
                        if (!itemLocalName.equals(localName) || !itemTNS.equals(tns)) continue;
                        IPath fileToOpenPath = iSCAComposite.getResource().getLocation();
                        iFileToOpen = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(fileToOpenPath);
                    }
                    if (iFileToOpen != null && (editor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(iFileToOpen.getLocation().toOSString(), iFileToOpen.getContentDescription().getContentType())) != null) {
                        FileEditorInput input = new FileEditorInput(iFileToOpen);
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, editor.getId());
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public List<SCAXMLMapInfo> getSCAXMLMapInfo() {
        ArrayList<SCAXMLMapInfo> list = new ArrayList<SCAXMLMapInfo>();
        XMLInfoImpl info = new XMLInfoImpl();
        info.setName("implementation.composite");
        info.setXMLRepresentation(0);
        EClass eClass = SCAPackage.eINSTANCE.getSCAImplementation();
        list.add(new SCAXMLMapInfo(eClass, (XMLResource.XMLInfo)info));
        return list;
    }

    private IProject getCurrentIProject(Implementation impl) {
        String stringPath = impl.eResource().getURI().path();
        if (stringPath.startsWith("/resource/")) {
            Path path = new Path(stringPath);
            path = path.removeFirstSegments(1);
            IPath rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            path = rootLocation.append((IPath)path);
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path).getProject();
            return iProject;
        }
        return null;
    }
}

