/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation;

import com.ibm.ccl.sca.composite.emf.sca.Component;
import com.ibm.ccl.sca.composite.emf.sca.Implementation;
import com.ibm.ccl.sca.composite.emf.sca.JavaImplementation;
import com.ibm.ccl.sca.composite.emf.sca.SCAImplementation;
import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAAddAndSetCompositeImplementationAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAAddAndSetJavaImplementationAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAAddCompositeImplementationAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAAddJavaImplementationAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAEditImplementationNameClassAction;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeSelectionControlFactory;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionDialog;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialog;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialogFactory;
import com.ibm.ccl.sca.ui.contributions.UIContributionRegistry;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class SCAImplementationExtensibilityUtil {
    private static String COMPOSITE = "Composite";
    private static String JAVA = "Java";

    public List<String> getImplementationLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(JAVA);
        labels.add(COMPOSITE);
        return labels;
    }

    public String getImplementationLabel(Object object) {
        if (object instanceof JavaImplementation) {
            return JAVA;
        }
        if (object instanceof SCAImplementation) {
            return COMPOSITE;
        }
        return "";
    }

    public String getImplementationNameLabel(Object object) {
        if (object instanceof JavaImplementation) {
            return Messages.SCABaseImplementationPropertySection_6;
        }
        if (object instanceof SCAImplementation) {
            return Messages.SCABaseImplementationPropertySection_4;
        }
        return Messages.SCABaseImplementationPropertySection_4;
    }

    public String getImplementationValue(Object object) {
        SCAImplementation impl;
        if (object instanceof JavaImplementation) {
            return ((JavaImplementation)object).getClass_();
        }
        if (object instanceof SCAImplementation && (impl = (SCAImplementation)object).getName() != null) {
            return impl.getName().getLocalPart();
        }
        return "";
    }

    public Action getAddImplementationAction(String label, Object parentObject) {
        if (label.equals(JAVA)) {
            SCAAddJavaImplementationAction action = new SCAAddJavaImplementationAction(this.getWorkbenchPart(), (Component)parentObject);
            return action;
        }
        if (label.equals(COMPOSITE)) {
            SCAAddCompositeImplementationAction action = new SCAAddCompositeImplementationAction(this.getWorkbenchPart(), (Component)parentObject);
            return action;
        }
        return null;
    }

    public Action getSetImplementationAction(String label, Implementation impl, String newValue) {
        if (label.equals(JAVA)) {
            SCAEditImplementationNameClassAction action = new SCAEditImplementationNameClassAction(this.getWorkbenchPart(), Messages.SCABaseImplementationPropertySection_19, impl, newValue);
            return action;
        }
        if (label.equals(COMPOSITE)) {
            SCAEditImplementationNameClassAction action = new SCAEditImplementationNameClassAction(this.getWorkbenchPart(), Messages.SCABaseImplementationPropertySection_19, impl, newValue);
            return action;
        }
        return null;
    }

    public Action getAddAndSetImplementationAction(String label, Object parentObject) {
        UIContributionRegistry uiContributionRegistry = SCAToolsUIPlugin.getUIContributionRegistry();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        HashMap<String, IFile> dataMap = new HashMap<String, IFile>();
        dataMap.put("CURRENT_RESOURCE", ScaUtil.getIFile());
        if (label.equals(JAVA)) {
            SCAAddAndSetJavaImplementationAction action = new SCAAddAndSetJavaImplementationAction(this.getWorkbenchPart(), Messages.SCAContextMenuProvider_1, (Component)parentObject);
            ISelectionDialogFactory javaDialogFactory = uiContributionRegistry.getImplementationSelectionDialogFactoryById("implementation.java");
            if (javaDialogFactory != null) {
                ISelectionDialog dialog = javaDialogFactory.createSelectionDialog(shell, dataMap);
                action.setDialog(dialog);
                return action;
            }
        } else if (label.equals(COMPOSITE)) {
            Shell topShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ICompositeSelectionDialog selectDialog = CompositeSelectionControlFactory.createCompositeSelectionDialogWithSingleSelectTree((Shell)topShell);
            SCAAddAndSetCompositeImplementationAction action = new SCAAddAndSetCompositeImplementationAction(this.getWorkbenchPart(), Messages.SCAContextMenuProvider_2, (Component)parentObject);
            action.setDialog(selectDialog);
            return action;
        }
        return null;
    }

    public Image getImplementationIcon(String label) {
        if (!label.equals(JAVA)) {
            label.equals(COMPOSITE);
        }
        return null;
    }

    private IWorkbenchPart getWorkbenchPart() {
        return ScaUtil.getActiveEditor();
    }
}

