/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MultipleTextFieldAndRemoveButtonControls {
    private Object input;
    private Composite parent;
    private GridData parentGridData;
    private Text multiTextField;
    private Button removeButton;
    private boolean isMultiText;
    private Listener textListener;

    public MultipleTextFieldAndRemoveButtonControls(FormToolkit toolkit, Composite client, Object input, boolean isMultiText) {
        this.input = input;
        this.isMultiText = isMultiText;
        this.parent = toolkit.createComposite(client);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.parent.setLayout((Layout)gl);
        this.parentGridData = new GridData(768);
        this.parent.setLayoutData((Object)this.parentGridData);
        GridData gd = new GridData(768);
        if (isMultiText) {
            this.multiTextField = toolkit.createText(this.parent, "", 770);
            gd.heightHint = 55;
        } else {
            this.multiTextField = toolkit.createText(this.parent, "");
        }
        this.multiTextField.setLayoutData((Object)gd);
        this.removeButton = toolkit.createButton(this.parent, "  -  ", 8);
        gd = new GridData();
        gd.verticalAlignment = 1024;
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.setVisible(true);
        toolkit.paintBordersFor(this.parent);
        this.multiTextField.setVisible(true);
    }

    public Object getInput() {
        return this.input;
    }

    public void setTextFieldListener(Listener l) {
        this.textListener = l;
        this.addTextListener();
    }

    private void addTextListener() {
        this.multiTextField.addListener(16, this.textListener);
        if (!this.isMultiText) {
            this.multiTextField.addListener(2, this.textListener);
        }
    }

    private void removeTextListener() {
        this.multiTextField.removeListener(16, this.textListener);
        if (!this.isMultiText) {
            this.multiTextField.removeListener(2, this.textListener);
        }
    }

    public void setTextFieldText(String text) {
        this.removeTextListener();
        this.multiTextField.setText(text);
        this.addTextListener();
    }

    public String getMultiTextFieldString() {
        return this.multiTextField.getText();
    }

    public void setRemoveButtonListener(SelectionListener l) {
        this.removeButton.addSelectionListener(l);
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public Text getTextField() {
        return this.multiTextField;
    }

    public boolean isVisible() {
        return this.multiTextField.isVisible() && this.removeButton.isVisible();
    }

    public void setVisible(boolean visible) {
        this.parent.setVisible(visible);
        this.multiTextField.setVisible(visible);
        if (this.removeButton != null) {
            this.removeButton.setVisible(visible);
        }
        this.parentGridData.exclude = !visible;
    }
}

