/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls;

import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls.DelayedTextModifyListener;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls.MultipleTextFieldAndRemoveButtonControls;
import com.ibm.ccl.sca.composite.ui.custom.util.BasePropertyWrapper;
import com.ibm.ccl.sca.composite.ui.custom.util.LiteralValueProcessor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;

public class MultipleMultiTextControls {
    private BasePropertyWrapper input;
    private Composite mainParent;
    private FormToolkit toolkit;
    private boolean isMultiText;
    private TextListener textListener = new TextListener();
    private AddRemoveButtonListener buttonListener = new AddRemoveButtonListener();
    private LiteralValueProcessor processor;
    private List<MultipleTextFieldAndRemoveButtonControls> controls = new ArrayList<MultipleTextFieldAndRemoveButtonControls>();
    private Composite controlParent;
    private GridData controlParentGridData;
    private Button addButton;
    private Label labelTitle;
    private ScrolledPageBook valuePageBook;

    public MultipleMultiTextControls(ScrolledPageBook valuePageBook, BasePropertyWrapper input, LiteralValueProcessor processor, Composite parent, FormToolkit toolkit, boolean isMultiText, Label labelTitle) {
        this.input = input;
        this.processor = processor;
        this.mainParent = parent;
        this.toolkit = toolkit;
        this.isMultiText = isMultiText;
        this.labelTitle = labelTitle;
        this.valuePageBook = valuePageBook;
    }

    public void setInput(BasePropertyWrapper input, boolean refreshWithValues) {
        this.input = input;
        this.refresh(refreshWithValues);
    }

    public void createContents() {
        this.controlParent = this.toolkit.createComposite(this.mainParent);
        Control[] controlArray = new Control[]{this.labelTitle, this.controlParent};
        this.mainParent.setTabList(controlArray);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        this.controlParent.setLayout((Layout)gl);
        this.controlParentGridData = new GridData(768);
        this.controlParent.setLayoutData((Object)this.controlParentGridData);
        this.addButton = this.toolkit.createButton(this.mainParent, "  +  ", 8);
        this.addButton.addSelectionListener((SelectionListener)this.buttonListener);
        this.mainParent.layout();
    }

    public void refresh(boolean refreshWithValues) {
        List values = new ArrayList();
        if (refreshWithValues) {
            values = this.isMultiText ? this.processor.getComplexValues(this.input) : this.processor.getSimpleValues(this.input);
        }
        int index = 0;
        while (index < values.size()) {
            MultipleTextFieldAndRemoveButtonControls control = null;
            if (index < this.controls.size()) {
                control = this.controls.get(index);
                control.setVisible(true);
            } else {
                control = this.createNewControl();
            }
            String stringValue = (String)values.get(index);
            control.setTextFieldText(stringValue);
            ++index;
        }
        int valuesCount = values.size();
        int controlsCount = this.controls.size();
        int extras = controlsCount - valuesCount;
        int controlsIndex = this.controls.size() - 1;
        while (extras > 0 && controlsIndex >= 0) {
            MultipleTextFieldAndRemoveButtonControls item = this.controls.get(controlsIndex);
            item.setTextFieldText("");
            item.setVisible(false);
            --controlsIndex;
            --extras;
        }
        this.mainParent.layout();
    }

    public void refreshSubtractSingleMultiControl(boolean refreshWithValues) {
        MultipleTextFieldAndRemoveButtonControls item;
        List values = new ArrayList();
        if (refreshWithValues) {
            values = this.isMultiText ? this.processor.getComplexValues(this.input) : this.processor.getSimpleValues(this.input);
        }
        int index = 0;
        while (index < values.size()) {
            MultipleTextFieldAndRemoveButtonControls control = null;
            if (index < this.controls.size()) {
                control = this.controls.get(index);
                control.setVisible(true);
            } else {
                control = this.createNewControl();
            }
            String stringValue = (String)values.get(index);
            control.setTextFieldText(stringValue);
            ++index;
        }
        int valuesCount = values.size();
        int controlsCount = this.controls.size();
        int extras = controlsCount - valuesCount;
        int controlsIndex = this.controls.size() - 1;
        while (extras > 0 && controlsIndex >= 0) {
            item = this.controls.get(controlsIndex);
            item.setTextFieldText("");
            --controlsIndex;
            --extras;
        }
        valuesCount = values.size();
        controlsCount = this.controls.size();
        extras = controlsCount - valuesCount;
        controlsIndex = this.controls.size() - 1;
        while (extras > 0 && controlsIndex >= 0) {
            item = this.controls.get(controlsIndex);
            item.setVisible(false);
            --controlsIndex;
            --extras;
            if (this.isMultiText) break;
        }
        this.mainParent.layout();
    }

    public void clearAllTextFields() {
        for (MultipleTextFieldAndRemoveButtonControls item : this.controls) {
            item.setTextFieldText("");
        }
    }

    public void clearUnusedTextFields() {
        for (MultipleTextFieldAndRemoveButtonControls item : this.controls) {
            if (item.isVisible()) continue;
            item.setTextFieldText("");
        }
    }

    private MultipleTextFieldAndRemoveButtonControls createNewControl() {
        MultipleTextFieldAndRemoveButtonControls control = new MultipleTextFieldAndRemoveButtonControls(this.toolkit, this.controlParent, null, this.isMultiText);
        this.controls.add(control);
        control.setTextFieldListener(this.textListener);
        control.setRemoveButtonListener(this.buttonListener);
        return control;
    }

    public List getValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (MultipleTextFieldAndRemoveButtonControls item : this.controls) {
            if (!item.isVisible()) continue;
            values.add(item.getMultiTextFieldString());
        }
        return values;
    }

    public void setValue(String value, int index) {
        if (this.controls.size() > index && index >= 0) {
            MultipleTextFieldAndRemoveButtonControls item = this.controls.get(index);
            item.setTextFieldText(value);
            item.setVisible(true);
            this.mainParent.layout();
        } else if (this.controls.size() == 0) {
            MultipleTextFieldAndRemoveButtonControls control = this.createNewControl();
            control.setTextFieldText(value);
            if (this.addButton == null && !this.isMultiText) {
                this.addButton = this.toolkit.createButton(this.mainParent, "  +  ", 8);
                this.addButton.addSelectionListener((SelectionListener)this.buttonListener);
            }
            this.mainParent.layout();
        }
    }

    private class AddRemoveButtonListener
    implements SelectionListener {
        private AddRemoveButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == MultipleMultiTextControls.this.addButton) {
                if (MultipleMultiTextControls.this.controls.size() > 0 && ((MultipleTextFieldAndRemoveButtonControls)MultipleMultiTextControls.this.controls.get(0)).isVisible() && !MultipleMultiTextControls.this.isMultiText) {
                    MultipleMultiTextControls.this.processor.addSimpleValue(MultipleMultiTextControls.this.input, "");
                }
                MultipleTextFieldAndRemoveButtonControls control = this.getFirstInvisibleControl();
                control.setVisible(true);
                MultipleMultiTextControls.this.mainParent.layout(true);
                MultipleMultiTextControls.this.valuePageBook.reflow(true);
            } else if (e.widget instanceof Button) {
                MultipleTextFieldAndRemoveButtonControls removeItem = this.getMultipleTextFieldAndRemoveButtonControls((Button)e.widget);
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < MultipleMultiTextControls.this.controls.size()) {
                    MultipleTextFieldAndRemoveButtonControls item = (MultipleTextFieldAndRemoveButtonControls)MultipleMultiTextControls.this.controls.get(index);
                    if (item.isVisible() && !item.equals(removeItem)) {
                        values.add(item.getMultiTextFieldString());
                    }
                    ++index;
                }
                MultipleTextFieldAndRemoveButtonControls control = this.getLastVisibleControl();
                control.setVisible(false);
                if (MultipleMultiTextControls.this.isMultiText) {
                    if (!removeItem.getMultiTextFieldString().trim().equals("")) {
                        MultipleMultiTextControls.this.processor.createComplexValues((EObject)MultipleMultiTextControls.this.input.getPropertyObjects().get(0), values);
                    }
                    removeItem.setTextFieldText("");
                } else {
                    MultipleMultiTextControls.this.processor.createSimpleValues(MultipleMultiTextControls.this.input, values);
                    MultipleMultiTextControls.this.clearUnusedTextFields();
                }
                MultipleMultiTextControls.this.refreshSubtractSingleMultiControl(true);
                MultipleMultiTextControls.this.mainParent.layout(true);
                MultipleMultiTextControls.this.valuePageBook.reflow(true);
            }
        }

        private MultipleTextFieldAndRemoveButtonControls getFirstInvisibleControl() {
            int index = 0;
            while (index < MultipleMultiTextControls.this.controls.size()) {
                MultipleTextFieldAndRemoveButtonControls item = (MultipleTextFieldAndRemoveButtonControls)MultipleMultiTextControls.this.controls.get(index);
                if (!item.isVisible()) {
                    return item;
                }
                ++index;
            }
            return MultipleMultiTextControls.this.createNewControl();
        }

        private MultipleTextFieldAndRemoveButtonControls getLastVisibleControl() {
            int index = MultipleMultiTextControls.this.controls.size();
            while (index - 1 >= 0) {
                MultipleTextFieldAndRemoveButtonControls item = (MultipleTextFieldAndRemoveButtonControls)MultipleMultiTextControls.this.controls.get(index - 1);
                if (item.isVisible()) {
                    return item;
                }
                --index;
            }
            return null;
        }

        private MultipleTextFieldAndRemoveButtonControls getMultipleTextFieldAndRemoveButtonControls(Button b) {
            for (MultipleTextFieldAndRemoveButtonControls item : MultipleMultiTextControls.this.controls) {
                if (b != item.getRemoveButton()) continue;
                return item;
            }
            return null;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class TextListener
    extends DelayedTextModifyListener {
        private TextListener() {
        }

        @Override
        protected void executeHandleEvent(Event event) {
            MultipleTextFieldAndRemoveButtonControls editedControl = this.getMultipleTextFieldAndRemoveButtonControls((Text)event.widget);
            if (editedControl != null) {
                EObject propertyObject = (EObject)this.getCorrespondingPropertyObject(editedControl);
                String value = editedControl.getMultiTextFieldString();
                if (MultipleMultiTextControls.this.isMultiText) {
                    ArrayList<String> listOfLiterals = new ArrayList<String>();
                    for (MultipleTextFieldAndRemoveButtonControls control : MultipleMultiTextControls.this.controls) {
                        listOfLiterals.add(control.getMultiTextFieldString());
                    }
                    MultipleMultiTextControls.this.processor.createComplexValues(propertyObject, listOfLiterals);
                } else {
                    List existingValues = MultipleMultiTextControls.this.processor.getSimpleValues(propertyObject);
                    ArrayList<String> newValueList = new ArrayList<String>(1);
                    newValueList.add(value);
                    if (!existingValues.equals(newValueList)) {
                        MultipleMultiTextControls.this.processor.editSimpleLiteralValue(MultipleMultiTextControls.this.input, propertyObject, value);
                    }
                }
            }
        }

        private MultipleTextFieldAndRemoveButtonControls getMultipleTextFieldAndRemoveButtonControls(Text t) {
            for (MultipleTextFieldAndRemoveButtonControls item : MultipleMultiTextControls.this.controls) {
                if (t != item.getTextField()) continue;
                return item;
            }
            return null;
        }

        private Object getCorrespondingPropertyObject(MultipleTextFieldAndRemoveButtonControls control) {
            if (MultipleMultiTextControls.this.isMultiText) {
                return MultipleMultiTextControls.this.input.getPropertyObjects().get(0);
            }
            int i = 0;
            while (i < MultipleMultiTextControls.this.controls.size()) {
                if (((MultipleTextFieldAndRemoveButtonControls)MultipleMultiTextControls.this.controls.get(i)).equals(control) && i < MultipleMultiTextControls.this.input.getPropertyObjects().size()) {
                    return MultipleMultiTextControls.this.input.getPropertyObjects().get(i);
                }
                ++i;
            }
            return null;
        }
    }
}

