/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls;

import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.sheet.TableViewerInputSelectionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class BindingScrolledMasterProperties
extends MasterDetailsBlock {
    private String sectionTitle;
    private TableViewer viewer;
    private Button addButton;
    private Button removeButton;
    private HashMap<Class, IDetailsPage> pagesToRegister;
    private boolean createMasterSection = true;
    List<IDetailsPage> pages = new ArrayList<IDetailsPage>();
    private IStructuredContentProvider masterContentProvider;
    private LabelProvider masterLabelProvider;
    private TableViewerInputSelectionListener addButtonListener;
    private TableViewerInputSelectionListener removeButtonListener;

    public BindingScrolledMasterProperties(String title, boolean createMasterSection) {
        this.sectionTitle = title;
        this.createMasterSection = createMasterSection;
    }

    public void setInput(IWorkbenchPart part, Object model) {
        this.viewer.setInput(model);
        for (IDetailsPage item : this.pages) {
            item.setFormInput(model);
        }
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite theParent = parent;
        if (this.createMasterSection) {
            Section section = toolkit.createSection(parent, 256);
            section.setText(this.sectionTitle);
            section.marginWidth = 10;
            section.marginHeight = 5;
            theParent = section;
        }
        Composite client = toolkit.createComposite(theParent, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        Table t = toolkit.createTable(client, 2);
        GridData gd = new GridData(1808);
        gd.heightHint = 20;
        gd.widthHint = 100;
        gd.grabExcessVerticalSpace = true;
        t.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        Composite buttonComposite = toolkit.createComposite(client);
        buttonComposite.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        this.addButton = toolkit.createButton(buttonComposite, Messages.BindingScrolledMasterProperties_0, 8);
        this.addButton.setAlignment(0x1000000);
        gd = new GridData(1808);
        this.addButton.setLayoutData((Object)gd);
        this.removeButton = toolkit.createButton(buttonComposite, Messages.BindingScrolledMasterProperties_1, 8);
        this.addButton.setAlignment(0x1000000);
        this.viewer = new TableViewer(t);
        if (this.createMasterSection) {
            Section section = (Section)theParent;
            section.setClient((Control)client);
            final SectionPart spart = new SectionPart(section);
            managedForm.addPart((IFormPart)spart);
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (BindingScrolledMasterProperties.this.createMasterSection) {
                        managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
                    }
                }
            });
        } else {
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    BindingScrolledMasterProperties.this.detailsPart.selectionChanged(null, event.getSelection());
                }
            });
        }
        this.viewer.setContentProvider((IContentProvider)this.masterContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.masterLabelProvider);
        if (this.addButtonListener != null) {
            this.addButton.addSelectionListener((SelectionListener)this.addButtonListener);
            this.addButtonListener.setTableViewer(this.viewer);
        }
        if (this.removeButtonListener != null) {
            this.removeButton.addSelectionListener((SelectionListener)this.removeButtonListener);
            this.removeButtonListener.setTableViewer(this.viewer);
        }
    }

    public void setPagesToRegister(HashMap<Class, IDetailsPage> map) {
        this.pagesToRegister = map;
    }

    public void setMasterContentProvider(IStructuredContentProvider p) {
        this.masterContentProvider = p;
    }

    public void setMasterLabelProvider(LabelProvider p) {
        this.masterLabelProvider = p;
    }

    public void setAddButtonListener(TableViewerInputSelectionListener l) {
        this.addButtonListener = l;
    }

    public void setRemoveButtonListener(TableViewerInputSelectionListener l) {
        this.removeButtonListener = l;
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    protected void registerPages(DetailsPart detailsPart) {
        for (Class key : this.pagesToRegister.keySet()) {
            IDetailsPage value = this.pagesToRegister.get(key);
            detailsPart.registerPage((Object)key, value);
            this.pages.add(value);
        }
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void dispose() {
        for (IDetailsPage page : this.pages) {
            page.dispose();
        }
        this.pages.clear();
    }
}

