/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.edit.policies;

import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentRelatedFigureConstants;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandleLocator;

public class SCAConnectionHandleLocator
extends ConnectionHandleLocator {
    private IFigure reference;

    public SCAConnectionHandleLocator(IFigure reference, Point cursorPosition) {
        super(reference, cursorPosition);
        this.reference = reference;
    }

    public void relocate(IFigure target) {
        super.relocate(target);
        Rectangle bounds = target.getBounds();
        double zoom = ScaUtil.getZoomManager().getZoom();
        boolean smallFigure = false;
        if (this.reference.getBounds().width == ComponentRelatedFigureConstants.COMPONENT_CHEVRON_WIDTH + 4) {
            smallFigure = true;
        }
        int xOffset = this.getHorizontalOffset(zoom, smallFigure);
        int yOffset = this.getVerticalOffset(zoom, smallFigure);
        bounds.x += xOffset;
        bounds.y += yOffset;
    }

    private int getVerticalOffset(double zoomLevel, boolean smallFigure) {
        if (smallFigure) {
            if (zoomLevel >= 3.0) {
                return -1;
            }
            if (zoomLevel <= 0.4) {
                return -3;
            }
            if (zoomLevel <= 0.5) {
                return -2;
            }
            if (zoomLevel <= 0.8) {
                return -1;
            }
            if (zoomLevel <= 1.25) {
                return 1;
            }
        } else {
            if (zoomLevel >= 0.8 && zoomLevel <= 3.75) {
                return 1;
            }
            if (zoomLevel <= 0.4) {
                return -3;
            }
            if (zoomLevel <= 0.5) {
                return -2;
            }
            if (zoomLevel <= 0.6) {
                return -1;
            }
        }
        return 0;
    }

    private int getHorizontalOffset(double zoomLevel, boolean smallFigure) {
        int offset = -2;
        if (zoomLevel >= 3.0) {
            offset = -5;
        } else if (zoomLevel >= 2.0 && zoomLevel < 3.0) {
            offset = -4;
        } else if (zoomLevel >= 1.25 && zoomLevel < 2.0) {
            offset = -3;
        } else if (zoomLevel < 1.25) {
            offset = -2;
        }
        if (smallFigure) {
            // empty if block
        }
        return offset * 2;
    }
}

