/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.edit.parts;

import com.ibm.ccl.sca.composite.ui.custom.edit.policies.SCAConnectionBendpointEditPolicy;
import com.ibm.ccl.sca.composite.ui.custom.edit.policies.SCAConnectionLineSegEditPolicy;
import com.ibm.ccl.sca.composite.ui.custom.edit.policies.SCATreeConnectionBendpointEditPolicy;
import com.ibm.ccl.sca.composite.ui.custom.edit.policies.ScaConnectionItemSemanticEditPolicy;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentRelatedFigureConstants;
import com.ibm.ccl.sca.composite.ui.custom.layout.SCAManhattanConnectionRouter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ForestRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class ConnectionEditPart
extends ConnectionNodeEditPart {
    public static final int VISUAL_ID = 3010;

    public ConnectionEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ScaConnectionItemSemanticEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new MyConnectionEndpointEditPolicy());
        this.installSCABendpointEditPolicy();
    }

    protected void refreshRouterChange() {
        super.refreshRouterChange();
        this.installSCABendpointEditPolicy();
    }

    protected void refreshRoutingStyles() {
        super.refreshRoutingStyles();
        RoutingStyle style = (RoutingStyle)this.getNotationView().getStyle(NotationPackage.Literals.ROUTING_STYLE);
        if (style != null) {
            if (style.isAvoidObstructions()) {
                this.installEditPolicy("Connection Bendpoint Policy", null);
            } else {
                this.installSCABendpointEditPolicy();
            }
        }
    }

    private void installSCABendpointEditPolicy() {
        ConnectionRouter router = this.getConnectionFigure().getConnectionRouter();
        if (router instanceof ForestRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new SCATreeConnectionBendpointEditPolicy());
        } else if (router instanceof OrthogonalRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new SCAConnectionLineSegEditPolicy());
        } else {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new SCAConnectionBendpointEditPolicy());
        }
    }

    protected Connection createConnectionFigure() {
        return new PolylineConnectionFigure();
    }

    public PolylineConnectionFigure getPrimaryShape() {
        return (PolylineConnectionFigure)this.getFigure();
    }

    private class MyConnectionEndpointEditPolicy
    extends ConnectionEndpointEditPolicy {
        private MyConnectionEndpointEditPolicy() {
        }

        protected List createSelectionHandles() {
            ArrayList list = new ArrayList();
            return list;
        }
    }

    public class PolylineConnectionFigure
    extends PolylineConnectionEx {
        public int NO_FEEDBACK_STATUS = 0;
        public int SELECTED_FEEDBACK_STATUS = 1;
        public int HOVER_FEEDBACK_STATUS = 2;
        private boolean showFeedbackStatus = false;
        private Color innerStrokeColor;
        private Color outerStrokeColor;

        protected void outlineShape(Graphics g) {
            PointList newPoints;
            PointList displayPoints = this.getSmoothPoints();
            if (this.getSmoothness() == 0 && this.getConnectionRouter() instanceof SCAManhattanConnectionRouter) {
                newPoints = new PointList();
                newPoints.addPoint(displayPoints.getFirstPoint());
                int index = 1;
                while (index < displayPoints.size() - 1) {
                    Point firstPoint = displayPoints.getPoint(index - 1);
                    Point secondPoint = displayPoints.getPoint(index);
                    Point thirdPoint = displayPoints.getPoint(index + 1);
                    if (firstPoint.y == secondPoint.y) {
                        if (secondPoint.y > thirdPoint.y) {
                            newPoints.addPoint(new Point(secondPoint.x - 2, secondPoint.y));
                            newPoints.addPoint(new Point(secondPoint.x, secondPoint.y - 2));
                        } else {
                            newPoints.addPoint(new Point(secondPoint.x - 2, secondPoint.y));
                            newPoints.addPoint(new Point(secondPoint.x, secondPoint.y + 2));
                        }
                    } else if (firstPoint.y < secondPoint.y) {
                        if (secondPoint.x < thirdPoint.x) {
                            newPoints.addPoint(new Point(secondPoint.x, secondPoint.y - 2));
                            newPoints.addPoint(new Point(secondPoint.x + 2, secondPoint.y));
                        } else {
                            newPoints.addPoint(new Point(secondPoint.x, secondPoint.y - 2));
                            newPoints.addPoint(new Point(secondPoint.x - 2, secondPoint.y));
                        }
                    } else if (firstPoint.y > secondPoint.y) {
                        if (secondPoint.x < thirdPoint.x) {
                            newPoints.addPoint(new Point(secondPoint.x, secondPoint.y + 2));
                            newPoints.addPoint(new Point(secondPoint.x + 2, secondPoint.y));
                        } else {
                            newPoints.addPoint(new Point(secondPoint.x - 2, secondPoint.y));
                            newPoints.addPoint(new Point(secondPoint.x, secondPoint.y - 2));
                        }
                    }
                    ++index;
                }
                newPoints.addPoint(displayPoints.getLastPoint());
            } else {
                newPoints = displayPoints;
            }
            if (this.showFeedbackStatus) {
                g.setLineWidth(3);
                g.setForegroundColor(this.outerStrokeColor);
                g.drawPolyline(displayPoints);
                g.setLineWidth(1);
                g.setForegroundColor(this.innerStrokeColor);
                g.drawPolyline(displayPoints);
            } else {
                g.drawPolyline(newPoints);
            }
        }

        public void showSelectionFeedback() {
            this.showFeedbackStatus = true;
            this.innerStrokeColor = ComponentRelatedFigureConstants.WIRE_INNER_STROKE_SELECTION_COLOR;
            this.outerStrokeColor = ComponentRelatedFigureConstants.WIRE_OUTER_STROKE_SELECTION_COLOR;
            this.revalidateAndRepaint();
        }

        public void showHoverFeedback() {
            this.showFeedbackStatus = true;
            this.innerStrokeColor = ComponentRelatedFigureConstants.WIRE_INNER_STROKE_HOVER_COLOR;
            this.outerStrokeColor = ComponentRelatedFigureConstants.WIRE_OUTER_STROKE_HOVER_COLOR;
            this.revalidateAndRepaint();
        }

        public void hideFeedback() {
            if (this.showFeedbackStatus) {
                this.showFeedbackStatus = false;
                this.revalidateAndRepaint();
            }
        }

        private void revalidateAndRepaint() {
            this.revalidate();
            this.repaint();
        }
    }
}

