/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.edit.commands;

import com.ibm.ccl.sca.composite.emf.sca.Component;
import com.ibm.ccl.sca.composite.emf.sca.ComponentReference;
import com.ibm.ccl.sca.composite.emf.sca.ComponentService;
import com.ibm.ccl.sca.composite.emf.sca.Reference;
import com.ibm.ccl.sca.composite.emf.sca.Service;
import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.composite.ui.edit.commands.ComponentServiceCreateCommand;
import com.ibm.ccl.sca.composite.ui.providers.ScaElementTypes;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

public class ScaConnectionCreateCommand
extends EditElementCommand {
    private final EObject source;
    private final EObject target;

    public ScaConnectionCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = source;
        this.target = target;
    }

    public ScaConnectionCreateCommand(EObject source, EObject target) {
        super("", null, null);
        this.source = source;
        this.target = target;
    }

    public boolean canExecute() {
        if (this.canExecuteComponentReferenceToComponentService()) {
            this.setLabel(Messages.ScaConnectionCreateCommand_1);
            return true;
        }
        if (this.canExecutePromotion()) {
            this.setLabel(Messages.ScaConnectionCreateCommand_2);
            return true;
        }
        return false;
    }

    private boolean canExecutePromotion() {
        if (this.source instanceof ComponentReference) {
            if (this.target == null || this.target instanceof Reference && !(this.target instanceof ComponentReference)) {
                if (this.target != null) {
                    ComponentReference compRef = (ComponentReference)this.source;
                    Reference reference = (Reference)this.target;
                    String promoteString = ScaUtil.getComponentReferenceString(compRef);
                    if (reference.getPromote() != null && reference.getPromote().contains(promoteString)) {
                        return false;
                    }
                }
                return true;
            }
        } else if (this.source instanceof Service && !(this.source instanceof ComponentService) && !this.isPromoting((Service)this.source) && (this.target == null || this.target instanceof ComponentService)) {
            return true;
        }
        return false;
    }

    private boolean isPromoting(Service service) {
        String promoteString = service.getPromote();
        if (promoteString == null) {
            return false;
        }
        return !promoteString.equals("");
    }

    private boolean canExecuteComponentReferenceToComponentService() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof ComponentReference)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof ComponentService) && !(this.target instanceof Component)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.source != null) {
            if (this.target instanceof ComponentService) {
                ComponentReference compRef = this.getSource();
                ComponentService compServ = (ComponentService)this.getTarget();
                if (ScaUtil.getContainingComponentName(compServ).equals(ScaUtil.getContainingComponentName(compRef))) {
                    return false;
                }
                if (compRef.getTarget() == null) {
                    return true;
                }
                String targetRef = ScaUtil.getComponentServiceString(compServ);
                Iterator it = compRef.getTarget().iterator();
                while (it.hasNext()) {
                    if (!targetRef.equals(it.next())) continue;
                    return false;
                }
            } else if (this.target instanceof Component) {
                ComponentReference compRef = this.getSource();
                Component comp = (Component)this.getTarget();
                return !comp.equals(compRef.eContainer());
            }
        }
        return this.getSource() != null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.canExecuteComponentReferenceToComponentService()) {
            if (this.getSource() != null && this.getTarget() != null) {
                ArrayList<String> references = this.getSource().getTarget();
                if (references == null) {
                    references = new ArrayList<String>();
                }
                ComponentService compService = null;
                if (this.getTarget() instanceof Component) {
                    Component component = (Component)this.getTarget();
                    CreateElementRequest createRequest = new CreateElementRequest((EObject)component, ScaElementTypes.ComponentService_2001);
                    ComponentServiceCreateCommand command = new ComponentServiceCreateCommand(createRequest);
                    command.execute(null, null);
                    compService = (ComponentService)command.getNewElement();
                } else if (this.getTarget() instanceof ComponentService) {
                    compService = (ComponentService)this.getTarget();
                }
                if (compService instanceof ComponentService) {
                    String uri = ScaUtil.getComponentServiceString(compService);
                    references.add(uri);
                    this.getSource().setTarget(references);
                }
            }
            return CommandResult.newOKCommandResult();
        }
        if (this.canExecutePromotion()) {
            if (this.source instanceof ComponentReference && this.target instanceof Reference && !(this.target instanceof ComponentReference)) {
                String promoteString = ScaUtil.getComponentReferenceString((ComponentReference)this.source);
                ArrayList<String> promoteList = ((Reference)this.target).getPromote();
                if (promoteList == null) {
                    promoteList = new ArrayList<String>();
                }
                promoteList.add(promoteString);
                ((Reference)this.target).setPromote(promoteList);
            } else if (this.source instanceof Service && !(this.source instanceof ComponentService) && this.target instanceof ComponentService) {
                String promoteString = ScaUtil.getComponentServiceString((ComponentService)this.target);
                ((Service)this.source).setPromote(promoteString);
            }
            return CommandResult.newOKCommandResult();
        }
        throw new ExecutionException("Invalid arguments in create link command");
    }

    protected ComponentReference getSource() {
        return (ComponentReference)this.source;
    }

    protected EObject getTarget() {
        return this.target;
    }
}

