/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.ws.instance.impl;

import com.ibm.ccl.sca.composite.emf.ws.instance.DocumentRoot;
import com.ibm.ccl.sca.composite.emf.ws.instance.InstanceFactory;
import com.ibm.ccl.sca.composite.emf.ws.instance.InstancePackage;
import com.ibm.ccl.sca.composite.emf.ws.instance.impl.DocumentRootImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

public class InstanceFactoryImpl
extends EFactoryImpl
implements InstanceFactory {
    public static InstanceFactory init() {
        try {
            InstanceFactory theInstanceFactory = (InstanceFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.w3.org/2004/08/wsdl-instance");
            if (theInstanceFactory != null) {
                return theInstanceFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new InstanceFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDocumentRoot();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 1: {
                return this.createWsdlLocationTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 1: {
                return this.convertWsdlLocationTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public DocumentRoot createDocumentRoot() {
        DocumentRootImpl documentRoot = new DocumentRootImpl();
        return documentRoot;
    }

    public List<String> createWsdlLocationTypeFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(initialValue);
        while (stringTokenizer.hasMoreTokens()) {
            String item = stringTokenizer.nextToken();
            result.add((String)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.ANY_URI, item));
        }
        return result;
    }

    public String convertWsdlLocationTypeToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        List list = (List)instanceValue;
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (Object item : list) {
            result.append(XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.ANY_URI, item));
            result.append(' ');
        }
        return result.substring(0, result.length() - 1);
    }

    @Override
    public InstancePackage getInstancePackage() {
        return (InstancePackage)this.getEPackage();
    }

    @Deprecated
    public static InstancePackage getPackage() {
        return InstancePackage.eINSTANCE;
    }
}

