/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.ws.extensibility.ui;

import com.ibm.ccl.sca.composite.emf.ws.Messages;
import com.ibm.ccl.sca.composite.emf.ws.WebServiceBinding;
import com.ibm.ccl.sca.composite.emf.ws.addressing.EndpointReferenceType;
import com.ibm.ccl.sca.composite.emf.ws.extensibility.ui.ParseWSDLFileUtil;
import com.ibm.ccl.sca.composite.emf.ws.extensibility.ui.SCAWSDLElementProcessor;
import com.ibm.ccl.sca.composite.emf.ws.extensibility.ui.actions.WSAddEndpointReferenceAction;
import com.ibm.ccl.sca.composite.emf.ws.extensibility.ui.actions.WSEditEndpointReferenceAction;
import com.ibm.ccl.sca.composite.emf.ws.extensibility.ui.actions.WSEditWSDLElementAction;
import com.ibm.ccl.sca.composite.emf.ws.extensibility.ui.actions.WSRemoveEndtpointReferenceAction;
import com.ibm.ccl.sca.composite.emf.ws.search.WSDLSearchDialogProvider;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls.DelayedTextModifyListener;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls.NewObjectDialog;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.sca.SCABindingDetailsPropertiesPage;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSearchListDialog;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;

public class WebServiceBindingDetailsPropertiesPage
extends SCABindingDetailsPropertiesPage {
    private static String SERVICE_DISPLAY_STRING = Messages.TEXT_WEB_SERVICE_BINDING_WSDL_SERVICE;
    private static String PORT_DISPLAY_STRING = Messages.TEXT_WEB_SERVICE_BINDING_WSDL_PORT;
    private static String BINDING_DISPLAY_STRING = Messages.TEXT_WEB_SERVICE_BINDING_WSDL_BINDING;
    private Label elementTypeLabel;
    private Label elementNameLabel;
    private Label wsdlURILabel;
    private CCombo elementTypeCombo;
    private Text elementNameText;
    private Text wsdlURIText;
    private Label previewLabel;
    private Text previewText;
    private Button wsdlSelectionButton;
    private Button wsdllessButton;
    private Label endpointReferenceLabel;
    private Button addEndpointReferenceButton;
    private Button removeEndpointReferenceButton;
    private Button editEndpointReferenceButton;
    private TableViewer viewer;
    private Table endpointReferenceTable;
    private WSDetailsCustomListener textListener = new WSDetailsCustomListener();
    private WSDetailsComboListener comboListener = new WSDetailsComboListener();
    private WSButtonSelectionListener buttonListener = new WSButtonSelectionListener();
    private static Color color = new Color(null, 128, 128, 128);
    private boolean extendedAreaCreated;
    private Composite extendedAreaComposite;

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (!this.extendedAreaCreated) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            EObject theObject = null;
            if (sel.size() > 0) {
                theObject = (EObject)sel.getFirstElement();
                this.createExtendedAreaControls(this.extendedAreaComposite, theObject);
                this.extendedAreaCreated = true;
            }
        }
        super.selectionChanged(part, selection);
        this.viewer.setInput((Object)this.binding);
    }

    protected void doCreateContents(Composite parent) {
        this.createNameAndIdentitySection(parent);
        this.createWSDLElementSection(parent);
        this.createPolicySetsAndIntentsSection(parent);
        this.extendedAreaCreated = false;
        this.extendedAreaComposite = parent;
        this.addAllListeners();
    }

    protected Composite createNameAndIdentitySection(Composite parent) {
        Composite client = super.createNameAndIdentitySection(parent);
        this.toolkit.createLabel(client, "");
        return client;
    }

    protected void createWSDLElementSection(Composite parent) {
        Composite client = this.createNewSection(parent, Messages.TITLE_WSDL_ELEMENT, SECTION_STYLE, 3);
        this.wsdllessButton = this.toolkit.createButton(client, Messages.LABEL_WSDL_LESS, 32);
        this.wsdllessButton.addSelectionListener((SelectionListener)this.buttonListener);
        this.toolkit.createLabel(client, "");
        this.toolkit.createLabel(client, "");
        this.elementTypeLabel = this.toolkit.createLabel(client, Messages.LABEL_ELEMENT_TYPE);
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        this.elementTypeLabel.setLayoutData((Object)gd);
        this.elementTypeCombo = this.createCCombo(client, 0x800000);
        this.elementTypeCombo.setEditable(false);
        gd = new GridData(770);
        gd.horizontalSpan = 1;
        gd.verticalAlignment = 0x1000000;
        this.elementTypeCombo.setLayoutData((Object)gd);
        this.wsdlSelectionButton = this.toolkit.createButton(client, "...", 8);
        this.wsdlSelectionButton.addSelectionListener((SelectionListener)this.buttonListener);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.wsdlSelectionButton.setLayoutData((Object)gd);
        this.elementTypeCombo.add("");
        String[] types = SCAWSDLElementProcessor.getElementTypes();
        int index = 0;
        while (index < types.length) {
            this.elementTypeCombo.add(this.getElementTypeDisplayName(types[index]));
            ++index;
        }
        this.elementNameLabel = this.toolkit.createLabel(client, Messages.LABEL_ELEMENT_NAME);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.elementNameLabel.setLayoutData((Object)gd);
        this.elementNameText = this.toolkit.createText(client, "", 4);
        gd = new GridData(770);
        this.elementNameText.setLayoutData((Object)gd);
        this.toolkit.createLabel(client, "");
        this.wsdlURILabel = this.toolkit.createLabel(client, Messages.LABEL_WSDL_NAMESPACE);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.wsdlURILabel.setLayoutData((Object)gd);
        this.wsdlURIText = this.toolkit.createText(client, "", 4);
        gd = new GridData(770);
        gd.horizontalSpan = 1;
        this.wsdlURIText.setLayoutData((Object)gd);
        this.toolkit.createLabel(client, "");
        this.previewLabel = this.toolkit.createLabel(client, Messages.PREVIEW_STRING);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.previewLabel.setLayoutData((Object)gd);
        this.toolkit.createLabel(client, "");
        this.toolkit.createLabel(client, "");
        this.previewText = this.toolkit.createText(client, "", 586);
        gd = new GridData(768);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 3;
        gd.heightHint = 40;
        this.previewText.setLayoutData((Object)gd);
        this.previewText.setForeground(color);
        Composite endpointReferenceComp = this.toolkit.createComposite(client);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        endpointReferenceComp.setLayout((Layout)layout);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        endpointReferenceComp.setLayoutData((Object)gd);
        this.endpointReferenceLabel = this.toolkit.createLabel(endpointReferenceComp, Messages.LABEL_ENDPOINT_REFERENCE_ADDRESSES);
        gd = new GridData();
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.endpointReferenceLabel.setLayoutData((Object)gd);
        this.endpointReferenceTable = this.toolkit.createTable(endpointReferenceComp, 66050);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.horizontalIndent = 20;
        gd.heightHint = 50;
        gd.grabExcessVerticalSpace = true;
        this.endpointReferenceTable.setLayoutData((Object)gd);
        Composite endpointReferenceButtonComp = this.toolkit.createComposite(endpointReferenceComp);
        layout = new GridLayout();
        endpointReferenceButtonComp.setLayout((Layout)layout);
        gd = new GridData(1808);
        this.viewer = new TableViewer(this.endpointReferenceTable);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.addEndpointReferenceButton = this.toolkit.createButton(endpointReferenceButtonComp, Messages.TEXT_ADD, 8);
        gd = new GridData(768);
        this.addEndpointReferenceButton.setLayoutData((Object)gd);
        this.addEndpointReferenceButton.addSelectionListener((SelectionListener)this.buttonListener);
        this.removeEndpointReferenceButton = this.toolkit.createButton(endpointReferenceButtonComp, Messages.TEXT_REMOVE, 8);
        this.removeEndpointReferenceButton.addSelectionListener((SelectionListener)this.buttonListener);
        this.editEndpointReferenceButton = this.toolkit.createButton(endpointReferenceButtonComp, Messages.TEXT_EDIT, 8);
        gd = new GridData(768);
        this.editEndpointReferenceButton.setLayoutData((Object)gd);
        this.editEndpointReferenceButton.addSelectionListener((SelectionListener)this.buttonListener);
        this.toolkit.paintBordersFor(endpointReferenceComp);
        this.toolkit.createLabel(client, "");
        this.toolkit.createLabel(client, "");
    }

    public void refresh() {
        SCAWSDLElementProcessor processor;
        super.refresh();
        this.removeAllListeners();
        this.wsdllessButton.setSelection(false);
        this.elementTypeCombo.select(0);
        this.elementNameText.setText("");
        this.wsdlURIText.setText("");
        this.previewText.setText("");
        WebServiceBinding wsBinding = (WebServiceBinding)this.binding;
        if (wsBinding.getWsdlElement() != null && (processor = new SCAWSDLElementProcessor(wsBinding)).process()) {
            String[] items = this.elementTypeCombo.getItems();
            int index = 0;
            while (index < items.length) {
                if (items[index].equals(this.getElementTypeDisplayName(processor.getElementType()))) {
                    this.elementTypeCombo.select(index);
                    break;
                }
                ++index;
            }
            this.elementNameText.setText(processor.getElementName());
            this.wsdlURIText.setText(processor.getWSDLURI());
        }
        this.refreshPreviewString();
        wsBinding.getEndpointReference();
        if (this.previewText.getText().equals("")) {
            this.wsdllessButton.setSelection(true);
            this.toggleEnabledWSDLControls(false);
        }
        this.updateSelectionButtonState();
        this.addAllListeners();
    }

    private void updateSelectionButtonState() {
        String item = this.elementTypeCombo.getItem(this.elementTypeCombo.getSelectionIndex());
        if (item.equals("")) {
            this.wsdlSelectionButton.setEnabled(false);
        } else {
            this.wsdlSelectionButton.setEnabled(true);
        }
    }

    private void refreshPreviewString() {
        String previewString = ((WebServiceBinding)this.binding).getWsdlElement();
        if (previewString == null) {
            previewString = "";
        }
        this.previewText.setText(previewString);
    }

    private String getElementTypeDisplayName(String string) {
        if (string.equals(SCAWSDLElementProcessor.SERVICE_ELEMENT_TYPE)) {
            return SERVICE_DISPLAY_STRING;
        }
        if (string.equals(SCAWSDLElementProcessor.BINDING_ELEMENT_TYPE)) {
            return BINDING_DISPLAY_STRING;
        }
        if (string.equals(SCAWSDLElementProcessor.PORT_ELEMENT_TYPE)) {
            return PORT_DISPLAY_STRING;
        }
        return string;
    }

    private String getElementTypeNonDisplayName(String string) {
        if (string.equals(SERVICE_DISPLAY_STRING)) {
            return SCAWSDLElementProcessor.SERVICE_ELEMENT_TYPE;
        }
        if (string.equals(BINDING_DISPLAY_STRING)) {
            return SCAWSDLElementProcessor.BINDING_ELEMENT_TYPE;
        }
        if (string.equals(PORT_DISPLAY_STRING)) {
            return SCAWSDLElementProcessor.PORT_ELEMENT_TYPE;
        }
        return string;
    }

    private void addAllListeners() {
        this.elementNameText.addListener(16, (Listener)this.textListener);
        this.elementNameText.addListener(2, (Listener)this.textListener);
        this.wsdlURIText.addListener(16, (Listener)this.textListener);
        this.wsdlURIText.addListener(2, (Listener)this.textListener);
        this.elementTypeCombo.addSelectionListener((SelectionListener)this.comboListener);
    }

    private void removeAllListeners() {
        this.elementNameText.removeListener(16, (Listener)this.textListener);
        this.elementNameText.removeListener(2, (Listener)this.textListener);
        this.wsdlURIText.removeListener(16, (Listener)this.textListener);
        this.wsdlURIText.removeListener(2, (Listener)this.textListener);
        this.elementTypeCombo.removeSelectionListener((SelectionListener)this.comboListener);
    }

    private void toggleEnabledWSDLControls(boolean enabled) {
        this.elementTypeLabel.setEnabled(enabled);
        this.elementNameLabel.setEnabled(enabled);
        this.wsdlURILabel.setEnabled(enabled);
        this.elementTypeCombo.setEnabled(enabled);
        this.elementNameText.setEnabled(enabled);
        this.wsdlURIText.setEnabled(enabled);
        this.wsdlSelectionButton.setEnabled(enabled);
        this.previewLabel.setEnabled(enabled);
        this.previewText.setEnabled(enabled);
        this.toggleEnableEndpointReferenceControls();
    }

    private void toggleEnableEndpointReferenceControls() {
        String item = this.elementTypeCombo.getItem(this.elementTypeCombo.getSelectionIndex());
        boolean enabled = false;
        if (item.equals(BINDING_DISPLAY_STRING) && !this.wsdllessButton.getSelection()) {
            enabled = true;
        }
        this.endpointReferenceLabel.setEnabled(enabled);
        this.addEndpointReferenceButton.setEnabled(enabled);
        this.removeEndpointReferenceButton.setEnabled(enabled);
        this.editEndpointReferenceButton.setEnabled(enabled);
        this.endpointReferenceTable.setEnabled(enabled);
    }

    private void removeAllEndpointReferences() {
        Table table = this.viewer.getTable();
        int size = table.getItemCount();
        int i = 0;
        while (i < size) {
            TableItem item = table.getItem(i);
            EndpointReferenceType dataItem = (EndpointReferenceType)item.getData();
            WSRemoveEndtpointReferenceAction action = new WSRemoveEndtpointReferenceAction(this.getWorkbenchPart(), dataItem);
            action.run();
            ++i;
        }
    }

    private void addAllEndpointReferences() {
        Table table = this.viewer.getTable();
        int size = table.getItemCount();
        int i = 0;
        while (i < size) {
            TableItem item = table.getItem(i);
            String text = item.getText();
            WSAddEndpointReferenceAction addAction = new WSAddEndpointReferenceAction(this.getWorkbenchPart(), (EObject)this.binding, null);
            addAction.run();
            EndpointReferenceType endpoint = (EndpointReferenceType)addAction.getElement();
            WSEditEndpointReferenceAction editAction = new WSEditEndpointReferenceAction(this.getWorkbenchPart(), endpoint, text);
            editAction.run();
            ++i;
        }
        this.viewer.setInput((Object)this.binding);
    }

    private void applyWSDLElementStringValue() {
        String wsdlElementString = null;
        int i = this.elementTypeCombo.getSelectionIndex();
        String elementType = this.elementTypeCombo.getItem(i);
        if (elementType != null && elementType.length() > 0) {
            String elementName = this.elementNameText.getText();
            String uri = this.wsdlURIText.getText();
            String elementTypeNonDisplayName = this.getElementTypeNonDisplayName(elementType);
            wsdlElementString = SCAWSDLElementProcessor.constructwsdlElementString(elementTypeNonDisplayName, elementName, uri, "");
        } else if (elementType != null && elementType.length() == 0) {
            wsdlElementString = "";
        }
        this.applyWSDLElementValue(wsdlElementString);
        this.refreshPreviewString();
    }

    private void applyWSDLElementValue(String wsdlElementString) {
        if (wsdlElementString != null) {
            WebServiceBinding wsBinding = (WebServiceBinding)this.binding;
            String wsdlElementValue = wsBinding.getWsdlElement();
            if (wsdlElementString.equals("")) {
                wsdlElementString = null;
            }
            if (wsdlElementString != null && !wsdlElementString.equals(wsdlElementValue)) {
                WSEditWSDLElementAction action = new WSEditWSDLElementAction(this.getWorkbenchPart(), this.binding, wsdlElementString);
                action.run();
            } else if (wsdlElementString == null && wsdlElementValue != null) {
                WSEditWSDLElementAction action = new WSEditWSDLElementAction(this.getWorkbenchPart(), this.binding, wsdlElementString);
                action.run();
            }
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            WebServiceBinding wsBinding = (WebServiceBinding)inputElement;
            return wsBinding.getEndpointReference().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            EndpointReferenceType endpoint = (EndpointReferenceType)obj;
            if (endpoint.getAddress() == null) {
                return Messages.TEXT_ENTER_ADDRESS_VALUE;
            }
            String text = endpoint.getAddress().getValue();
            if (text == null || text.trim().equals("")) {
                return Messages.TEXT_ENTER_ADDRESS_VALUE;
            }
            return text;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    private class WSButtonSelectionListener
    extends SelectionAdapter {
        private WSButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ISelection selection;
            if (e.widget == WebServiceBindingDetailsPropertiesPage.this.wsdllessButton) {
                if (WebServiceBindingDetailsPropertiesPage.this.wsdllessButton.getSelection()) {
                    WebServiceBindingDetailsPropertiesPage.this.toggleEnabledWSDLControls(false);
                    WebServiceBindingDetailsPropertiesPage.this.applyWSDLElementValue("");
                    WebServiceBindingDetailsPropertiesPage.this.refreshPreviewString();
                    WebServiceBindingDetailsPropertiesPage.this.removeAllEndpointReferences();
                } else {
                    WebServiceBindingDetailsPropertiesPage.this.toggleEnabledWSDLControls(true);
                    WebServiceBindingDetailsPropertiesPage.this.applyWSDLElementStringValue();
                    WebServiceBindingDetailsPropertiesPage.this.addAllEndpointReferences();
                    WebServiceBindingDetailsPropertiesPage.this.updateSelectionButtonState();
                }
            } else if (e.widget == WebServiceBindingDetailsPropertiesPage.this.wsdlSelectionButton) {
                WSDLSearchDialogProvider provider = new WSDLSearchDialogProvider(ScaUtil.getIFile());
                int selIndex = WebServiceBindingDetailsPropertiesPage.this.elementTypeCombo.getSelectionIndex();
                String selection2 = WebServiceBindingDetailsPropertiesPage.this.elementTypeCombo.getItem(selIndex);
                ComponentSearchListDialog dialog = null;
                if (selection2.equals(SERVICE_DISPLAY_STRING)) {
                    dialog = provider.getWSDLServiceBrowseDialog();
                } else if (selection2.equals(PORT_DISPLAY_STRING)) {
                    dialog = provider.getWSDLPortBrowseDialog();
                } else if (selection2.equals(BINDING_DISPLAY_STRING)) {
                    dialog = provider.getWSDLBindingBrowseDialog();
                }
                if (dialog != null) {
                    dialog.create();
                    if (dialog.open() == 0) {
                        WebServiceBinding wsBinding;
                        String elementTypeNonDisplayName;
                        String wsdlElementString;
                        ComponentSpecification spec = dialog.getSelectedComponent();
                        String name = spec.getName();
                        String ns = spec.getQualifier();
                        String serviceName = null;
                        if (selection2.equals(PORT_DISPLAY_STRING)) {
                            serviceName = ParseWSDLFileUtil.getService(spec.getFile(), name);
                        }
                        if (!(wsdlElementString = SCAWSDLElementProcessor.constructwsdlElementString(elementTypeNonDisplayName = WebServiceBindingDetailsPropertiesPage.this.getElementTypeNonDisplayName(selection2), name, ns, serviceName)).equals((wsBinding = (WebServiceBinding)WebServiceBindingDetailsPropertiesPage.this.binding).getWsdlElement())) {
                            WSEditWSDLElementAction action = new WSEditWSDLElementAction(WebServiceBindingDetailsPropertiesPage.this.getWorkbenchPart(), WebServiceBindingDetailsPropertiesPage.this.binding, wsdlElementString);
                            action.run();
                            WebServiceBindingDetailsPropertiesPage.this.refresh();
                        }
                    }
                }
            } else if (e.widget == WebServiceBindingDetailsPropertiesPage.this.addEndpointReferenceButton) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                NewObjectDialog dialog = new NewObjectDialog(shell, Messages.DIALOG_TITLE_NEW_ENDPOINT_REFERENCE, Messages.TEXT_DESCRIPTION_NEW_ADDRESS_FOR_ENDPOINT_REFERENCE, Messages.LABEL_ADDRESS, "");
                if (dialog.createAndOpen() == 0) {
                    String text = dialog.getText();
                    WSAddEndpointReferenceAction addAction = new WSAddEndpointReferenceAction(WebServiceBindingDetailsPropertiesPage.this.getWorkbenchPart(), (EObject)WebServiceBindingDetailsPropertiesPage.this.binding, null);
                    addAction.run();
                    EndpointReferenceType newEndpoint = (EndpointReferenceType)addAction.getElement();
                    WSEditEndpointReferenceAction editAction = new WSEditEndpointReferenceAction(WebServiceBindingDetailsPropertiesPage.this.getWorkbenchPart(), newEndpoint, text);
                    editAction.run();
                    WebServiceBindingDetailsPropertiesPage.this.viewer.refresh();
                }
            } else if (e.widget == WebServiceBindingDetailsPropertiesPage.this.removeEndpointReferenceButton) {
                ISelection selection3 = WebServiceBindingDetailsPropertiesPage.this.viewer.getSelection();
                if (selection3 instanceof StructuredSelection) {
                    EndpointReferenceType endpoint = (EndpointReferenceType)((StructuredSelection)selection3).getFirstElement();
                    WSRemoveEndtpointReferenceAction action = new WSRemoveEndtpointReferenceAction(WebServiceBindingDetailsPropertiesPage.this.getWorkbenchPart(), endpoint);
                    action.run();
                    WebServiceBindingDetailsPropertiesPage.this.viewer.refresh();
                }
            } else if (e.widget == WebServiceBindingDetailsPropertiesPage.this.editEndpointReferenceButton && (selection = WebServiceBindingDetailsPropertiesPage.this.viewer.getSelection()) instanceof StructuredSelection) {
                EndpointReferenceType endpoint = (EndpointReferenceType)((StructuredSelection)selection).getFirstElement();
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                NewObjectDialog dialog = new NewObjectDialog(shell, Messages.DIALOG_TITLE_EDIT_ENDPOINT_REFERENCE, null, Messages.LABEL_ADDRESS, "");
                if (dialog.createAndOpen() == 0) {
                    String text = dialog.getText();
                    WSEditEndpointReferenceAction editAction = new WSEditEndpointReferenceAction(WebServiceBindingDetailsPropertiesPage.this.getWorkbenchPart(), endpoint, text);
                    editAction.run();
                    WebServiceBindingDetailsPropertiesPage.this.viewer.refresh();
                }
            }
        }
    }

    private class WSDetailsComboListener
    extends SelectionAdapter {
        private WSDetailsComboListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == WebServiceBindingDetailsPropertiesPage.this.elementTypeCombo) {
                WebServiceBindingDetailsPropertiesPage.this.applyWSDLElementStringValue();
                String item = WebServiceBindingDetailsPropertiesPage.this.elementTypeCombo.getItem(WebServiceBindingDetailsPropertiesPage.this.elementTypeCombo.getSelectionIndex());
                if (item.equals(BINDING_DISPLAY_STRING)) {
                    WebServiceBindingDetailsPropertiesPage.this.addAllEndpointReferences();
                } else {
                    WebServiceBindingDetailsPropertiesPage.this.removeAllEndpointReferences();
                }
                WebServiceBindingDetailsPropertiesPage.this.updateSelectionButtonState();
                WebServiceBindingDetailsPropertiesPage.this.toggleEnableEndpointReferenceControls();
            }
        }
    }

    private class WSDetailsCustomListener
    extends DelayedTextModifyListener {
        private WSDetailsCustomListener() {
        }

        protected void executeHandleEvent(Event event) {
            if (event.widget == WebServiceBindingDetailsPropertiesPage.this.elementNameText && !WebServiceBindingDetailsPropertiesPage.this.elementNameText.isDisposed()) {
                WebServiceBindingDetailsPropertiesPage.this.applyWSDLElementStringValue();
            } else if (event.widget == WebServiceBindingDetailsPropertiesPage.this.wsdlURIText && !WebServiceBindingDetailsPropertiesPage.this.wsdlURIText.isDisposed()) {
                WebServiceBindingDetailsPropertiesPage.this.applyWSDLElementStringValue();
            }
        }
    }
}

