/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.ws.extensibility.ui;

import com.ibm.ccl.sca.composite.emf.ws.WebServiceBinding;

public class SCAWSDLElementProcessor {
    public static String SERVICE_ELEMENT_TYPE = "wsdl.service";
    public static String BINDING_ELEMENT_TYPE = "wsdl.binding";
    public static String PORT_ELEMENT_TYPE = "wsdl.port";
    private WebServiceBinding binding;
    private String wsdlURI = "";
    private String elementType = "";
    private String elementName = "";

    public SCAWSDLElementProcessor(WebServiceBinding binding) {
        this.binding = binding;
    }

    public String getWSDLURI() {
        return this.wsdlURI;
    }

    public String getElementType() {
        return this.elementType;
    }

    public String getElementName() {
        return this.elementName;
    }

    public boolean process() {
        String string = this.binding.getWsdlElement();
        if (string == null) {
            return false;
        }
        int separatorIndex = string.lastIndexOf("#");
        if (separatorIndex > -1) {
            this.wsdlURI = string.substring(0, separatorIndex);
            String[] types = SCAWSDLElementProcessor.getElementTypes();
            int index = 0;
            while (index < types.length) {
                int typeIndex = string.lastIndexOf(types[index]);
                if (typeIndex > separatorIndex) {
                    this.elementType = types[index];
                    int leftBracketIndex = typeIndex + this.elementType.length();
                    int rightBracketIndex = string.length() - 1;
                    if (string.charAt(leftBracketIndex) == '(' && string.charAt(rightBracketIndex) == ')') {
                        this.elementName = string.substring(leftBracketIndex + 1, rightBracketIndex);
                        return true;
                    }
                }
                ++index;
            }
        }
        return false;
    }

    public static String[] getElementTypes() {
        String[] types = new String[]{SERVICE_ELEMENT_TYPE, BINDING_ELEMENT_TYPE, PORT_ELEMENT_TYPE};
        return types;
    }

    public static String constructwsdlElementString(String elementType, String elementName, String uri, String serviceName) {
        String servicePath = serviceName == null || serviceName.equals("") ? elementName : String.valueOf(serviceName) + "/" + elementName;
        String wsdlElementString = String.valueOf(uri) + "#" + elementType + "(" + servicePath + ")";
        return wsdlElementString;
    }
}

