/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.ws.extensibility.ui;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParseWSDLFileUtil {
    public static String getService(IFile wsdlFile, String portName) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        Handler handler = new Handler(portName);
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(wsdlFile.getContents(), (DefaultHandler)handler);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return handler.getService();
    }

    private static class Handler
    extends DefaultHandler {
        private String serviceName;
        private String lastServiceName;
        private String portName;

        public Handler(String portName) {
            this.portName = portName;
        }

        public String getService() {
            return this.serviceName;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (this.checkElement(name, "service")) {
                this.lastServiceName = attributes.getValue("name");
            } else if (this.checkElement(name, "port") && attributes.getValue("name").equals(this.portName)) {
                this.serviceName = this.lastServiceName;
            }
        }

        private boolean checkElement(String value, String elementName) {
            boolean result = false;
            if (value.equals(elementName)) {
                result = true;
            } else {
                int colonIndex = value.indexOf(58);
                if (colonIndex != -1 && value.substring(colonIndex + 1).equals(elementName)) {
                    result = true;
                }
            }
            return result;
        }
    }
}

