/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.pli2xsd.util;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.StringTokenizer;
import java.util.List;

public class GeneralUtil {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String XSD_SOAPENCODING = "http://schemas.xmlsoap.org/soap/encoding/";
    private static GeneralUtil thisInstance;

    public static synchronized GeneralUtil getInstance() {
        if (thisInstance == null) {
            thisInstance = new GeneralUtil();
        }
        return thisInstance;
    }

    public String capitalizeFirstLetter(String str) {
        return String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
    }

    public String getJavaNameFromXMLName(String xmlName, String delims) {
        int c;
        StringBuffer buffer = new StringBuffer();
        boolean needUpperCase = false;
        int i = 0;
        int l = xmlName.length();
        while (i < l) {
            c = UTF16.charAt((String)xmlName, (int)i);
            if ((c == 46 || UCharacter.isJavaIdentifierPart((int)c)) && delims.indexOf(c) == -1) {
                if (needUpperCase) {
                    c = UCharacter.toUpperCase((int)c);
                }
                UTF16.append((StringBuffer)buffer, (int)c);
                needUpperCase = false;
            } else {
                needUpperCase = true;
            }
            i += UTF16.getCharCount((int)c);
        }
        if (buffer.length() != 0) {
            c = UTF16.charAt((StringBuffer)buffer, (int)0);
            if (!UCharacter.isJavaIdentifierStart((int)c)) {
                buffer.insert(0, "__");
            }
            boolean allDigits = true;
            int i2 = 0;
            int l2 = buffer.length();
            while (i2 < l2) {
                int ch = UTF16.charAt((StringBuffer)buffer, (int)i2);
                if (!UCharacter.isDigit((int)ch)) {
                    allDigits = false;
                    break;
                }
                i2 += UTF16.getCharCount((int)ch);
            }
            if (allDigits) {
                buffer.insert(0, "__");
            }
        }
        return buffer.toString();
    }

    public String getJavaNameFromXMLName(String xmlName) {
        return this.getJavaNameFromXMLName(xmlName, "-.:\u00b7\u0387\u06dd\u06de");
    }

    public boolean isAllUpperCase(String str) {
        boolean allUpper = true;
        int i = 0;
        while (i < str.length()) {
            int c = UTF16.charAt((String)str, (int)i);
            if (UCharacter.isLowerCase((int)c)) {
                allUpper = false;
                break;
            }
            i += UTF16.getCharCount((int)c);
        }
        return allUpper;
    }

    public void replaceOrAppendToList(List list, Object ele, int pos) {
        if (pos < 0) {
            list.add(ele);
        } else {
            list.set(pos, ele);
        }
    }

    public String toLowerUpperCaseToken(String str) {
        return this.toLowerUpperCaseToken(str, false);
    }

    public String toLowerUpperCaseToken(String str, boolean preserveCase) {
        boolean leading2Underscores = false;
        if (str.startsWith("__")) {
            leading2Underscores = true;
        }
        StringTokenizer tokens = new StringTokenizer(str, "_");
        StringBuffer buf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!preserveCase && this.isAllUpperCase(token)) {
                token = token.toLowerCase();
            }
            if (buf.length() > 0) {
                buf.append("__");
            }
            buf.append(token);
        }
        String result = buf.toString();
        if (leading2Underscores) {
            result = "__" + result;
        }
        return result;
    }

    public static String getPathFromRefID(String refID) {
        return refID.substring(refID.indexOf(":") + 1);
    }

    public static String getElementNameFromPathNoCaseChange(String path) {
        String name = "";
        int slashPos = path.lastIndexOf("/");
        name = slashPos < 0 ? path : path.substring(slashPos + 1);
        return name;
    }

    public static String getParentPath(String path) {
        int slashPos = path.lastIndexOf("/");
        if (slashPos >= 0) {
            return path.substring(0, path.lastIndexOf("/"));
        }
        return null;
    }
}

