/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.pli2xsd.typesimport;

import com.ibm.ccl.pli2xsd.INameConverter;
import com.ibm.ccl.pli2xsd.typesimport.XsdHelper;
import com.ibm.ccl.pli2xsd.util.GeneralUtil;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class PLINameConverter
implements INameConverter {
    private XsdHelper xsdHelper;
    private GeneralUtil util = GeneralUtil.getInstance();

    @Override
    public void initialize() {
        this.xsdHelper = XsdHelper.getNewInstance();
    }

    @Override
    public void initialize(XsdHelper xsdHelper) {
        this.xsdHelper = xsdHelper;
    }

    @Override
    public String getConvertedName(String thisName, List pathVector, Object pliElement) {
        return this.getConvertedName(thisName, pathVector, pliElement, "", "", true);
    }

    @Override
    public String getConvertedName(String thisName, List pathVector, Object pliElement, String origTopTypeName, String topTypeName, boolean generateFlat) {
        thisName = this.convertNameStartWithDigits(thisName);
        thisName = this.convertInvalidName(thisName);
        String check = thisName = this.util.getJavaNameFromXMLName(thisName);
        int myPos = pathVector.size();
        int i = 1;
        while (this.hasDupulicate(check, generateFlat)) {
            String parentName;
            String string = parentName = myPos - 1 >= 0 ? (String)pathVector.get(myPos - 1) : check;
            if (parentName.equalsIgnoreCase(origTopTypeName)) {
                parentName = topTypeName;
            }
            parentName = this.util.getJavaNameFromXMLName(parentName);
            check = String.valueOf(parentName) + "_" + thisName;
            ++i;
            --myPos;
        }
        if (!check.equals(thisName)) {
            thisName = check;
        }
        return thisName;
    }

    public String convertNameStartWithDigits(String origName) {
        String str = origName;
        if (UCharacter.isDigit((int)UTF16.charAt((String)origName, (int)0))) {
            str = "X" + origName;
        }
        return str;
    }

    public String convertInvalidName(String origName) {
        return origName;
    }

    protected String getElementNameFromPath(String path) {
        String name = "";
        int slashPos = path.lastIndexOf("/");
        name = slashPos < 0 ? path : path.substring(slashPos + 1);
        GeneralUtil util = new GeneralUtil();
        name = util.toLowerUpperCaseToken(name);
        return name;
    }

    private boolean hasDupulicate(String name, boolean generateFlat) {
        Iterator it = this.xsdHelper.getPathXsdPair().values().iterator();
        while (it.hasNext() && generateFlat) {
            Element ele88;
            Object val = it.next();
            String xsdName = null;
            if (val instanceof XSDElementDeclaration) {
                XSDElementDeclaration xsdEle = (XSDElementDeclaration)val;
                xsdName = xsdEle.getName();
            } else if (val instanceof XSDComplexTypeDefinition) {
                XSDComplexTypeDefinition xsdCT = (XSDComplexTypeDefinition)val;
                xsdName = xsdCT.getName();
            } else if (val instanceof Element && (ele88 = (Element)val).getTagName().equals("level88")) {
                Text textNode = (Text)ele88.getFirstChild();
                String textContent = textNode.getData();
                xsdName = textContent.substring(0, textContent.indexOf(" "));
            }
            if (!name.equalsIgnoreCase(xsdName)) continue;
            return true;
        }
        return false;
    }
}

