package com.ibm.infrastructure;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WebFeedDOMParser {

	static Document document;

	static Bundle bundle = Platform.getBundle("com.ibm.ccl.feedreader");

	/*
	 * For any exception caught, return XML error message in requested locale.
	 * Check for instance of RSS or ATOM feed and use of appropiate xsl transformation.
	 */
	
	public static InputStream getFeed(String url, Locale locale)
			throws Exception {

		ByteArrayOutputStream actualOutputStream = new ByteArrayOutputStream();

		InputStream datafile = null;

		try {

	
			URL feedURL = new URL(url);
			datafile = feedURL.openStream();

			DocumentBuilderFactory factory = DocumentBuilderFactory
					.newInstance();

			// factory.setNamespaceAware(true);
			// factory.setValidating(true);

			DocumentBuilder builder = factory.newDocumentBuilder();
			document = builder.parse(datafile);

			URL stylesheet = getStyleSheetForFeed(document.getDocumentElement()
					.getNodeName());

			if (stylesheet == null)
				return ErrorMsgManager.getXMLErrorMessage(locale);

			// Use a Transformer for output
			TransformerFactory tFactory = TransformerFactory.newInstance();
			StreamSource stylesource = new StreamSource(stylesheet.openStream());
			Transformer transformer = tFactory.newTransformer(stylesource);

			DOMSource source = new DOMSource(document);
			StreamResult result = new StreamResult(actualOutputStream);
			transformer.transform(source, result);

		} catch (TransformerConfigurationException tce) {

			// Error generated by the parser
			System.out.println("\n** Transformer Factory error");
			System.out.println("   " + tce.getMessage());

			// Use the contained exception, if any
			Throwable x = tce;
			if (tce.getException() != null)
				x = tce.getException();
			x.printStackTrace();

			return ErrorMsgManager.getXMLErrorMessage(locale);

		} catch (TransformerException te) {

			// Error generated by the parser
			System.out.println("\n** Transformation error");
			System.out.println("   " + te.getMessage());

			// Use the contained exception, if any
			Throwable x = te;
			if (te.getException() != null)
				x = te.getException();
			x.printStackTrace();

			return ErrorMsgManager.getXMLErrorMessage(locale);

		} catch (SAXException sxe) {

			// Error generated by this application
			// (or a parser-initialization error)
			Exception x = sxe;
			if (sxe.getException() != null)
				x = sxe.getException();
			x.printStackTrace();

			return ErrorMsgManager.getXMLErrorMessage(locale);

		} catch (ParserConfigurationException pce) {

			// Parser with specified options can't be built
			pce.printStackTrace();

			return ErrorMsgManager.getXMLErrorMessage(locale);

		} catch (IOException ioe) {

			// I/O error
			ioe.printStackTrace();

			return ErrorMsgManager.getXMLErrorMessage(locale);
		}

		String actualString = actualOutputStream.toString("UTF8");
		System.out.print(actualString);

		return new ByteArrayInputStream(actualOutputStream.toString("UTF8")
				.getBytes("UTF8"));

	}// getFeed

	public static URL getStyleSheetForFeed(String feedType) {

		Path path;
		URL stylesheet;
		  
		if (feedType == "rss") {
			path = new Path("scripts/rss.xsl");
			stylesheet = Platform.find(bundle, path);
		} else if (feedType == "feed") {
			path = new Path("scripts/atom.xsl");
			stylesheet = Platform.find(bundle, path);
		} else
			// Unrecognized feed
			return null;

		return stylesheet;

	}

}
