/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.widgets;

import com.ibm.ast.ws.jaxws.emitter.collector.ServiceData;
import com.ibm.ast.ws.policyset.ui.collector.CollectorUtils;
import com.ibm.ast.ws.was61.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was61.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was61.policyset.ui.common.ProjectContainerPropertyTester;
import com.ibm.ast.ws.was61.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was61.policyset.ui.tables.EndPointConfigurationTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSidePolicyAttachmentWidget
extends SimpleWidgetDataContributor {
    private Listener statusListener_;
    private String INFOPOP_SSATT_PAGE = "SSATT0003";
    private String INFOPOP_SSATT_PROJECT_COMBO = "SSATT0001";
    private Combo webService;
    private Map<String, IServicePolicy> policySets;
    private String INFOPOP_SSATT_ENDPOINT_GROUP = "SSATT0002";
    private EndPointConfigurationTable table;
    private Map<String, ServiceData> servicesMap;
    private ServiceData selectedWebService;
    private IProject project;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener_ = statusListener;
        UIUtils uiUtils = Activator.getUiUtils();
        this.servicesMap = new HashMap<String, ServiceData>();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.INFOPOP_SSATT_PAGE);
        Composite composite = uiUtils.createComposite(parent, 2);
        this.webService = uiUtils.createCombo(composite, Activator.getMessage("LABEL_WEB_SERVICE"), Activator.getMessage("TOOLTIP_SSATT_PROJECT_COMBO"), this.INFOPOP_SSATT_PROJECT_COMBO, 2060);
        this.webService.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServerSidePolicyAttachmentWidget.this.selectedWebService == null || !ServerSidePolicyAttachmentWidget.this.formatServiceDisplayName(ServerSidePolicyAttachmentWidget.this.selectedWebService).equals(ServerSidePolicyAttachmentWidget.this.webService.getText())) {
                    ServerSidePolicyAttachmentWidget.this.selectedWebService = (ServiceData)ServerSidePolicyAttachmentWidget.this.servicesMap.get(ServerSidePolicyAttachmentWidget.this.webService.getText());
                    ServerSidePolicyAttachmentWidget.this.refreshTable();
                    ServerSidePolicyAttachmentWidget.this.statusListener_.handleEvent(null);
                }
            }
        });
        Group endPointGroup = uiUtils.createGroup(parent, Activator.getMessage("LABEL_APPLICATION"), Activator.getMessage("TOOLTIP_SSATT_ENDPOINT_GROUP"), this.INFOPOP_SSATT_ENDPOINT_GROUP, 2, -1, -1);
        GridData griddata = new GridData(1808);
        endPointGroup.setLayoutData((Object)griddata);
        this.table = new EndPointConfigurationTable((Composite)endPointGroup, this.statusListener_, new String[]{Activator.getMessage("LABEL_COL_ENDPOINT"), Activator.getMessage("LABEL_COL_POLICYSET_ATTACHED"), Activator.getMessage("LABEL_COL_BINDING_ATTACHED")});
        this.table.setPolicySets(this.policySets);
        return this;
    }

    private void refreshTable() {
        IVirtualComponent[] components = J2EEUtils.getReferencingEARComponents((IProject)this.selectedWebService.getProject());
        if (components.length == 0) {
            this.project = null;
        } else {
            this.project = components[0].getProject();
            this.table.setApplication(this.project);
            this.table.setPolicySets(this.policySets);
            this.table.setReferences(PolicyUtils.readServerPolicyAttachments(this.project, this.policySets));
            this.table.setServiceData(new ServiceData[]{this.selectedWebService});
        }
    }

    public IStatus getStatus() {
        if (this.webService.getItemCount() == 0) {
            return new Status(4, "com.ibm.ast.ws.was61.policyset.ui", 0, Activator.getMessage("ERROR_NO_WEBSEVICE_EARS"), null);
        }
        if (this.project == null) {
            return new Status(4, "com.ibm.ast.ws.was61.policyset.ui", 0, Activator.getMessage("ERROR_WEB_SERVICE_WITH_NO_CONTAINER"), null);
        }
        return Status.OK_STATUS;
    }

    public List<EndPointObject> getReferences() {
        return this.table.getReferences();
    }

    public IProject getProject() {
        return this.project;
    }

    public String getWebServiceName() {
        return EndPointObject.getQualifiedServiceName(this.selectedWebService, this.project);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setServiceData(ServiceData serviceData) {
        if (serviceData == null) {
            this.webService.removeAll();
            ServiceData[] serviceDataArray = CollectorUtils.collectAllServiceData();
            int n = serviceDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceData data = serviceDataArray[n2];
                if (ProjectContainerPropertyTester.isSupportedServiceData(data)) {
                    String formattedName = this.formatServiceDisplayName(data);
                    this.servicesMap.put(formattedName, data);
                    this.webService.add(formattedName);
                }
                ++n2;
            }
            if (this.webService.getItemCount() <= 0) return;
            this.webService.select(0);
            this.selectedWebService = this.servicesMap.get(this.webService.getText());
            this.refreshTable();
            return;
        } else {
            this.selectedWebService = serviceData;
            this.webService.setItems(new String[]{this.formatServiceDisplayName(this.selectedWebService)});
            this.webService.select(0);
            this.refreshTable();
        }
    }

    private String formatServiceDisplayName(ServiceData data) {
        return String.valueOf(data.getProject().getName()) + ":{" + data.getTargetNamespace() + "}" + data.getServiceName();
    }

    public void setPolicySets(Map<String, IServicePolicy> policySets) {
        this.policySets = policySets;
        if (this.table != null) {
            this.table.setPolicySets(policySets);
        }
        if (this.selectedWebService != null) {
            this.refreshTable();
        }
    }
}

