/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.validator;

import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.was61.policyset.ui.types.PolicyType;
import com.ibm.ast.ws.was61.policyset.ui.validator.BindingXMLBadAttribute;
import com.ibm.ast.ws.was61.policyset.ui.validator.BindingXMLBadElement;
import com.ibm.ast.ws.was61.policyset.ui.validator.BindingXMLParser;
import com.ibm.ast.ws.was61.policyset.ui.validator.BindingXMLValidatorHelper;
import com.ibm.ws.ast.facets.core.IFacetConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingXMLValidator
extends AbstractValidator
implements IValidatorJob {
    public static final String BUNDLE_ID = "com.ibm.ast.ws.was61.policyset.ui.plugin";
    public static final String MARKER_ID = "com.ibm.ast.ws.was61.policyset.ui.bindingxmlmarker";
    private ISchedulingRule emptyRule_ = new EmptyRule();

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return this.emptyRule_;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validate(helper, reporter);
        return Status.OK_STATUS;
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationResult vr = new ValidationResult();
        IReporter reporter = vr.getReporter(monitor);
        BindingXMLValidatorHelper helper = new BindingXMLValidatorHelper();
        LinkedList<String> names = new LinkedList<String>();
        names.add(helper.getPortableName(resource));
        helper.setValidationFileURIs(names);
        helper.setProject(resource.getProject());
        try {
            this.validate((IValidationContext)helper, reporter);
        }
        catch (ValidationException e) {
            vr.setValidationException(e);
        }
        return vr;
    }

    public void cleanup(IReporter arg0) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        BindingXMLValidatorHelper validatorHelper = (BindingXMLValidatorHelper)helper;
        String[] uris = validatorHelper.getURIs();
        IProject project = validatorHelper.getProject();
        if (this.isSupportedProject(project)) {
            String folderPath = CommonPolicyUtils.getOutputFolder((IProject)project, (boolean)false).getFullPath().addTrailingSeparator().toString();
            int i = 0;
            while (i < uris.length) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uris[i]));
                if (file.getFullPath().toString().startsWith(folderPath)) {
                    this.validateBindingXML(file, reporter);
                }
                ++i;
            }
        }
    }

    private final void validateBindingXML(IFile file, IReporter reporter) {
        reporter.removeAllMessages((IValidator)this, (Object)file);
        PolicyType policyType = PolicyType.getType(file.getParent().getName());
        ArrayList<BindingXMLBadElement> badElements = policyType.validateBindingXML(file, policyType.getName());
        this.reportBadElements(badElements, file, reporter);
    }

    private final void reportBadElements(ArrayList<BindingXMLBadElement> badElements, IFile file, IReporter reporter) {
        try {
            new BindingXMLParser(file.getLocation().toFile().getAbsolutePath(), badElements);
            int i = 0;
            while (i < badElements.size()) {
                BindingXMLBadElement badElement = badElements.get(i);
                for (BindingXMLBadAttribute badAttr : badElement.getAttributes()) {
                    Message message = (Message)badAttr.getMessage();
                    reporter.addMessage((IValidator)this, (IMessage)message);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            reporter.addMessage((IValidator)this, (IMessage)new Message(BUNDLE_ID, 1, "MSG_ERROR_PARSER", new String[]{file.getFullPath().toString()}, (Object)file));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSupportedProject(IProject project) {
        try {
            String version;
            String id;
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject == null) {
                return false;
            }
            Iterator iterator = facetedProject.getProjectFacets().iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                IProjectFacetVersion pfv = (IProjectFacetVersion)iterator.next();
                id = pfv.getProjectFacet().getId();
                version = pfv.getVersionString();
                if (!id.equals("com.ibm.websphere.wsfp.web") && !id.equals("com.ibm.websphere.wsfp.appclient") || !version.equals("1.0")) continue;
                return true;
            } while (!id.equals(IFacetConstants.EAR_EXTENDED_FACET_ID) || !version.equals("6.1"));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private class EmptyRule
    implements ISchedulingRule {
        private EmptyRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

