/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.types;

import com.ibm.ast.ws.was61.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was61.policyset.ui.dialogs.WSRMBindingConfigurationDialog;
import com.ibm.ast.ws.was61.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was61.policyset.ui.types.PolicyType;
import com.ibm.ws.websvcs.rm.policyset.gen.BusConfiguration;
import com.ibm.ws.websvcs.rm.policyset.gen.ObjectFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;

public class WSReliableMessagingPolicy
extends PolicyType {
    public static String PolicyTypeName = "WSReliableMessaging";
    public static String ContextPath = "com.ibm.ws.websvcs.rm.policyset.gen";
    private String busName = "";
    private String messagingEngineName = "";
    private boolean isPersistent;
    private boolean noConfig;
    protected static JAXBContext jc;
    protected static Unmarshaller u;
    protected static Marshaller m;
    protected String CONTEXT_PATH = "org.xmlsoap.schemas.ws._2004._09.policy:org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0:com.ibm.ws.websvcs.rm.policyset.gen";

    protected Marshaller getMarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (m == null) {
            m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
        }
        return m;
    }

    protected Unmarshaller getUnmarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (u == null) {
            u = jc.createUnmarshaller();
        }
        return u;
    }

    public IStatus saveBindingConfiguration(File location) {
        try {
            BusConfiguration bindings = this.rmBindings();
            this.writeRmBindings(bindings, location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    private BusConfiguration rmBindings() {
        ObjectFactory bindingFactory = new ObjectFactory();
        BusConfiguration busConfigurations = bindingFactory.createBusConfiguration();
        busConfigurations.setBusName(this.busName);
        busConfigurations.setMessagingEngineName(this.messagingEngineName);
        return busConfigurations;
    }

    private void writeRmBindings(BusConfiguration rmBindings, File bindingLocation) throws Exception {
        IPath fileLocation = new Path(bindingLocation.getAbsolutePath()).append("bindings.xml");
        JAXBContext jc = JAXBContext.newInstance((String)ContextPath);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        FileOutputStream os = new FileOutputStream(fileLocation.toFile());
        m.marshal((Object)rmBindings, (OutputStream)os);
        ((OutputStream)os).close();
    }

    public void readBindingConfiguration(IPath location) {
        String policySetName = this.getServicePolicy().getParentPolicy().getDescriptor().getShortName();
        this.isPersistent = policySetName.equals("WSReliableMessaging persistent");
        this.noConfig = policySetName.equals("WSReliableMessaging default");
        if (location == null) {
            return;
        }
        try {
            Object bindings = PolicyUtils.readExistingBindingConfiguration(location, this.getName(), ContextPath);
            if (bindings == null) {
                return;
            }
            BusConfiguration busConfigurations = (BusConfiguration)bindings;
            this.busName = busConfigurations.getBusName();
            this.messagingEngineName = busConfigurations.getMessagingEngineName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return PolicyTypeName;
    }

    public Dialog getConfigurationDialog(Shell shell) {
        if (this.noConfig) {
            return null;
        }
        return new WSRMBindingConfigurationDialog(shell, this);
    }

    public String validateConfiguration() {
        if (this.noConfig) {
            this.busName = null;
            this.messagingEngineName = null;
            return Activator.getMessage("CONFIGURATION_NA");
        }
        if (!this.isPersistent || this.busName != null && !this.busName.equals("") && this.messagingEngineName != null && !this.messagingEngineName.equals("")) {
            return Activator.getMessage("CONFIGURED");
        }
        return Activator.getMessage("NOT_CONFIGURED");
    }

    public String getMessagingEngineName() {
        return this.messagingEngineName;
    }

    public void setMessagingEngineName(String messagingEngineName) {
        this.messagingEngineName = messagingEngineName;
    }

    public String getBusName() {
        return this.busName;
    }

    public void setBusName(String busName) {
        this.busName = busName;
    }
}

