/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.types;

import com.ibm.ast.ws.policyset.ui.common.SSLSettingsObject;
import com.ibm.ast.ws.was61.policyset.ui.common.PolicyUtils;
import com.ibm.ast.ws.was61.policyset.ui.dialogs.WSsslTransportBindingConfigurationDialog;
import com.ibm.ast.ws.was61.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was61.policyset.ui.types.PolicyType;
import com.ibm.ws.websvcs.transport.policyset.jaxb.All;
import com.ibm.ws.websvcs.transport.policyset.jaxb.ConfigAlias;
import com.ibm.ws.websvcs.transport.policyset.jaxb.ConfigFile;
import com.ibm.ws.websvcs.transport.policyset.jaxb.ExactlyOne;
import com.ibm.ws.websvcs.transport.policyset.jaxb.InResponsewithSSL;
import com.ibm.ws.websvcs.transport.policyset.jaxb.ObjectFactory;
import com.ibm.ws.websvcs.transport.policyset.jaxb.OutRequestwithSSL;
import com.ibm.ws.websvcs.transport.policyset.jaxb.Policy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;

public class SSLTransportPolicy
extends PolicyType {
    public static String PolicyTypeName = "SSLTransport";
    public static String ContextPath = "com.ibm.ws.websvcs.transport.policyset.jaxb";
    private SSLSettingsObject outRequest;
    private SSLSettingsObject inResponse;
    protected static JAXBContext jc;
    protected static Unmarshaller u;
    protected static Marshaller m;
    protected String CONTEXT_PATH = "com.ibm.ws.websvcs.transport.policyset.jaxb:org.xmlsoap.schemas.ws._2004._09.policy";

    protected Marshaller getMarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (m == null) {
            m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
        }
        return m;
    }

    protected Unmarshaller getUnmarshaller() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)this.CONTEXT_PATH);
        }
        if (u == null) {
            u = jc.createUnmarshaller();
        }
        return u;
    }

    public IStatus saveBindingConfiguration(File location) {
        try {
            Policy bindings = this.sslTransportBindings();
            this.writeSSLTransportBindings(bindings, location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    private Policy sslTransportBindings() {
        ObjectFactory bindingFactory = new ObjectFactory();
        Policy transportPolicy = bindingFactory.createPolicy();
        ExactlyOne exactlyOne = bindingFactory.createExactlyOne();
        All all = bindingFactory.createAll();
        OutRequestwithSSL outRequestwithSSL = bindingFactory.createOutRequestwithSSL();
        ConfigAlias configAlias = bindingFactory.createConfigAlias();
        configAlias.setName(this.outRequest.getSslSettings());
        outRequestwithSSL.setConfigAlias(configAlias);
        ConfigFile configFile = bindingFactory.createConfigFile();
        configFile.setPath(this.outRequest.getPropertyFile());
        outRequestwithSSL.setConfigFile(configFile);
        all.setOutRequestwithSSL(outRequestwithSSL);
        InResponsewithSSL inResponsewithSSL = bindingFactory.createInResponsewithSSL();
        configAlias = bindingFactory.createConfigAlias();
        configAlias.setName(this.inResponse.getSslSettings());
        inResponsewithSSL.setConfigAlias(configAlias);
        configFile = bindingFactory.createConfigFile();
        configFile.setPath(this.inResponse.getPropertyFile());
        inResponsewithSSL.setConfigFile(configFile);
        all.setInResponsewithSSL(inResponsewithSSL);
        exactlyOne.getAll().add(all);
        transportPolicy.setExactlyOne(exactlyOne);
        return transportPolicy;
    }

    private void writeSSLTransportBindings(Policy transportPolicy, File bindingLocation) throws Exception {
        IPath fileLocation = new Path(bindingLocation.getAbsolutePath()).append("bindings.xml");
        JAXBContext jc = JAXBContext.newInstance((String)ContextPath);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        FileOutputStream os = new FileOutputStream(fileLocation.toFile());
        m.marshal((Object)transportPolicy, (OutputStream)os);
        ((OutputStream)os).close();
    }

    public String getName() {
        return PolicyTypeName;
    }

    public Dialog getConfigurationDialog(Shell shell) {
        return new WSsslTransportBindingConfigurationDialog(shell, this);
    }

    public String validateConfiguration() {
        if (this.outRequest != null && this.outRequest.isValid() && this.inResponse != null && this.inResponse.isValid()) {
            return Activator.getMessage("CONFIGURED");
        }
        return Activator.getMessage("NOT_CONFIGURED");
    }

    public SSLSettingsObject getInResponsewithSSL() {
        return this.inResponse;
    }

    public void setInResponsewithSSL(SSLSettingsObject inResponsewithSSL) {
        this.inResponse = inResponsewithSSL;
    }

    public SSLSettingsObject getOutRequestwithSSL() {
        return this.outRequest;
    }

    public void setOutRequestwithSSL(SSLSettingsObject outRequestwithSSL) {
        this.outRequest = outRequestwithSSL;
    }

    public void readBindingConfiguration(IPath folder) {
        if (folder == null) {
            return;
        }
        try {
            Object policy = PolicyUtils.readExistingBindingConfiguration(folder, this.getName(), ContextPath);
            if (policy == null) {
                this.inResponse = new SSLSettingsObject();
                this.outRequest = new SSLSettingsObject();
                return;
            }
            Policy transportPolicy = (Policy)policy;
            ExactlyOne exactlyOne = transportPolicy.getExactlyOne();
            All all = (All)exactlyOne.getAll().get(0);
            OutRequestwithSSL outRequestwithSSL = all.getOutRequestwithSSL();
            ConfigAlias configAlias = outRequestwithSSL.getConfigAlias();
            ConfigFile configFile = outRequestwithSSL.getConfigFile();
            this.outRequest = new SSLSettingsObject(configAlias.getName(), configFile.getPath());
            InResponsewithSSL inResponsewithSSL = all.getInResponsewithSSL();
            configAlias = inResponsewithSSL.getConfigAlias();
            configFile = inResponsewithSSL.getConfigFile();
            this.inResponse = new SSLSettingsObject(configAlias.getName(), configFile.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

