/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.types;

import com.ibm.ast.ws.was61.policyset.ui.types.HTTPTransportPolicy;
import com.ibm.ast.ws.was61.policyset.ui.types.SSLTransportPolicy;
import com.ibm.ast.ws.was61.policyset.ui.types.WSAddressingPolicy;
import com.ibm.ast.ws.was61.policyset.ui.types.WSReliableMessagingPolicy;
import com.ibm.ast.ws.was61.policyset.ui.types.WSSecurityPolicy;
import com.ibm.ast.ws.was61.policyset.ui.types.WSTransactionPolicy;
import com.ibm.ast.ws.was61.policyset.ui.validator.BindingXMLBadAttribute;
import com.ibm.ast.ws.was61.policyset.ui.validator.BindingXMLBadElement;
import java.io.File;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PolicyType {
    protected IServicePolicy servicePolicy;

    public abstract String getName();

    public abstract Dialog getConfigurationDialog(Shell var1);

    public abstract IStatus saveBindingConfiguration(File var1);

    public abstract String validateConfiguration();

    public abstract void readBindingConfiguration(IPath var1);

    protected abstract Unmarshaller getUnmarshaller() throws JAXBException;

    protected abstract Marshaller getMarshaller() throws JAXBException;

    public ArrayList<BindingXMLBadElement> validateBindingXML(IFile file, String policyType) {
        ArrayList<BindingXMLBadElement> badElements = new ArrayList<BindingXMLBadElement>();
        return badElements;
    }

    protected BindingXMLBadElement newBadElement(String element, String attrName, String attrValue, int severity, String message, String[] messageStrings, IFile file) {
        BindingXMLBadElement badElement = new BindingXMLBadElement(element);
        BindingXMLBadAttribute badAttr = new BindingXMLBadAttribute(attrName, attrValue);
        badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.was61.policyset.ui.plugin", severity, message, messageStrings, (Object)file));
        badElement.setAttribute(badAttr);
        return badElement;
    }

    public static PolicyType getType(String policyTypeName) {
        PolicyType type = null;
        if (policyTypeName.equals(WSAddressingPolicy.PolicyTypeName)) {
            type = new WSAddressingPolicy();
        }
        if (policyTypeName.equals(WSSecurityPolicy.PolicyTypeName)) {
            type = new WSSecurityPolicy();
        }
        if (policyTypeName.equals(WSReliableMessagingPolicy.PolicyTypeName)) {
            type = new WSReliableMessagingPolicy();
        }
        if (policyTypeName.equals(WSTransactionPolicy.PolicyTypeName)) {
            type = new WSTransactionPolicy();
        }
        if (policyTypeName.equals(HTTPTransportPolicy.PolicyTypeName)) {
            type = new HTTPTransportPolicy();
        }
        if (policyTypeName.equals(SSLTransportPolicy.PolicyTypeName)) {
            type = new SSLTransportPolicy();
        }
        return type;
    }

    public IServicePolicy getServicePolicy() {
        return this.servicePolicy;
    }

    public void setServicePolicy(IServicePolicy servicePolicy) {
        this.servicePolicy = servicePolicy;
    }
}

