/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.types;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyConfigUtil {
    protected static String policyNS = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    protected static final String secPolicyNS = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
    protected static QName policyQName = new QName(policyNS, "Policy");
    protected static QName signedPartsQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SignedParts");
    protected static QName signedElementsQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SignedElements");
    protected static QName encryptedPartsQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "EncryptedParts");
    protected static QName encryptedElementsQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "EncryptedElements");
    protected static QName asymmetricBindingQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "AsymmetricBinding");
    protected static QName symmetricBindingQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SymmetricBinding");
    protected static QName algorithmSuiteQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "AlgorithmSuite");
    protected static QName wss10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Wss10");
    protected static QName wss11QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Wss11");
    protected static QName trust10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Trust10");
    protected static QName supportingTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SupportingTokens");
    protected static QName signedSupportingTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SignedSupportingTokens");
    protected static QName layoutQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Layout");
    protected static QName usernameTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "UsernameToken");
    protected static QName wssUsernameToken10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssUsernameToken10");
    protected static QName wssUsernameToken11QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssUsernameToken11");
    protected static QName wssIncludeTimestampQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "IncludeTimestamp");
    protected static String xmiNS = "http://schema.omg.org/spec/XMI/1.0";
    protected static QName xmiLabelQName = new QName(xmiNS, "label");
    protected static final String requestIdentifier = "request:";
    protected static final String responseIdentifier = "response:";
    protected static final String algorithmHmacSha1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    protected static final String algorithmRsaSha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    protected static final String algorithmSha1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    protected static final String algorithmSha256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    protected static final String algorithmSha512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    protected static final String algorithmAes128 = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    protected static final String algorithmAes192 = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    protected static final String algorithmAes256 = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    protected static final String algorithmTripleDes = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    protected static final String algorithmKwAes128 = "http://www.w3.org/2001/04/xmlenc#kw-aes128-cbc";
    protected static final String algorithmKwAes192 = "http://www.w3.org/2001/04/xmlenc#kw-aes192-cbc";
    protected static final String algorithmKwAes256 = "http://www.w3.org/2001/04/xmlenc#kw-aes256-cbc";
    protected static final String algorithmKwTripleDes = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    protected static final String algorithmKwRsaOaep = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    protected static final String algorithmKwRsa15 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    protected static final String algorithmPSha1 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
    protected static final String algorithmPSha1L128 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
    protected static final String algorithmPSha1L192 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
    protected static final String algorithmPSha1L256 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
    protected static final String algorithmXPath = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    protected static final String algorithmXPath20 = "http://www.w3.org/2002/06/xmldsig-filter2";
    protected static final String algorithmC14n = "http://www.w3.org/2001/10/xml-c14n#";
    protected static final String algorithmExC14n = "http://www.w3.org/2001/10/xml-exc-c14n#";
    protected static final String algorithmSNT = "http://www.w3.org/TR/soap12-n11n";
    protected static final String algorithmSTRT10 = "http://docs.oasis-open.org/wss/2004/xx/oasis-2004xx-wss-soap-message-security-1.0#STR-Transform";
    protected static final String BASIC256 = "Basic256";
    protected static final String BASIC192 = "Basic192";
    protected static final String BASIC128 = "Basic128";
    protected static final String TRIPLEDES = "TripleDes";
    protected static final String BASIC256_RSA15 = "Basic256Rsa15";
    protected static final String BASIC192_RSA15 = "Basic192Rsa15";
    protected static final String BASIC128_RSA15 = "Basic128Rsa15";
    protected static final String TRIPLEDES_RSA15 = "TripleDesRsa15";
    protected static final String BASIC256_SHA256 = "Basic256Sha256";
    protected static final String BASIC192_SHA256 = "Basic192Sha256";
    protected static final String BASIC128_SHA256 = "Basic128Sha256";
    protected static final String TRIPLEDES_SHA256 = "TripleDesSha256";
    protected static final String BASIC256_SHA256_RSA15 = "Basic256Sha256Rsa15";
    protected static final String BASIC192_SHA256_RSA15 = "Basic192Sha256Rsa15";
    protected static final String BASIC128_SHA256_RSA15 = "Basic128Sha256Rsa15";
    protected static final String TRIPLEDES_SHA256_RSA15 = "TripleDesSha256Rsa15";
    protected static final String INCLUSIVE_C14N = "InclusiveC14N";
    protected static final String SOAP_NORMALIZATION10 = "SOAPNormalization10";
    protected static final String STRTRANSFORM10 = "STRTransform10";
    protected static final String XPATH10 = "XPath10";
    protected static final String XPATH20 = "XPath20";
    protected static final String ABSXPATH = "AbsXPath";
    protected static final String RECIPIENT_TOKEN = "RecipientToken";
    protected static final String INITIATOR_TOKEN = "InitiatorToken";
    protected static final String INITIATOR_SIGNATURE_TOKEN = "InitiatorSignatureToken";
    protected static final String RECIPIENT_SIGNATURE_TOKEN = "RecipientSignatureToken";
    protected static final String INITIATOR_ENCRYPTION_TOKEN = "InitiatorEncryptionToken";
    protected static final String RECIPIENT_ENCRYPTION_TOKEN = "RecipientEncryptionToken";
    protected static final String ENCRYPTION_TOKEN = "EncryptionToken";
    protected static final String SIGNATURE_TOKEN = "SignatureToken";
    protected static final String PROTECTION_TOKEN = "ProtectionToken";
    protected static final String STRICT = "Strict";
    protected static final String LAX = "Lax";
    protected static final String LAX_TS_FIRST = "LaxTsFirst";
    protected static final String LAX_TS_LAST = "LaxTsLast";
    protected static final String MUST_SUPPORT_REF_KEY_IDENTIFIER = "MustSupportRefKeyIdentifier";
    protected static final String MUST_SUPPORT_REF_KEY_ISSUER_SERIAL = "MustSupportRefIssuerSerial";
    protected static final String MUST_SUPPORT_REF_EXTERNAL_URI = "MustSupportRefExternalURI";
    protected static final String MUST_SUPPORT_REF_EMBEDDED_TOKEN = "MustSupportRefEmbeddedToken";
    protected static final String MUST_SUPPORT_REF_THUMBPRINT = "MustSupportRefThumbprint";
    protected static final String MUST_SUPPORT_REF_ENCRYPTED_KEY = "MustSupportRefEncryptedKey";
    protected static final String REQUIRE_SIGNATURE_CONFIRMATION = "RequireSignatureConfirmation";
    protected static final String MUST_SUPPORT_CLIENT_CHALLENGE = "MustSupportClientChallenge";
    protected static final String MUST_SUPPORT_SERVER_CHALLENGE = "MustSupportServerChallenge";
    protected static final String REQUIRE_CLIENT_ENTROPY = "RequireClientEntropy";
    protected static final String REQUIRE_SERVER_ENTROPY = "RequireServerEntropy";
    protected static final String MUST_SUPPORT_ISSUED_TOKENS = "MustSupportIssuedTokens";
    protected static final String REQUIRE_DERIVED_KEYS = "RequireDerivedKeys";
    protected static final String REQUIRE_IMPLICIT_DERIVED_KEYS = "RequireImplicitDerivedKeys";
    protected static final String REQUIRE_EXPLICIT_DERIVED_KEYS = "RequireExplicitDerivedKeys";
    protected static final String REQUIRE_KEY_IDENTIFIER_REFERENCE = "RequireKeyIdentifierReference";
    protected static final String REQUIRE_ISSUER_SERIAL_REFERENCE = "RequireIssuerSerialReference";
    protected static final String REQUIRE_EMBEDDED_TOKEN_REFERENCE = "RequireEmbeddedTokenReference";
    protected static final String REQUIRE_THUMBPRINT_REFERENCE = "RequireThumbprintReference";
    protected static final String WSS_X509V3_TOKEN10 = "WssX509V3Token10";
    protected static final String WSS_X509_PKCS7_TOKEN10 = "WssX509Pkcs7Token10";
    protected static final String WSS_X509_PKI_PATH_V1_TOKEN10 = "WssX509PkiPathV1Token10";
    protected static final String WSS_X509V1_TOKEN11 = "WssX509V1Token11";
    protected static final String WSS_X509V3_TOKEN11 = "WssX509V3Token11";
    protected static final String WSS_X509_PKCS7_TOKEN11 = "WssX509Pkcs7Token11";
    protected static final String WSS_X509_PKI_PATH_V1_TOKEN11 = "WssX509PkiPathV1Token11";
    protected static final String WSS_USERNAME_TOKEN10 = "WssUsernameToken10";
    protected static final String WSS_USERNAME_TOKEN11 = "WssUsernameToken11";
    protected static final String REQUIRE_EXTERNAL_URI_REFERENCE = "RequireExternalUriReference";
    protected static final String SC200502_SECURITY_CONTEXT_TOKEN = "SC200502SecurityContextToken";
    protected static final String BOOTSTRAP_POLICY = "BootstrapPolicy";
    protected static final String WSS_CUSTOM_TOKEN = "WssCustomToken";
    protected static final String USERNAME_TOKEN = "UsernameToken";
    protected static final String X509TOKEN = "X509Token";
    protected static final String SECURE_CONVERSATION_TOKEN = "SecureConversationToken";
    protected static final String CUSTOM_TOKEN = "CustomToken";
    protected static final String LTPA_TOKEN = "LTPAToken";
    protected static final String LTPA_PROPAGATION_TOKEN = "LTPAPropagationToken";
    protected static final int SYMMETRIC_KEY_SIGNATURE_ALGORITHM = 0;
    protected static final int ASYMMETRIC_KEY_SIGNATURE_ALGORITHM = 1;
    protected static final int DIGEST_ALGORITHM = 2;
    protected static final int ENCRYPTION_ALGORITHM = 3;
    protected static final int SYMMETRIC_KEY_WRAP_ALGORITHM = 4;
    protected static final int ASYMMETRIC_KEY_WRAP_ALGORITHM = 5;
    protected static final int COMPUTED_KEY_ALGORITHM = 6;
    protected static final int ENCRYPTION_KEY_DERIVATION_ALGORITHM = 7;
    protected static final int SIGNATURE_KEY_DERIVATION_ALGORITHM = 8;
    protected static final String WS_SEC = "ws-security";
    protected static final String NON_WS_SEC = "non-ws-security";

    protected static Set<String> getAllowedAlgorithms(int algorithmType) {
        HashSet<String> allowedAlgorithms = new HashSet<String>();
        switch (algorithmType) {
            case 0: {
                allowedAlgorithms.add(algorithmRsaSha1);
                allowedAlgorithms.add(algorithmHmacSha1);
                break;
            }
            case 1: {
                allowedAlgorithms.add(algorithmHmacSha1);
                allowedAlgorithms.add(algorithmRsaSha1);
                break;
            }
            case 2: {
                allowedAlgorithms.add(algorithmSha256);
                allowedAlgorithms.add(algorithmSha1);
                break;
            }
            case 3: {
                allowedAlgorithms.add(algorithmAes256);
                allowedAlgorithms.add(algorithmAes192);
                allowedAlgorithms.add(algorithmAes128);
                allowedAlgorithms.add(algorithmTripleDes);
                break;
            }
            case 7: {
                allowedAlgorithms.add("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1");
                allowedAlgorithms.add("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1");
                allowedAlgorithms.add("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1");
                break;
            }
            case 5: {
                allowedAlgorithms.add(algorithmKwRsa15);
                allowedAlgorithms.add(algorithmKwRsaOaep);
                allowedAlgorithms.add("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1");
                break;
            }
            case 4: {
                allowedAlgorithms.add(algorithmKwAes256);
                allowedAlgorithms.add(algorithmKwAes192);
                allowedAlgorithms.add(algorithmKwAes128);
                allowedAlgorithms.add(algorithmKwTripleDes);
            }
        }
        return allowedAlgorithms;
    }

    protected static boolean isValidAlgorithmSuite(String algorithmSuite) {
        boolean validFlag = false;
        if (algorithmSuite.equals(BASIC256) || algorithmSuite.equals(BASIC192) || algorithmSuite.equals(BASIC128) || algorithmSuite.equals(TRIPLEDES) || algorithmSuite.equals(BASIC256_RSA15) || algorithmSuite.equals(BASIC192_RSA15) || algorithmSuite.equals(BASIC128_RSA15) || algorithmSuite.equals(TRIPLEDES_RSA15) || algorithmSuite.equals(BASIC256_SHA256) || algorithmSuite.equals(BASIC192_SHA256) || algorithmSuite.equals(BASIC128_SHA256) || algorithmSuite.equals(TRIPLEDES_SHA256) || algorithmSuite.equals(BASIC256_SHA256_RSA15) || algorithmSuite.equals(BASIC192_SHA256_RSA15) || algorithmSuite.equals(BASIC128_SHA256_RSA15) || algorithmSuite.equals(TRIPLEDES_SHA256_RSA15)) {
            validFlag = true;
        }
        return validFlag;
    }

    protected static String getAlgorithm(String algorithmSuite, int algorithmType) {
        String algorithm = null;
        switch (algorithmType) {
            case 0: {
                algorithm = algorithmHmacSha1;
                break;
            }
            case 1: {
                algorithm = algorithmRsaSha1;
                break;
            }
            case 6: {
                algorithm = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
                break;
            }
            case 2: {
                if (algorithmSuite.contains("Sha256")) {
                    algorithm = algorithmSha256;
                    break;
                }
                algorithm = algorithmSha1;
                break;
            }
            case 3: {
                if (algorithmSuite.contains(BASIC256)) {
                    algorithm = algorithmAes256;
                    break;
                }
                if (algorithmSuite.contains(BASIC192)) {
                    algorithm = algorithmAes192;
                    break;
                }
                if (algorithmSuite.contains(BASIC128)) {
                    algorithm = algorithmAes128;
                    break;
                }
                algorithm = algorithmTripleDes;
                break;
            }
            case 4: {
                if (algorithmSuite.contains(BASIC256)) {
                    algorithm = algorithmKwAes256;
                    break;
                }
                if (algorithmSuite.contains(BASIC192)) {
                    algorithm = algorithmKwAes192;
                    break;
                }
                if (algorithmSuite.contains(BASIC128)) {
                    algorithm = algorithmKwAes128;
                    break;
                }
                algorithm = algorithmKwTripleDes;
                break;
            }
            case 5: {
                if (algorithmSuite.contains("Rsa15")) {
                    algorithm = algorithmKwRsa15;
                    break;
                }
                algorithm = algorithmKwRsaOaep;
                break;
            }
            case 7: {
                if (algorithmSuite.contains(BASIC256)) {
                    algorithm = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
                    break;
                }
                if (algorithmSuite.contains(BASIC128)) {
                    algorithm = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
                    break;
                }
                algorithm = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
                break;
            }
            case 8: {
                algorithm = algorithmSuite.contains(BASIC128) ? "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1" : "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
            }
        }
        return algorithm;
    }
}

