/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.dialogs;

import com.ibm.ast.ws.jaxws.emitter.collector.ClientCollector;
import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.jaxws.emitter.collector.MethodOperationInfo;
import com.ibm.ast.ws.jaxws.emitter.collector.PortInfo;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.service.policy.ui.PolicySetUtils;
import com.ibm.ast.ws.was61.policyset.ui.common.ClientEndPointObject;
import com.ibm.ast.ws.was61.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was61.policyset.ui.dialogs.ConfigureEndpointDialog;
import com.ibm.ast.ws.was61.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.was61.policyset.ui.types.WSAddressingPolicy;
import com.ibm.ast.ws.wsi.validation.WSIValidationUtils;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseStatusHandler;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

public class ClientSideConfigureEndpointDialog
extends ConfigureEndpointDialog {
    private String INFOPOP_END_CLIENT_SIDE_DIALOG = "END0007";
    private IProject application;
    private ClientData selectedClientData;
    private ClientData[] clientSet;

    public ClientSideConfigureEndpointDialog(Shell parent, IProject application, ClientData[] clientData) {
        super(parent);
        this.clientSet = clientData;
        this.application = application;
    }

    public ClientSideConfigureEndpointDialog(Shell parent, IProject application, EndPointObject endpointObject, ClientData[] clientData) {
        super(parent, endpointObject);
        this.clientSet = clientData;
        this.application = application;
    }

    protected Control createDialogArea(Composite parent) {
        Control parent1 = super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(parent1, "com.ibm.ast.ws.was61.policyset.ui." + this.INFOPOP_END_CLIENT_SIDE_DIALOG);
        if (!this.isEditMode()) {
            ((Combo)this.serviceName).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ClientSideConfigureEndpointDialog.this.isEditMode()) {
                        return;
                    }
                    ClientSideConfigureEndpointDialog.this.selectedClientData = ClientSideConfigureEndpointDialog.this.clientSet[((Combo)ClientSideConfigureEndpointDialog.this.serviceName).getSelectionIndex()];
                    ((Combo)ClientSideConfigureEndpointDialog.this.portType).setItems(ClientSideConfigureEndpointDialog.this.queryPorts());
                    ClientSideConfigureEndpointDialog.this.replaceBlankWithAll();
                }
            });
            ((Combo)this.portType).addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (ClientSideConfigureEndpointDialog.this.isEditMode()) {
                        return;
                    }
                    if (ClientSideConfigureEndpointDialog.this.selectedClientData != null) {
                        ((Combo)ClientSideConfigureEndpointDialog.this.operation).setItems(ClientSideConfigureEndpointDialog.this.queryOperations(((Combo)ClientSideConfigureEndpointDialog.this.portType).getText().trim()));
                    } else {
                        ((Combo)ClientSideConfigureEndpointDialog.this.operation).removeAll();
                    }
                    ClientSideConfigureEndpointDialog.this.replaceBlankInOpWithAll();
                    ClientSideConfigureEndpointDialog.this.enableControls();
                }
            });
            ((Combo)this.portType).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (ClientSideConfigureEndpointDialog.this.isEditMode()) {
                        return;
                    }
                    if (ClientSideConfigureEndpointDialog.this.selectedClientData != null) {
                        ((Combo)ClientSideConfigureEndpointDialog.this.operation).setItems(ClientSideConfigureEndpointDialog.this.queryOperations(((Combo)ClientSideConfigureEndpointDialog.this.portType).getText().trim()));
                    } else {
                        ((Combo)ClientSideConfigureEndpointDialog.this.operation).removeAll();
                    }
                    ClientSideConfigureEndpointDialog.this.replaceBlankInOpWithAll();
                    ClientSideConfigureEndpointDialog.this.enableControls();
                }
            });
            int selectedClientIndex = 0;
            int i = 0;
            while (i < this.clientSet.length) {
                String service = EndPointObject.getQualifiedServiceName(this.clientSet[i]);
                ((Combo)this.serviceName).add(service);
                if (this.endPointObject != null && service.equals(this.endPointObject.getServiceName())) {
                    selectedClientIndex = i;
                }
                ++i;
            }
            if (((Combo)this.serviceName).getItemCount() > 0) {
                ((Combo)this.serviceName).select(selectedClientIndex);
                this.selectedClientData = this.clientSet[((Combo)this.serviceName).getSelectionIndex()];
                ((Combo)this.portType).setItems(this.queryPorts());
            }
        }
        for (IServicePolicy policySet : this.instances.values()) {
            this.policySetCombo.add(policySet.getDescriptor().getLongName());
        }
        IProject project = null;
        if (this.selectedClientData != null) {
            project = CommonPolicyUtils.getContaingEarProject((IProject)this.selectedClientData.getProject());
        }
        this.policySetCombo.setText(PolicySetUtils.getDefaultPolicySet((IProject)project, (String)"com.ibm.ast.ws.service.policy.ui.policyset.category").getDescriptor().getLongName());
        if (this.application != null) {
            this.bindingCombo.setItems(CommonPolicyUtils.getApplicationBindings((IProject)this.application));
        }
        if (project != null && J2EEUtils.isEARComponent((IProject)project)) {
            this.bindingCombo.add(Activator.getMessage("DEFAULT_BINDING"));
        }
        if (this.endPointObject != null) {
            ((Text)this.portType).setText(this.endPointObject.getEndPoint());
            ((Text)this.operation).setText(this.endPointObject.getOperation());
            this.policySetCombo.setText(this.endPointObject.getAttachedPolicySet().getDescriptor().getLongName());
            if (this.endPointObject.getAttachedBinding() == null) {
                this.bindingCombo.setText(Activator.getMessage("DEFAULT_BINDING"));
            } else {
                this.bindingCombo.setText(this.endPointObject.getAttachedBinding());
            }
        }
        this.policySetCombo.addListener(24, this.getStatusListener());
        this.bindingCombo.addListener(24, this.getStatusListener());
        if (this.isEditMode()) {
            ((Text)this.serviceName).setText(this.endPointObject.getServiceName());
            ((Text)this.portType).setText(this.endPointObject.getEndPoint());
            ((Text)this.operation).setText(this.endPointObject.getOperation());
        }
        this.setTitle(Activator.getMessage("PAGE_DESC_SERVICE_SIDE_POLICY_SET_POUPUP"));
        if (!this.isEditMode()) {
            this.replaceBlankWithAll();
            this.enableControls();
        } else {
            this.policySetCombo.setFocus();
        }
        return parent1;
    }

    private String[] queryOperations(String portName) {
        if (portName.length() == 0) {
            return new String[0];
        }
        Hashtable portsInfo = this.selectedClientData.getPortInfoHash();
        PortInfo port = (PortInfo)portsInfo.get(portName);
        if (port == null) {
            return new String[0];
        }
        Hashtable methodOps = port.getMethodToOperationsMap();
        HashSet<String> opsSet = new HashSet<String>();
        for (String methodSignature : methodOps.keySet()) {
            opsSet.add(((MethodOperationInfo)methodOps.get(methodSignature)).getOperationName());
        }
        return opsSet.toArray(new String[0]);
    }

    private String[] queryPorts() {
        ClientCollector collector = new ClientCollector();
        collector.collectMethodInfo(this.selectedClientData);
        Hashtable portsInfo = this.selectedClientData.getPortInfoHash();
        String[] ports = new String[portsInfo.size()];
        int i = 0;
        for (String port : portsInfo.keySet()) {
            ports[i++] = ((PortInfo)portsInfo.get(port)).getName();
        }
        return ports;
    }

    protected void okPressed() {
        String binding;
        String op;
        String port;
        int severity = WSIValidationUtils.getWSISeverity((String)WSIValidationUtils.getProjectWSICompliance((IProject)this.application, (String)"org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsissbp"));
        if (severity != 1) {
            Vector<Status> statusList = new Vector<Status>();
            List policies = PolicySetUtils.getPolicies((IServicePolicy)((IServicePolicy)this.instances.get(this.policySetCombo.getText())));
            for (IServicePolicy policy : policies) {
                String policyTypeName = policy.getDescriptor().getShortName();
                if (!policyTypeName.equals(WSAddressingPolicy.PolicyTypeName)) continue;
                statusList.add(new Status(severity, "ClientSideConfigureEndpointDialog", 0, Activator.getMessage("ERROR_WSI_BP10_WSADDRESSING"), null));
            }
            Status[] statuses = statusList.toArray(new Status[statusList.size()]);
            if (statuses.length != 0 && !WSIValidationUtils.checkWSICompliance((IStatusHandler)new EclipseStatusHandler(), (Status[])statuses, (IProject)this.application, (int)severity, (String)(severity == 4 ? Activator.getMessage("WSI_BP10_ERROR") : Activator.getMessage("WSI_BP10_WARNING")), (String)"org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsissbp")) {
                return;
            }
        }
        String string = port = this.isEditMode() ? ((Text)this.portType).getText().trim() : ((Combo)this.portType).getText().trim();
        if (port.equals(Activator.getMessage("LABEL_ALL_ENDPOINTS"))) {
            port = "";
        }
        String string2 = op = this.isEditMode() ? ((Text)this.operation).getText().trim() : ((Combo)this.operation).getText().trim();
        if (op.equals(Activator.getMessage("LABEL_ALL_OPERATIONS"))) {
            op = "";
        }
        String string3 = binding = this.bindingCombo.getText().equals(Activator.getMessage("DEFAULT_BINDING")) ? null : this.bindingCombo.getText();
        if (this.endPointObject == null) {
            this.endPointObject = new ClientEndPointObject(((Combo)this.serviceName).getText().trim(), port, op);
            this.endPointObject.attachPolicySetAndBinding(this.application, (IServicePolicy)this.instances.get(this.policySetCombo.getText()), binding);
        } else {
            this.endPointObject.updateEndPointObject(((Text)this.serviceName).getText().trim(), port, op);
            if (!this.endPointObject.getAttachedPolicySet().equals(this.policySetCombo.getText()) || this.endPointObject.getAttachedBinding() == null || !this.endPointObject.getAttachedBinding().equals(binding)) {
                this.endPointObject.attachPolicySetAndBinding(this.application, (IServicePolicy)this.instances.get(this.policySetCombo.getText()), binding);
            }
        }
        super.okPressed();
    }

    protected int getBindingStyle() {
        return 2048;
    }

    protected IStatus getStatus() {
        if (this.bindingCombo.getText().equals("")) {
            return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_BINDING_NAME_MISSING"));
        }
        return super.getStatus();
    }

    protected String getImageFile() {
        return "icons/wizban/clientPolicyAttachment_wiz.gif";
    }
}

