/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.common;

import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.jaxws.emitter.collector.ServiceData;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import java.util.Iterator;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ProjectContainerPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver != null && receiver instanceof ServiceData) {
            ServiceData serviceData = (ServiceData)receiver;
            return ProjectContainerPropertyTester.isSupportedServiceData(serviceData);
        }
        if (receiver != null && receiver instanceof ClientData) {
            ClientData clientData = (ClientData)receiver;
            return ProjectContainerPropertyTester.isSupportedClientData(clientData);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSupportedClientData(ClientData clientData) {
        try {
            String id;
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)clientData.getProject());
            if (facetedProject == null) {
                if (!FacetUtils.isJavaProject((IProject)clientData.getProject())) return false;
                if (!CommonPolicyUtils.checkJavaProjectTargetRuntime((IProject)clientData.getProject(), (String)"WAS_V61FP_WEBSERVICES_THINCLIENT")) return false;
                return true;
            }
            Iterator iterator = facetedProject.getProjectFacets().iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                IProjectFacetVersion pfv = (IProjectFacetVersion)iterator.next();
                id = pfv.getProjectFacet().getId();
                if (!id.equals("com.ibm.websphere.wsfp.web") && !id.equals("com.ibm.websphere.wsfp.appclient") && !id.equals("com.ibm.websphere.wsfp.utility") || !pfv.getVersionString().equals("1.0")) continue;
                return true;
            } while (!id.equals("jst.java") || !CommonPolicyUtils.checkJavaProjectTargetRuntime((IProject)clientData.getProject(), (String)"WAS_V61FP_WEBSERVICES_THINCLIENT"));
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isSupportedServiceData(ServiceData serviceData) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)serviceData.getProject());
            if (facetedProject != null) {
                for (IProjectFacetVersion pfv : facetedProject.getProjectFacets()) {
                    if (!pfv.getProjectFacet().getId().equals("com.ibm.websphere.wsfp.web") || !pfv.getVersionString().equals("1.0")) continue;
                    return J2EEUtils.getReferencingEARComponents((IProject)serviceData.getProject()).length > 0;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }
}

