/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.common;

import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.service.policy.ui.PolicySetUtils;
import com.ibm.ast.ws.was61.policyset.ui.common.ClientEndPointObject;
import com.ibm.ast.ws.was61.policyset.ui.common.EndPointObject;
import com.ibm.ast.ws.was61.policyset.ui.common.ServiceEndPointObject;
import com.ibm.ast.ws.was61.policyset.ui.plugin.Activator;
import com.ibm.ws.ast.st.common.core.internal.config.WASConfigModelCommonHelper;
import com.ibm.ws.ast.st.core.WASRuntimeLocator;
import com.ibm.ws.ast.st.core.internal.runtime.WASRuntimeLocatorDelegate;
import com.ibm.ws.ast.st.v61.core.internal.jmx.WASConfigModelHelper;
import com.ibm.wsspi.profile.registry.Profile;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyUtils {
    private static IPath cellLevelLocation = null;

    public static String expandURL(String url) {
        String newURL = url;
        newURL = url.startsWith("local:") ? url.replaceFirst("local:", PolicySetUtils.getLocalRootPath()) : String.valueOf(PolicyUtils.getCellLevelLocation().toString()) + url;
        return newURL;
    }

    public static String[] getServerSideBindings() {
        return new String[]{Activator.getMessage("DEFAULT_BINDING")};
    }

    public static List<EndPointObject> readClientPolicyAttachments(IProject application, Map<String, IServicePolicy> map) {
        PolicySetAttachment policySet = PolicyUtils.readPolicyAttachments(application, "clientPolicyAttachments.xml");
        if (policySet != null && map != null) {
            return PolicyUtils.getPolicySetAttachments(policySet, application, map);
        }
        return new Vector<EndPointObject>();
    }

    public static List<EndPointObject> readServerPolicyAttachments(IProject application, Map<String, IServicePolicy> map) {
        PolicySetAttachment policySet = PolicyUtils.readPolicyAttachments(application, "policyAttachments.xml");
        if (policySet != null && map != null) {
            return PolicyUtils.getPolicySetAttachments(policySet, null, map);
        }
        return new Vector<EndPointObject>();
    }

    private static PolicySetAttachment readPolicyAttachments(IProject application, String filename) {
        return PolicyUtils.readExistingPolicySetAttachment(CommonPolicyUtils.getOutputFolder((IProject)application, (boolean)true).getLocation().addTrailingSeparator().append(filename));
    }

    public static IPath getCellLevelLocation() {
        if (cellLevelLocation == null) {
            IPath wasInstallPath;
            Path path = null;
            ServerUtil.getModules((String)"");
            IPath stubLocation = WASRuntimeLocator.getRuntimeStubLocation((byte)33);
            if (stubLocation != null) {
                IPath stubProfilePath = WASRuntimeLocatorDelegate.getRuntimeStubProfileLocation((IPath)stubLocation);
                path = new Path(WASConfigModelCommonHelper.getCellLevelLocation((String)stubProfilePath.toString()));
                Object object = cellLevelLocation = path.append("PolicySets").toFile().exists() ? path : null;
            }
            if (cellLevelLocation == null && (wasInstallPath = WASRuntimeLocator.getRuntimeLocation((byte)29)) != null) {
                Profile[] profileArray = WASConfigModelHelper.getProfiles((String)wasInstallPath.toString());
                int n = profileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Profile profile = profileArray[n2];
                    path = new Path(WASConfigModelCommonHelper.getCellLevelLocation((String)profile.getPath().toString()));
                    if (path.append("PolicySets").toFile().exists()) {
                        cellLevelLocation = path;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return cellLevelLocation;
    }

    private static PolicySetAttachment readExistingPolicySetAttachment(IPath fileLocation) {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.xmlns.prod.websphere._200605.policysetattachment");
            Unmarshaller u = jc.createUnmarshaller();
            return (PolicySetAttachment)u.unmarshal((InputStream)new FileInputStream(fileLocation.toFile()));
        }
        catch (JAXBException exc) {
            exc.printStackTrace();
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private static List<EndPointObject> getPolicySetAttachments(PolicySetAttachment policySetAttachment, IProject application, Map<String, IServicePolicy> map) {
        Vector<EndPointObject> attachments = new Vector<EndPointObject>();
        for (PolicySetReference reference : policySetAttachment.getPolicySetReference()) {
            String policySetName = reference.getName();
            IServicePolicy policySet = map.get(policySetName);
            if (policySet == null) continue;
            String binding = reference.getPolicySetBinding() == null ? null : reference.getPolicySetBinding().getName();
            for (Resource resource : reference.getResource()) {
                EndPointObject endPointReference = application == null ? new ServiceEndPointObject(resource.getPattern()) : new ClientEndPointObject(resource.getPattern());
                endPointReference.attachPolicySetAndBinding(application, policySet, binding);
                attachments.add(endPointReference);
            }
        }
        return attachments;
    }

    public static Object readExistingBindingConfiguration(IPath bindingLocation, String policyType, String context) throws Exception {
        if (bindingLocation == null) {
            return null;
        }
        IPath path = bindingLocation.append("PolicyTypes").append(policyType).append("bindings.xml");
        if (path.toFile().exists()) {
            JAXBContext jc = JAXBContext.newInstance((String)context);
            Unmarshaller u = jc.createUnmarshaller();
            return u.unmarshal((InputStream)new FileInputStream(path.toFile()));
        }
        return null;
    }
}

