/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.was61.policyset.ui.common;

import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.jaxws.emitter.collector.ServiceData;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import com.ibm.ast.ws.service.policy.ui.PolicySetUtils;
import com.ibm.ast.ws.was61.policyset.ui.types.PolicyType;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.ws.service.policy.IServicePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EndPointObject {
    protected String displayName;
    private IServicePolicy policySetAttached;
    private String bindingAttached;
    protected String serviceName = "";
    protected String endPoint = "";
    protected String operation = "";
    private Map<String, PolicyType> bindingConfigObjects;
    protected String nameSpace;
    protected String moduleName = null;
    private static final String SERVICE_ENDPOINT = "WebService:/";
    protected static final String STRING_SEPERATOR = "/";
    protected static final char CHAR_SEPERATOR = '/';
    protected static final String OPEN_BRAKET = "{";
    protected static final String CLOSE_BRAKET = "}";
    protected static final String COLON = ":";

    public EndPointObject(String serviceName, String endPoint, String operation) {
        this.serviceName = serviceName;
        this.endPoint = endPoint;
        this.operation = operation;
        this.displayName = this.findDisplayName();
    }

    public EndPointObject(String name) {
        this.displayName = name;
        if (this.displayName.startsWith(SERVICE_ENDPOINT)) {
            this.displayName = this.displayName.substring(SERVICE_ENDPOINT.length());
        }
        this.findServiceEndPointOperation();
    }

    public void updateEndPointObject(String serviceName, String endPoint, String operation) {
        this.serviceName = serviceName;
        this.endPoint = endPoint;
        this.operation = operation;
        this.displayName = this.findDisplayName();
    }

    public String getPattern() {
        return SERVICE_ENDPOINT + this.displayName;
    }

    protected abstract void findServiceEndPointOperation();

    protected String findDisplayName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.serviceName);
        if (this.endPoint == null || this.endPoint.length() == 0) {
            return buffer.toString();
        }
        buffer.append(STRING_SEPERATOR + this.endPoint);
        if (this.operation == null || this.operation.length() == 0) {
            return buffer.toString();
        }
        buffer.append(STRING_SEPERATOR + this.operation);
        return buffer.toString();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAttachedBinding() {
        return this.bindingAttached;
    }

    public IServicePolicy getAttachedPolicySet() {
        return this.policySetAttached;
    }

    public void attachPolicySetAndBinding(IProject root, IServicePolicy policySet, String binding) {
        this.policySetAttached = policySet;
        this.bindingAttached = binding;
        if (root != null) {
            try {
                this.bindingConfigObjects = new Hashtable<String, PolicyType>();
                if (binding != null) {
                    IFolder bindingFolder = root == null ? null : CommonPolicyUtils.createIFolder((IContainer)CommonPolicyUtils.getOutputFolder((IProject)root, (boolean)true), (String)binding);
                    List policies = PolicySetUtils.getPolicies((IServicePolicy)policySet);
                    for (IServicePolicy policy : policies) {
                        String policyTypeName = policy.getDescriptor().getShortName();
                        PolicyType type = PolicyType.getType(policyTypeName);
                        type.setServicePolicy(policy);
                        type.readBindingConfiguration(bindingFolder.getLocation());
                        this.bindingConfigObjects.put(policyTypeName, type);
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getQualifiedServiceName() {
        StringBuffer buffer = new StringBuffer();
        if (this.nameSpace != null && this.nameSpace.length() > 0) {
            buffer.append(OPEN_BRAKET).append(this.nameSpace).append(CLOSE_BRAKET);
        }
        buffer.append(this.serviceName);
        return buffer.toString();
    }

    public static String getQualifiedServiceName(ServiceData service, IProject earProject) {
        IProject module = service.getProject();
        String moduleName = module.getName();
        EARArtifactEdit earArtifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earProject);
        String uri = earArtifactEdit.getModuleURI(J2EEProjectUtilities.getModule((IVirtualComponent)earArtifactEdit.getComponent(), (String)moduleName));
        return EndPointObject.getQualifiedServiceName(uri, service.getTargetNamespace(), service.getServiceName());
    }

    public static String getQualifiedServiceName(ClientData client) {
        return EndPointObject.getQualifiedServiceName(null, client.getTargetNamespace(), client.getName());
    }

    public static String getQualifiedServiceName(String moduleName, String nameSpace, String serviceName) {
        StringBuffer buffer = new StringBuffer();
        if (moduleName != null && moduleName.length() > 0) {
            buffer.append(moduleName).append(COLON);
        }
        if (nameSpace != null && nameSpace.length() > 0) {
            buffer.append(OPEN_BRAKET).append(nameSpace).append(CLOSE_BRAKET);
        }
        buffer.append(serviceName);
        return buffer.toString();
    }

    public Map<String, PolicyType> getBindingConfigObjects() {
        return this.bindingConfigObjects;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }
}

