/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.wsi.validation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.Choice;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.ws.internal.WstWSPluginMessages;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;

public class WSIValidationUtils {
    public static final String STOP_NON_WSI = "0";
    public static final String WARN_NON_WSI = "1";
    public static final String IGNORE_NON_WSI = "2";
    public static final String FOLLOW_WSI_PREFERENCE = "3";
    public static final String WSI_BP10_SERVICE_POLICY_ID = "org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsissbp";
    public static final String WSI_BP12_SERVICE_POLICY_ID = "org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsibp12";
    public static final String WSI_BP20_SERVICE_POLICY_ID = "org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsibp20";
    private static final String[] ENUM_ID_VALUES = new String[]{"org.eclipse.wst.sug.require", "org.eclipse.wst.sug.suggest", "org.eclipse.wst.sug.ignore"};
    private static final String[] CONTEXT_IDS = new String[]{"0", "1", "2"};

    public static String getProjectWSICompliance(IProject project, String servicePolicyId) {
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        IServicePolicy servicePolicy = platform.getServicePolicy(servicePolicyId);
        String currentStateID = project == null ? servicePolicy.getPolicyStateEnum().getCurrentItem().getId() : servicePolicy.getPolicyStateEnum(project).getCurrentItem().getId();
        String property = FOLLOW_WSI_PREFERENCE;
        int index = 0;
        while (index < ENUM_ID_VALUES.length) {
            if (ENUM_ID_VALUES[index].equals(currentStateID)) {
                property = CONTEXT_IDS[index];
                break;
            }
            ++index;
        }
        return property;
    }

    public static int getWSISeverity(String property) {
        if (STOP_NON_WSI.equals(property)) {
            return 4;
        }
        if (WARN_NON_WSI.equals(property)) {
            return 2;
        }
        return 1;
    }

    public static boolean checkWSICompliance(IStatusHandler monitor, Status[] status, IProject project, int severity, String message, String servicePolicyId) {
        if (severity == 4) {
            MultiStatus status_ = StatusUtils.multiStatus((String)message, (IStatus[])status);
            monitor.reportError((IStatus)status_);
            return false;
        }
        if (severity == 2) {
            Choice cancelChoice;
            Choice ignoreAllChoice;
            Choice ignoreChoice;
            MultiStatus status_ = StatusUtils.multiStatus((String)message, (IStatus[])status);
            Choice result = monitor.report((IStatus)status_, new Choice[]{ignoreChoice = new Choice('I', WstWSPluginMessages.IGNORE_LABEL, WstWSPluginMessages.IGNORE_DESCRIPTION), ignoreAllChoice = new Choice('A', WstWSPluginMessages.IGNORE_ALL_LABEL, WstWSPluginMessages.IGNORE_ALL_DESCRIPTION), cancelChoice = new Choice('C', WstWSPluginMessages.CANCEL_LABEL, WstWSPluginMessages.CANCEL_DESCRIPTION)});
            if (result == null || result.getLabel().equals(ignoreChoice.getLabel())) {
                return true;
            }
            if (result.getLabel().equals(ignoreAllChoice.getLabel())) {
                ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
                IServicePolicy servicePolicy = platform.getServicePolicy(servicePolicyId);
                if (project != null && platform.isProjectPreferencesEnabled(project)) {
                    servicePolicy.getPolicyState(project).putValue("default.value.key", "org.eclipse.wst.sug.ignore");
                    platform.commitChanges(project);
                } else {
                    servicePolicy.getPolicyState().putValue("default.value.key", "org.eclipse.wst.sug.ignore");
                    platform.commitChanges();
                }
                return true;
            }
            if (result.getLabel().equals(cancelChoice.getLabel())) {
                return false;
            }
        }
        return true;
    }
}

