/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.ui.preferences;

import com.ibm.ast.ws.ui.internal.context.PersistentWASSecurityContext;
import com.ibm.ast.ws.ui.plugin.WSUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.ws.internal.context.UDDIPreferenceContext;
import org.eclipse.jst.ws.internal.context.UDDIPreferenceDefaults;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WasWsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String INFOPOP_PPWS_PAGE = "com.ibm.ast.ws.ui.PPWS0001";
    private Button showFIPSComplientAlgorithms;
    private final String INFOPOP_PPWS_SHOW_ONLY_FIPS = "com.ibm.ast.ws.ui.PPWE0002";
    private Button showPasswordAsStars;
    private final String INFOPOP_PPWS_SHOW_PASSWORD_AS_STARS = "com.ibm.ast.ws.ui.PPWE0003";
    private final String INFOPOP_PPWE_PAGE = "com.ibm.ast.ws.ui.PPWE0001";
    private Text uddiCatDataColumnDelimText;
    private final String INFOPOP_PPWE_UDDI_CAT_DATA_COLUMN_DELIM = "com.ibm.ast.ws.ui.PPWE0005";
    private Text uddiCatDataStringDelimText;
    private final String INFOPOP_PPWE_UDDI_CAT_DATA_STRING_DELIM = "com.ibm.ast.ws.ui.PPWE0006";

    protected Control createContents(Composite superParent) {
        UIUtils uiUtils = WSUIPlugin.getUiUtils();
        Composite parent = uiUtils.createComposite(superParent, 1);
        Group securityGroup = uiUtils.createGroup(parent, this.getMessage("PREFERENCE_GROUP_WAS_SECURITY"), this.getMessage("TOOLTIP_PPWS_PAGE"), "com.ibm.ast.ws.ui.PPWS0001");
        this.showFIPSComplientAlgorithms = uiUtils.createCheckbox((Composite)securityGroup, this.getMessage("BUTTON_SHOW_FIPS"), this.getMessage("TOOLTIP_PPWS_CHECKBOX_SHOW_FIPS"), "com.ibm.ast.ws.ui.PPWE0002");
        this.showPasswordAsStars = uiUtils.createCheckbox((Composite)securityGroup, this.getMessage("BUTTON_SHOW_STAR_PASSWORD"), this.getMessage("TOOLTIP_PPWS_CHECKBOX_STAR_PASS"), "com.ibm.ast.ws.ui.PPWE0003");
        new Label(parent, 256);
        Group uddiGroup = uiUtils.createGroup(parent, this.getMessage("PREFERENCE_CATEGORY_PRIVATE_UDDI_REGISTRY"), this.getMessage("TOOLTIP_PPWE_PAGE"), "com.ibm.ast.ws.ui.PPWE0001");
        Composite uddiComposite = uiUtils.createComposite((Composite)uddiGroup, 2);
        this.uddiCatDataColumnDelimText = uiUtils.createText(uddiComposite, this.getMessage("LABEL_UDDI_CAT_DATA_COLUMN_DELIM"), this.getMessage("TOOLTIP_PPWE_UDDI_CAT_DATA_COLUMN_DELIM"), "com.ibm.ast.ws.ui.PPWE0005", 2048);
        this.uddiCatDataColumnDelimText.setTextLimit(1);
        GridData grData = new GridData(4);
        grData.widthHint = this.convertWidthInCharsToPixels(2);
        this.uddiCatDataColumnDelimText.setLayoutData((Object)grData);
        this.uddiCatDataStringDelimText = uiUtils.createText(uddiComposite, this.getMessage("LABEL_UDDI_CAT_DATA_STRING_DELIM"), this.getMessage("TOOLTIP_PPWE_UDDI_CAT_DATA_STRING_DELIM"), "com.ibm.ast.ws.ui.PPWE0006", 2048);
        this.uddiCatDataStringDelimText.setTextLimit(1);
        this.uddiCatDataStringDelimText.setLayoutData((Object)grData);
        this.initializeValues();
        Dialog.applyDialogFont((Control)superParent);
        return parent;
    }

    public void init(IWorkbench desktop) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    private void initializeDefaults() {
        this.showFIPSComplientAlgorithms.setSelection(false);
        this.showPasswordAsStars.setSelection(true);
        this.uddiCatDataColumnDelimText.setText(UDDIPreferenceDefaults.getUddiCatDataColumnDelimiter());
        this.uddiCatDataStringDelimText.setText(UDDIPreferenceDefaults.getUddiCatDataStringDelimiter());
    }

    private void initializeValues() {
        String stringDelimiter;
        PersistentWASSecurityContext context = WSUIPlugin.getInstance().getWASSecurityContext();
        this.showFIPSComplientAlgorithms.setSelection(context.isFIPSComplient());
        this.showPasswordAsStars.setSelection(context.isStarPassword());
        UDDIPreferenceContext uddiContext = WebServicePlugin.getInstance().getUDDIPreferenceContext();
        String columnDelimiter = uddiContext.getUddiCatDataColumnDelimiter();
        if (columnDelimiter == null || columnDelimiter.length() <= 0) {
            columnDelimiter = UDDIPreferenceDefaults.getUddiCatDataColumnDelimiter();
        }
        if ((stringDelimiter = uddiContext.getUddiCatDataStringDelimiter()) == null || stringDelimiter.length() <= 0) {
            stringDelimiter = UDDIPreferenceDefaults.getUddiCatDataStringDelimiter();
        }
        this.uddiCatDataColumnDelimText.setText(columnDelimiter);
        this.uddiCatDataStringDelimText.setText(stringDelimiter);
    }

    private void storeValues() {
        PersistentWASSecurityContext context = WSUIPlugin.getInstance().getWASSecurityContext();
        context.setFIPSComplient(this.showFIPSComplientAlgorithms.getSelection());
        context.setStarPassword(this.showPasswordAsStars.getSelection());
        UDDIPreferenceContext uddiContext = WebServicePlugin.getInstance().getUDDIPreferenceContext();
        uddiContext.setUddiCatDataColumnDelimiter(this.uddiCatDataColumnDelimText.getText());
        uddiContext.setUddiCatDataStringDelimiter(this.uddiCatDataStringDelimText.getText());
    }

    private String getMessage(String key) {
        return WSUIPlugin.getMessage(key);
    }
}

