/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.ui.preferences;

import com.ibm.ast.ws.ui.internal.context.PersistentWASSecurityContext;
import com.ibm.ast.ws.ui.plugin.WSUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class WASSecurityPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String INFOPOP_PPWS_PAGE = "com.ibm.ast.ws.ui.PPWS0001";
    private Button showFIPSComplientAlgorithms;
    private Button showPasswordAsStars;
    private final String INFOPOP_PPWS_SHOW_ONLY_FIPS = "com.ibm.ast.ws.ui.PPWE0002";
    private final String INFOPOP_PPWS_SHOW_PASSWORD_AS_STARS = "com.ibm.ast.ws.ui.PPWE0003";

    protected Control createContents(Composite superparent) {
        Composite parent = new Composite(superparent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginHeight = 5;
        gl.marginWidth = 5;
        parent.setLayout((Layout)gl);
        parent.setToolTipText(this.getMessage("TOOLTIP_PPWS_PAGE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.ast.ws.ui.PPWS0001");
        parent.setLayoutData((Object)new GridData(768));
        this.showFIPSComplientAlgorithms = this.createCheckBox(parent, this.getMessage("BUTTON_SHOW_FIPS"), this.getMessage("TOOLTIP_PPWS_CHECKBOX_SHOW_FIPS"), "com.ibm.ast.ws.ui.PPWE0002");
        this.showPasswordAsStars = this.createCheckBox(parent, this.getMessage("BUTTON_SHOW_STAR_PASSWORD"), this.getMessage("TOOLTIP_PPWS_CHECKBOX_STAR_PASS"), "com.ibm.ast.ws.ui.PPWE0003");
        this.initializeValues();
        Dialog.applyDialogFont((Control)superparent);
        return parent;
    }

    private final Button createCheckBox(Composite parent, String label, String toolTipText, String infoPopKey) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setToolTipText(toolTipText);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)button, infoPopKey);
        return button;
    }

    private String getMessage(String key) {
        return WSUIPlugin.getMessage(key);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        this.showFIPSComplientAlgorithms.setSelection(false);
        this.showPasswordAsStars.setSelection(true);
    }

    private void initializeValues() {
        PersistentWASSecurityContext context = WSUIPlugin.getInstance().getWASSecurityContext();
        this.showFIPSComplientAlgorithms.setSelection(context.isFIPSComplient());
        this.showPasswordAsStars.setSelection(context.isStarPassword());
    }

    private void storeValues() {
        PersistentWASSecurityContext context = WSUIPlugin.getInstance().getWASSecurityContext();
        context.setFIPSComplient(this.showFIPSComplientAlgorithms.getSelection());
        context.setStarPassword(this.showPasswordAsStars.getSelection());
    }
}

