/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.ui.endptenabler.command;

import com.ibm.ccl.ws.finder.core.WSInfo;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateHttpRouterCommand
extends AbstractDataModelOperation {
    private static final String JAX_RPC_SERVLET_CLASS_NAME = "com.ibm.ws.webservices.engine.transport.http.WebServicesServlet";
    private static final String JAX_WS_SERVLET_CLASS_NAME = "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet";
    private static final String SERVLET_URL_PATTERN_ROOT = "services";
    private List<WSInfo> jaxwsWsInfosInProject;
    private List<WSInfo> jaxrpcWsInfosInProject;
    private IProject httpRouterProject;
    private String httpRouterProjectName;
    private boolean httpBinding = false;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adpatable) {
        if (!this.httpBinding) {
            return Status.OK_STATUS;
        }
        this.httpRouterProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.httpRouterProjectName);
        WebArtifactEdit webArtifactEdit = null;
        try {
            try {
                webArtifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)this.httpRouterProject);
                WebApp webapp = (WebApp)webArtifactEdit.getDeploymentDescriptorRoot();
                if (webapp == null) {
                    webapp = (WebApp)webArtifactEdit.createModelRoot(25);
                }
                this.createJAXRPCServlets(monitor, webapp);
                this.createJAXWSServlets(monitor, webapp);
                webArtifactEdit.saveIfNecessary(monitor);
            }
            catch (Exception exception) {
                if (webArtifactEdit != null) {
                    webArtifactEdit.dispose();
                }
            }
        }
        finally {
            if (webArtifactEdit != null) {
                webArtifactEdit.dispose();
            }
        }
        return Status.OK_STATUS;
    }

    private void createJAXRPCServlets(IProgressMonitor monitor, WebApp webapp) {
        EList servlets = webapp.getServlets();
        EList servletMappings = webapp.getServletMappings();
        for (WSInfo jaxrpcWsInfo : this.jaxrpcWsInfosInProject) {
            String portComponentName = this.getPortComponentFromJaxrpcWSInfo(monitor, jaxrpcWsInfo);
            String urlPattern = "services/" + portComponentName;
            this.createServlet(webapp, (List<Servlet>)servlets, (List<ServletMapping>)servletMappings, portComponentName, urlPattern, JAX_RPC_SERVLET_CLASS_NAME);
        }
    }

    private String getPortComponentFromJaxrpcWSInfo(IProgressMonitor monitor, WSInfo wsInfo) {
        wsInfo.getContent(monitor);
        return wsInfo.getProperty("_ws_ports_");
    }

    private void createJAXWSServlets(IProgressMonitor monitor, WebApp webapp) {
        EList servlets = webapp.getServlets();
        EList servletMappings = webapp.getServletMappings();
        for (WSInfo jaxwsWsInfo : this.jaxwsWsInfosInProject) {
            String urlPattern = this.getURLPatternFromJaxwsWSInfo(monitor, jaxwsWsInfo);
            String implName = this.getImplNameFromJaxwsWSInfo(monitor, jaxwsWsInfo);
            this.createServlet(webapp, (List<Servlet>)servlets, (List<ServletMapping>)servletMappings, implName, urlPattern, JAX_WS_SERVLET_CLASS_NAME);
        }
    }

    private String getURLPatternFromJaxwsWSInfo(IProgressMonitor monitor, WSInfo wsInfo) {
        wsInfo.getContent(monitor);
        StringBuffer sb = new StringBuffer("/");
        sb.append(wsInfo.getProperty("_service_name_"));
        return sb.toString();
    }

    private String getImplNameFromJaxwsWSInfo(IProgressMonitor monitor, WSInfo wsInfo) {
        wsInfo.getContent(monitor);
        return wsInfo.getProperty("_fq_class_name_");
    }

    private void createServlet(WebApp webapp, List<Servlet> servlets, List<ServletMapping> servletMappings, String servletName, String urlPattern, String servletClass) {
        WebapplicationFactory webFactory = WebapplicationFactory.eINSTANCE;
        Servlet servletToAdd = null;
        ServletMapping mappingToAdd = null;
        for (Servlet existingServlet : servlets) {
            if (!existingServlet.getServletName().equals(servletName)) continue;
            servletToAdd = existingServlet;
        }
        if (servletToAdd == null) {
            servletToAdd = webFactory.createServlet();
            servlets.add(servletToAdd);
        }
        servletToAdd.setWebApp(webapp);
        servletToAdd.setServletName(servletName);
        ServletType servletType = webFactory.createServletType();
        servletType.setClassName(servletClass);
        servletToAdd.setWebType((WebType)servletType);
        for (ServletMapping existingMapping : servletMappings) {
            if (existingMapping.getServlet() == null || !existingMapping.getServlet().getServletName().equals(servletName)) continue;
            mappingToAdd = existingMapping;
        }
        if (mappingToAdd == null) {
            mappingToAdd = webFactory.createServletMapping();
            servletMappings.add(mappingToAdd);
        }
        mappingToAdd.setServlet(servletToAdd);
        mappingToAdd.setUrlPattern(urlPattern);
    }

    public void setHttpRouterProject(IProject httpRouterProject) {
        this.httpRouterProject = httpRouterProject;
    }

    public void setHttpBinding(boolean httpBinding) {
        this.httpBinding = httpBinding;
    }

    public void setJaxwsWsInfosInProject(List<WSInfo> jaxwsWsInfosInProject) {
        this.jaxwsWsInfosInProject = jaxwsWsInfosInProject;
    }

    public void setJaxrpcWsInfosInProject(List<WSInfo> jaxrpcWsInfosInProject) {
        this.jaxrpcWsInfosInProject = jaxrpcWsInfosInProject;
    }

    public void setHttpRouterProjectName(String httpRouterProjectName) {
        this.httpRouterProjectName = httpRouterProjectName;
    }
}

