/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.ui.endptenabler.command;

import com.ibm.ast.ws.ui.endptenabler.command.SearchWebServiceInProjectCommand;
import com.ibm.ccl.ws.finder.core.WSInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchWebServiceInEarCommand
extends AbstractDataModelOperation {
    private IProject project;
    private List<IProject> webServiceEnabledEJBProjects = new ArrayList<IProject>();
    private HashMap<String, List<WSInfo>> jaxrpcWSInfosByProject = new HashMap();
    private HashMap<String, List<WSInfo>> jaxwsWSInfosByProject = new HashMap();
    private int numOfJaxwsWS = 0;
    private int numOfJaxrpcWS = 0;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        this.numOfJaxwsWS = 0;
        this.numOfJaxrpcWS = 0;
        this.webServiceEnabledEJBProjects.clear();
        List<IProject> ejbProjects = this.getAvailableJmsRouterComponents(this.project);
        for (IProject ejbProject : ejbProjects) {
            SearchWebServiceInProjectCommand searchWSCmd = new SearchWebServiceInProjectCommand();
            searchWSCmd.setEnvironment(super.getEnvironment());
            searchWSCmd.setProject(ejbProject);
            searchWSCmd.execute(monitor, adaptable);
            List<WSInfo> jaxrpcWSInfos = searchWSCmd.getJaxrpcWsInfosInProject();
            List<WSInfo> jaxwsWSInfos = searchWSCmd.getJaxwsWsInfosInProject();
            this.numOfJaxrpcWS += jaxrpcWSInfos.size();
            this.numOfJaxwsWS += jaxwsWSInfos.size();
            if (jaxrpcWSInfos.size() == 0 && jaxwsWSInfos.size() == 0) continue;
            this.webServiceEnabledEJBProjects.add(ejbProject);
            this.jaxrpcWSInfosByProject.put(ejbProject.getName(), jaxrpcWSInfos);
            this.jaxwsWSInfosByProject.put(ejbProject.getName(), jaxwsWSInfos);
        }
        return Status.OK_STATUS;
    }

    private List<IProject> getAvailableJmsRouterComponents(IProject earProject) {
        EARArtifactEdit artifactEdit = null;
        ArrayList<IProject> compList = null;
        try {
            try {
                artifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earProject);
                IVirtualReference[] refList = artifactEdit.getJ2EEModuleReferences();
                compList = new ArrayList<IProject>(refList.length);
                int i = 0;
                while (i < refList.length) {
                    IVirtualComponent referencedComponent = refList[i].getReferencedComponent();
                    IProject tmpProject = referencedComponent.getProject();
                    if (J2EEProjectUtilities.isEJBProject((IProject)tmpProject)) {
                        compList.add(tmpProject);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                Vector<IProject> vector = new Vector<IProject>();
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
                return vector;
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return compList;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public HashMap<String, List<WSInfo>> getJaxrpcWSInfosByProject() {
        return this.jaxrpcWSInfosByProject;
    }

    public HashMap<String, List<WSInfo>> getJaxwsWSInfosByProject() {
        return this.jaxwsWSInfosByProject;
    }

    public int getNumOfJaxwsWS() {
        return this.numOfJaxwsWS;
    }

    public int getNumOfJaxrpcWS() {
        return this.numOfJaxrpcWS;
    }

    public boolean webServiceExist() {
        return this.numOfJaxrpcWS > 0 || this.numOfJaxwsWS > 0;
    }

    public List<IProject> getWebServiceEnabledEJBProjects() {
        return this.webServiceEnabledEJBProjects;
    }
}

