/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.refactor;

import com.ibm.ast.ws.ui.messages.Messages;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class RemoveRouterReferenceChange
extends Change {
    private String routerUri_;
    private IVirtualComponent ejbComponent_;

    public RemoveRouterReferenceChange(String routerUri, IVirtualComponent ejbComponent) {
        this.routerUri_ = routerUri;
        this.ejbComponent_ = ejbComponent;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return NLS.bind((String)Messages.LABEL_WS_ROUTER_DELETION_REFACTORING_CHANGE, (Object)this.routerUri_, (Object)this.ejbComponent_.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        WsbndArtifactEdit edit = null;
        try {
            IProject ejbProject;
            if (this.ejbComponent_ != null && (ejbProject = this.ejbComponent_.getProject()) != null && ejbProject.exists()) {
                EList routerModules;
                edit = WsbndArtifactEdit.getWSBNDArtifactEditForWrite((IVirtualComponent)this.ejbComponent_);
                WSBinding wsBinding = edit.getWSBinding();
                if (wsBinding != null && (routerModules = wsBinding.getRouterModules()) != null) {
                    int i = 0;
                    while (i < routerModules.size()) {
                        RouterModule rm = (RouterModule)routerModules.get(i);
                        if (this.routerUri_.equals(rm.getName())) {
                            routerModules.remove(i);
                            --i;
                        }
                        ++i;
                    }
                }
                edit.saveIfNecessary(pm);
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
        return null;
    }
}

