/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.ext.validator;

import com.ibm.ast.ws.ext.validator.BSPComplianceUtils;
import com.ibm.ast.ws.ext.validator.WsExtBadAttribute;
import com.ibm.ast.ws.ext.validator.WsExtBadElement;
import com.ibm.ast.ws.ext.validator.WsExtParser;
import com.ibm.ast.ws.ext.validator.WsExtValidatorHelper;
import com.ibm.ast.ws.ui.internal.context.PersistentWSIBSPContext;
import com.ibm.ast.ws.ui.plugin.WSUIPlugin;
import com.ibm.etools.webservice.WebServiceWASInit;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WscbndArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WscextArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WsextArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.SecurityRequestConsumerBindingConfig;
import com.ibm.etools.webservice.wsbnd.SecurityResponseGeneratorBindingConfig;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityResponseConsumerBindingConfig;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscext.ClientServiceConfig;
import com.ibm.etools.webservice.wscext.ComponentScopedRefs;
import com.ibm.etools.webservice.wscext.SecurityRequestGeneratorServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityResponseConsumerServiceConfig;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.Transform;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.MessageParts;
import com.ibm.etools.webservice.wscommonext.Nonce;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.etools.webservice.wscommonext.Timestamp;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.SecurityRequestConsumerServiceConfig;
import com.ibm.etools.webservice.wsext.SecurityResponseGeneratorServiceConfig;
import com.ibm.etools.webservice.wsext.ServerServiceConfig;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.etools.webservice.wsext.WsExtension;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSCDDArtifactEdit;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.internal.WebServiceInit;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.eclipse.wst.ws.internal.preferences.PersistentWSIContext;
import org.eclipse.wst.ws.internal.preferences.WSIComplianceUtils;

public class WsExtValidator
implements IValidatorJob {
    private final String SCOPE_SESSION = "Session";
    private final String SCOPE_REQUEST = "Request";
    private final String SCOPE_APPLICATION = "Application";
    private final String ELEM_NAME_ROUTER_MODULES = "routerModules";
    private final String ELEM_NAME_WS_DESC_BINDINGS = "wsdescBindings";
    private final String ELEM_NAME_PC_BINDINGS = "pcBindings";
    private final String ELEM_NAME_SERVICE_REFS = "serviceRefs";
    private final String ELEM_NAME_COMPONENT_SCOPED_REFS = "componentScopedRefs";
    private final String ELEM_NAME_DATA_ENCRYPTION_METHOD = "encryptionMethod";
    private final String ELEM_NAME_KEY_ENCRYPTION_METHOD = "keyEncryptionMethod";
    private final String ELEM_NAME_SIGNATURE_METHOD = "signatureMethod";
    private final String ELEM_NAME_TRANSFORM = "transform";
    private final String ELEM_NAME_KEY_INFO = "keyInfo";
    private final String ELEM_NAME_MESSAGE_PARTS = "messageParts";
    private final String ELEM_NAME_NONCE = "nonce";
    private final String ELEM_NAME_TIMESTAMP = "timestamp";
    private final String ATTR_NAME = "name";
    private final String ATTR_TYPE = "type";
    private final String ATTR_ALGORITHM = "algorithm";
    private final String ATTR_KEYWORD = "keyword";
    private final String ATTR_WS_DESC_NAME_LINK = "wsDescNameLink";
    private final String ATTR_PC_NAME_LINK = "pcNameLink";
    private final String ATTR_SCOPE = "scope";
    private final String ATTR_DEPLOYED_WSDL_FILE = "deployedWSDLFile";
    private final String ATTR_SERVICE_REF_LINK = "serviceRefLink";
    private final String ATTR_COMPONENT_NAME_LINK = "componentNameLink";
    private final String BUNDLE_ID = "com.ibm.ast.ws.ext.validator.validator";
    private ISchedulingRule emptyRule_ = new EmptyRule();

    public void cleanup(IReporter reporter) {
    }

    private IVirtualFolder getDeploymentDescriptorFolder(IVirtualComponent component, String deploymentDescriptorFileName) throws CoreException {
        IVirtualResource[] resources = component.getRootFolder().members();
        if (resources != null && resources.length > 0) {
            int i = 0;
            while (i < resources.length) {
                IVirtualFolder folder;
                IVirtualResource ddResource;
                IVirtualResource resource = resources[i];
                if (resource.getType() == 32 && (ddResource = (folder = (IVirtualFolder)resource).findMember(deploymentDescriptorFileName)) != null) {
                    return folder;
                }
                ++i;
            }
        }
        return null;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return this.emptyRule_;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validate(helper, reporter);
        return Status.OK_STATUS;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        WsExtValidatorHelper wsExtValidatorHelper = (WsExtValidatorHelper)helper;
        String[] uris = wsExtValidatorHelper.getURIs();
        if (uris == null || uris.length == 0) {
            ArrayList urisList = new ArrayList();
            IProject project = wsExtValidatorHelper.getProject();
            if (J2EEProjectUtilities.isEARProject((IProject)project)) {
                this.gatherExtendedDescriptorsFromEAR(urisList, project);
            } else {
                this.gatherWebServiceExtendedDescriptors(urisList, project);
                this.gatherWebServiceClientExtendedDescriptors(urisList, project);
            }
            uris = new String[urisList.size()];
            urisList.toArray(uris);
        }
        this.validateUsingUris(uris, reporter);
    }

    private final void validateUsingUris(String[] uris, IReporter reporter) {
        int i = 0;
        while (i < uris.length) {
            String[] wsExtDDUris;
            ArrayList wsExtDDUriList;
            IFile uriFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uris[i]));
            IProject project = uriFile.getProject();
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (uris[i].endsWith("application.xml")) {
                wsExtDDUriList = new ArrayList();
                this.gatherExtendedDescriptorsFromEAR(wsExtDDUriList, project);
                wsExtDDUris = new String[wsExtDDUriList.size()];
                wsExtDDUriList.toArray(wsExtDDUris);
                this.validateUsingUris(wsExtDDUris, reporter);
            }
            if (uris[i].endsWith("application-client.xml") || uris[i].endsWith("web.xml") || uris[i].endsWith("ejb-jar.xml") || uris[i].endsWith("webservicesclient.xml")) {
                wsExtDDUriList = new ArrayList();
                this.gatherWebServiceClientExtendedDescriptors(wsExtDDUriList, project);
                wsExtDDUris = new String[wsExtDDUriList.size()];
                wsExtDDUriList.toArray(wsExtDDUris);
                this.validateUsingUris(wsExtDDUris, reporter);
            }
            if (uris[i].endsWith("web.xml") || uris[i].endsWith("ejb-jar.xml") || uris[i].endsWith("webservices.xml")) {
                wsExtDDUriList = new ArrayList();
                this.gatherWebServiceExtendedDescriptors(wsExtDDUriList, project);
                wsExtDDUris = new String[wsExtDDUriList.size()];
                wsExtDDUriList.toArray(wsExtDDUris);
                this.validateUsingUris(wsExtDDUris, reporter);
            }
            if (uris[i].endsWith("ibm-webservices-bnd.xmi")) {
                this.validateIbmWebServicesBndXmi(uriFile, component, reporter);
            } else if (uris[i].endsWith("ibm-webservicesclient-bnd.xmi")) {
                this.validateIbmWebServicesClientBndXmi(uriFile, component, reporter);
            } else if (uris[i].endsWith("ibm-webservices-ext.xmi")) {
                this.validateIbmWebServicesExtXmi(uriFile, component, reporter);
            } else if (uris[i].endsWith("ibm-webservicesclient-ext.xmi")) {
                this.validateIbmWebServicesClientExtXmi(uriFile, component, reporter);
            }
            ++i;
        }
    }

    private final void gatherExtendedDescriptorsFromEAR(ArrayList urisList, IProject earProject) {
        EARArtifactEdit earEdit = null;
        try {
            earEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earProject);
            IVirtualReference[] referencedComponents = J2EEProjectUtilities.getComponentReferences((IVirtualComponent)earEdit.getComponent());
            int i = 0;
            while (i < referencedComponents.length) {
                IVirtualComponent component = referencedComponents[i].getReferencedComponent();
                IProject componentProject = component.getProject();
                this.gatherWebServiceExtendedDescriptors(urisList, componentProject);
                this.gatherWebServiceClientExtendedDescriptors(urisList, componentProject);
                ++i;
            }
        }
        finally {
            if (earEdit != null) {
                earEdit.dispose();
            }
        }
    }

    private final void gatherWebServiceExtendedDescriptors(ArrayList urisList, IProject webServiceProject) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)webServiceProject);
        IVirtualFolder ddFolder = null;
        try {
            if (J2EEProjectUtilities.isEJBProject((IProject)webServiceProject)) {
                ddFolder = this.getDeploymentDescriptorFolder(component, "ejb-jar.xml");
            } else if (J2EEProjectUtilities.isDynamicWebProject((IProject)webServiceProject)) {
                ddFolder = this.getDeploymentDescriptorFolder(component, "web.xml");
            }
        }
        catch (CoreException coreException) {}
        if (ddFolder != null) {
            IVirtualFile file = ddFolder.getFile("ibm-webservices-bnd.xmi");
            if (file.exists()) {
                urisList.add(file.getUnderlyingResource().getFullPath().toString());
            }
            if ((file = ddFolder.getFile("ibm-webservices-ext.xmi")).exists()) {
                urisList.add(file.getUnderlyingResource().getFullPath().toString());
            }
        }
    }

    private final void gatherWebServiceClientExtendedDescriptors(ArrayList urisList, IProject webServiceClientProject) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)webServiceClientProject);
        IVirtualFolder ddFolder = null;
        try {
            if (J2EEProjectUtilities.isEJBProject((IProject)webServiceClientProject)) {
                ddFolder = this.getDeploymentDescriptorFolder(component, "ejb-jar.xml");
            } else if (J2EEProjectUtilities.isDynamicWebProject((IProject)webServiceClientProject)) {
                ddFolder = this.getDeploymentDescriptorFolder(component, "web.xml");
            } else if (J2EEProjectUtilities.isApplicationClientProject((IProject)webServiceClientProject)) {
                ddFolder = this.getDeploymentDescriptorFolder(component, "application-client.xml");
            }
        }
        catch (CoreException coreException) {}
        if (ddFolder != null) {
            IVirtualFile file = ddFolder.getFile("ibm-webservicesclient-bnd.xmi");
            if (file.exists()) {
                urisList.add(file.getUnderlyingResource().getFullPath().toString());
            }
            if ((file = ddFolder.getFile("ibm-webservicesclient-ext.xmi")).exists()) {
                urisList.add(file.getUnderlyingResource().getFullPath().toString());
            }
        }
    }

    private final void validateIbmWebServicesBndXmi(IFile file, IVirtualComponent component, IReporter reporter) {
        PersistentWSIBSPContext context = WSUIPlugin.getInstance().getWSIBSPContext();
        int severity = WSIComplianceUtils.getWSISeverity((IProject)component.getProject(), (PersistentWSIContext)context);
        ArrayList<WsExtBadElement> badElements = new ArrayList<WsExtBadElement>();
        reporter.removeAllMessages((IValidator)this, (Object)file);
        WsbndArtifactEdit wsBndArtifactEdit = null;
        try {
            WebServiceInit.init();
            WebServiceWASInit.init();
            IProject[] earProjects = J2EEProjectUtilities.getReferencingEARProjects((IProject)component.getProject());
            wsBndArtifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForRead((IVirtualComponent)component);
            WSBinding wsBnd = wsBndArtifactEdit.getWSBinding();
            if (wsBnd == null) {
                return;
            }
            if (severity != 1) {
                this.validateBndBSP(severity, badElements, file, wsBnd);
            }
            EList routerModules = wsBnd.getRouterModules();
            for (RouterModule rm : routerModules) {
                String routerModuleTransport = rm.getTransport();
                String routerModuleName = rm.getName();
                int j = 0;
                while (j < earProjects.length) {
                    IVirtualReference[] moduleUri;
                    IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProjects[j]);
                    IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider((IProject)earProjects[j]);
                    IVirtualReference[] moduleReferences = EarUtilities.getJ2EEModuleReferences((IVirtualComponent)earComponent);
                    boolean routerModuleExists = false;
                    IVirtualReference[] iVirtualReferenceArray = moduleReferences;
                    int n = moduleReferences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVirtualReference moduleReference = iVirtualReferenceArray[n2];
                        moduleUri = earModel.getModuleURI(moduleReference.getReferencedComponent());
                        if (routerModuleName.equals(moduleUri)) {
                            routerModuleExists = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!routerModuleExists) {
                        boolean bl = routerModuleExists = earComponent.getRootFolder().findMember(routerModuleName) != null;
                    }
                    if (!routerModuleExists) {
                        WsExtBadElement badElement = new WsExtBadElement("routerModules");
                        WsExtBadAttribute badAttr = new WsExtBadAttribute("name", routerModuleName);
                        badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.ext.validator.validator", 1, "MSG_ERROR_INVALID_ROUTER_MODULE", new String[]{routerModuleName, earProjects[j].getName()}, (Object)file));
                        badElement.setAttribute(badAttr);
                        badElements.add(badElement);
                    } else {
                        String componentName = component.getName();
                        moduleUri = moduleReferences;
                        int n3 = moduleReferences.length;
                        n = 0;
                        while (n < n3) {
                            IVirtualReference moduleReference = moduleUri[n];
                            IVirtualComponent moduleComponent = moduleReference.getReferencedComponent();
                            if (J2EEUtils.isEJBComponent((IVirtualComponent)moduleComponent) && !moduleComponent.getName().equals(componentName)) {
                                WsbndArtifactEdit mcWsbndArtifactEdit = null;
                                try {
                                    mcWsbndArtifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForRead((IVirtualComponent)moduleComponent);
                                    WSBinding wsBindingTemp = mcWsbndArtifactEdit.getWSBinding();
                                    EList routerModulesTemp = wsBindingTemp.getRouterModules();
                                    for (RouterModule rmTemp : routerModulesTemp) {
                                        if (!rmTemp.getName().equals(routerModuleName) || !rmTemp.getTransport().equalsIgnoreCase(routerModuleTransport)) continue;
                                        WsExtBadElement badElement = new WsExtBadElement("routerModules");
                                        WsExtBadAttribute badAttr = new WsExtBadAttribute("name", routerModuleName);
                                        badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.ext.validator.validator", 1, "MSG_ERROR_DUPLICATE_ROUTER_USAGE", new String[]{routerModuleName, moduleComponent.getName()}, (Object)file));
                                        badElement.setAttribute(badAttr);
                                        badElements.add(badElement);
                                        break;
                                    }
                                }
                                finally {
                                    if (mcWsbndArtifactEdit != null) {
                                        mcWsbndArtifactEdit.dispose();
                                    }
                                }
                            }
                            ++n;
                        }
                    }
                    ++j;
                }
            }
            WSDDArtifactEdit wsddArtifactEdit = null;
            try {
                wsddArtifactEdit = WSDDArtifactEdit.getWSDDArtifactEditForRead((IVirtualComponent)component);
                WebServices webServices = wsddArtifactEdit.getWebServices();
                if (webServices != null) {
                    Hashtable<String, Boolean> wsDescNames = new Hashtable<String, Boolean>();
                    Hashtable<String, Boolean> pcNames = new Hashtable<String, Boolean>();
                    EList webServicesDescriptions = webServices.getWebServiceDescriptions();
                    for (WebServiceDescription wsDesc : webServicesDescriptions) {
                        String wsDescName = wsDesc.getWebServiceDescriptionName();
                        if (wsDescName != null) {
                            wsDescNames.put(wsDescName, Boolean.TRUE);
                        }
                        EList pcs = wsDesc.getPortComponents();
                        for (PortComponent pc : pcs) {
                            String portComponentName = pc.getPortComponentName();
                            if (portComponentName == null) continue;
                            pcNames.put(portComponentName, Boolean.TRUE);
                        }
                    }
                    EList bindings = wsBnd.getWsdescBindings();
                    Iterator i = bindings.iterator();
                    while (i.hasNext()) {
                        WsExtBadAttribute badAttr;
                        WsExtBadElement badElement = null;
                        WSDescBinding binding = (WSDescBinding)i.next();
                        String wsDescNameLink = binding.getWsDescNameLink();
                        if (wsDescNameLink == null) {
                            badElement = new WsExtBadElement("wsdescBindings");
                            badAttr = new WsExtBadAttribute("wsDescNameLink", null);
                            badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.ext.validator.validator", 1, "MSG_ERROR_MISSING_WSDESC_NAME_LINK", new String[0], (Object)file));
                            badElement.setAttribute(badAttr);
                        } else if (wsDescNames.get(wsDescNameLink) == null) {
                            badElement = new WsExtBadElement("wsdescBindings");
                            badAttr = new WsExtBadAttribute("wsDescNameLink", wsDescNameLink);
                            badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.ext.validator.validator", 1, "MSG_ERROR_INVALID_WSDESC_NAME_LINK", new String[]{wsDescNameLink}, (Object)file));
                            badElement.setAttribute(badAttr);
                        }
                        if (badElement != null) {
                            badElements.add(badElement);
                        }
                        EList pcBindings = binding.getPcBindings();
                        Iterator j = pcBindings.iterator();
                        while (j.hasNext()) {
                            WsExtBadAttribute badAttr2;
                            badElement = null;
                            PCBinding pcBinding = (PCBinding)j.next();
                            String pcNameLink = pcBinding.getPcNameLink();
                            if (pcNameLink == null) {
                                badElement = new WsExtBadElement("pcBindings");
                                badAttr2 = new WsExtBadAttribute("pcNameLink", null);
                                badAttr2.setMessage((IMessage)new Message("com.ibm.ast.ws.ext.validator.validator", 1, "MSG_ERROR_MISSING_PC_NAME_LINK", new String[0], (Object)file));
                                badElement.setAttribute(badAttr2);
                            } else if (pcNames.get(pcNameLink) == null) {
                                badElement = new WsExtBadElement("pcBindings");
                                badAttr2 = new WsExtBadAttribute("pcNameLink", pcNameLink);
                                badAttr2.setMessage((IMessage)new Message("com.ibm.ast.ws.ext.validator.validator", 1, "MSG_ERROR_INVALID_PC_NAME_LINK", new String[]{pcNameLink, wsDescNameLink != null ? wsDescNameLink : ""}, (Object)file));
                                badElement.setAttribute(badAttr2);
                            }
                            String scope = pcBinding.getScope();
                            if (!(scope == null || "Session".equalsIgnoreCase(scope) || "Request".equalsIgnoreCase(scope) || "Application".equalsIgnoreCase(scope))) {
                                if (badElement == null) {
                                    badElement = new WsExtBadElement("pcBindings");
                                }
                                WsExtBadAttribute badAttr3 = new WsExtBadAttribute("scope", scope);
                                badAttr3.setMessage((IMessage)new Message("com.ibm.ast.ws.ext.validator.validator", 1, "MSG_ERROR_INVALID_SCOPE", new String[]{scope, pcNameLink != null ? pcNameLink : ""}, (Object)file));
                                badElement.setAttribute(badAttr3);
                            }
                            if (badElement == null) continue;
                            badElements.add(badElement);
                        }
                    }
                }
            }
            finally {
                if (wsddArtifactEdit != null) {
                    wsddArtifactEdit.dispose();
                }
            }
        }
        finally {
            if (wsBndArtifactEdit != null) {
                wsBndArtifactEdit.dispose();
            }
        }
        if (badElements.size() > 0) {
            this.reportBadElements(badElements, file, reporter);
        }
    }

    private final int convertStatusToIMessageSeverity(int severity) {
        switch (severity) {
            case 2: {
                return 2;
            }
            case 4: {
                return 1;
            }
        }
        return 4;
    }

    private final void reportBadElements(ArrayList badElements, IFile wsExFile, IReporter reporter) {
        try {
            new WsExtParser(wsExFile.getLocation().toFile().getAbsolutePath(), badElements);
            int i = 0;
            while (i < badElements.size()) {
                WsExtBadElement badElement = (WsExtBadElement)badElements.get(i);
                for (WsExtBadAttribute badAttr : badElement.getAttributes()) {
                    reporter.addMessage((IValidator)this, badAttr.getMessage());
                }
                ++i;
            }
        }
        catch (Exception exception) {
            reporter.addMessage((IValidator)this, (IMessage)new Message("com.ibm.ast.ws.ext.validator.validator", 1, "MSG_ERROR_PARSER", new String[]{wsExFile.getFullPath().toString()}, (Object)wsExFile));
        }
    }

    private final void collectStandardServiceRefs(EList serviceRefs, Hashtable standardServiceRefs) {
        for (org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef serviceRef : serviceRefs) {
            standardServiceRefs.put(serviceRef.getServiceRefName(), Boolean.TRUE);
        }
    }

    private final void validateIbmWebServicesClientBndXmi(IFile file, IVirtualComponent component, IReporter reporter) {
        PersistentWSIBSPContext context = WSUIPlugin.getInstance().getWSIBSPContext();
        int severity = WSIComplianceUtils.getWSISeverity((IProject)component.getProject(), (PersistentWSIContext)context);
        ArrayList<WsExtBadElement> badElements = new ArrayList<WsExtBadElement>();
        reporter.removeAllMessages((IValidator)this, (Object)file);
        WscbndArtifactEdit wscbndArtifactEdit = null;
        try {
            WebServiceInit.init();
            WebServiceWASInit.init();
            wscbndArtifactEdit = WscbndArtifactEdit.getWSCBNDArtifactEditForRead((IVirtualComponent)component);
            ClientBinding clientBinding = wscbndArtifactEdit.getClientBinding();
            EList serviceRefs = clientBinding.getServiceRefs();
            EList componentScopedRefs = clientBinding.getComponentScopedRefs();
            ServiceRef[] refs = null;
            if (serviceRefs.size() > 0) {
                refs = new ServiceRef[serviceRefs.size()];
                int i = 0;
                while (i < refs.length) {
                    refs[i] = (ServiceRef)serviceRefs.get(i);
                    ++i;
                }
            } else {
                ArrayList<Object> scopedRefsList = new ArrayList<Object>();
                int i = 0;
                while (i < componentScopedRefs.size()) {
                    WsExtBadElement badElement = null;
                    com.ibm.etools.webservice.wscbnd.ComponentScopedRefs componentScopedRef = (com.ibm.etools.webservice.wscbnd.ComponentScopedRefs)componentScopedRefs.get(i);
                    String componentNameLink = componentScopedRef.getComponentNameLink();
                    if (componentNameLink == null || componentNameLink.length() == 0) {
                        badElement = new WsExtBadElement("componentScopedRefs");
                        WsExtBadAttribute badAttr = new WsExtBadAttribute("componentNameLink", componentNameLink);
                        badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.ext.validator.validator", 1, "MSG_ERROR_MISSING_COMPONENT_NAME_LINK", new String[0], (Object)file));
                        badElement.setAttribute(badAttr);
                    } else if (J2EEUtils.isEJBComponent((IVirtualComponent)component)) {
                        EJBArtifactEdit ejbArtifactEdit = null;
                        try {
                            ejbArtifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
                            EJBJar ejbJar = ejbArtifactEdit.getEJBJar();
                            EnterpriseBean ejb = ejbJar.getEnterpriseBeanNamed(componentNameLink);
                            if (ejb == null) {
                                badElement = new WsExtBadElement("componentScopedRefs");
                                WsExtBadAttribute badAttr = new WsExtBadAttribute("componentNameLink", componentNameLink);
                                badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.ext.validator.validator", 1, "MSG_ERROR_INVALID_COMPONENT_NAME_LINK", new String[]{componentNameLink}, (Object)file));
                                badElement.setAttribute(badAttr);
                            }
                        }
                        finally {
                            if (ejbArtifactEdit != null) {
                                ejbArtifactEdit.dispose();
                            }
                        }
                    }
                    EList scopedRefs = componentScopedRef.getServiceRefs();
                    int j = 0;
                    while (j < scopedRefs.size()) {
                        scopedRefsList.add(scopedRefs.get(j));
                        ++j;
                    }
                    if (badElement != null) {
                        badElements.add(badElement);
                    }
                    ++i;
                }
                refs = new ServiceRef[scopedRefsList.size()];
                scopedRefsList.toArray(refs);
            }
            WSCDDArtifactEdit wscddArtifactEdit = null;
            try {
                Hashtable<String, Boolean> standardServiceRefs = new Hashtable<String, Boolean>();
                int componentJ2eeVersion = J2EEVersionUtil.convertVersionStringToInt((IVirtualComponent)component);
                if (componentJ2eeVersion == 13) {
                    wscddArtifactEdit = WSCDDArtifactEdit.getWSCDDArtifactEditForRead((IVirtualComponent)component);
                    WebServicesClient wsddRes = wscddArtifactEdit.getWebServicesClient();
                    this.collectStandardServiceRefs(wsddRes.getServiceRefs(), standardServiceRefs);
                    serviceRefs = wsddRes.getServiceRefs();
                    componentScopedRefs = wsddRes.getComponentScopedRefs();
                    for (org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs componentScopedRef : componentScopedRefs) {
                        this.collectStandardServiceRefs(componentScopedRef.getServiceRefs(), standardServiceRefs);
                        this.collectStandardServiceRefs(componentScopedRef.getServiceRefs(), standardServiceRefs);
                    }
                } else {
                    if (J2EEUtils.isWebComponent((IVirtualComponent)component)) {
                        WebArtifactEdit webArtifactEdit = null;
                        try {
                            webArtifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)component);
                            WebApp webApp = webArtifactEdit.getWebApp();
                            serviceRefs = webApp.getServiceRefs();
                            for (org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef serviceRef : serviceRefs) {
                                standardServiceRefs.put(serviceRef.getServiceRefName(), Boolean.TRUE);
                            }
                        }
                        finally {
                            if (webArtifactEdit != null) {
                                webArtifactEdit.dispose();
                            }
                        }
                    }
                    if (J2EEUtils.isEJBComponent((IVirtualComponent)component)) {
                        EJBArtifactEdit ejbArtifactEdit = null;
                        try {
                            ejbArtifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
                            EJBJar ejbJar = ejbArtifactEdit.getEJBJar();
                            EList enterpriseBeans = ejbJar.getEnterpriseBeans();
                            for (EnterpriseBean enterpriseBean : enterpriseBeans) {
                                this.collectStandardServiceRefs(enterpriseBean.getServiceRefs(), standardServiceRefs);
                            }
                        }
                        finally {
                            if (ejbArtifactEdit != null) {
                                ejbArtifactEdit.dispose();
                            }
                        }
                    }
                    if (J2EEUtils.isAppClientComponent((IVirtualComponent)component)) {
                        AppClientArtifactEdit appClientArtifactEdit = null;
                        try {
                            appClientArtifactEdit = AppClientArtifactEdit.getAppClientArtifactEditForRead((IVirtualComponent)component);
                            ApplicationClient appClient = appClientArtifactEdit.getApplicationClient();
                            this.collectStandardServiceRefs(appClient.getServiceRefs(), standardServiceRefs);
                        }
                        finally {
                            if (appClientArtifactEdit != null) {
                                appClientArtifactEdit.dispose();
                            }
                        }
                    }
                }
                int i = 0;
                while (i < refs.length) {
                    String serviceRefLink;
                    if (severity != 1) {
                        this.validateClientBndBSP(severity, badElements, file, refs[i]);
                    }
                    WsExtBadElement badElement = null;
                    String deployedWSDLFile = refs[i].getDeployedWSDLFile();
                    if (deployedWSDLFile != null && !component.getRootFolder().getFile(deployedWSDLFile).exists()) {
                        badElement = new WsExtBadElement("serviceRefs");
                        WsExtBadAttribute badAttr = new WsExtBadAttribute("deployedWSDLFile", deployedWSDLFile);
                        badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.ext.validator.validator", 1, "MSG_ERROR_INVALID_DEPLOYED_WSDL_FILE", new String[]{deployedWSDLFile}, (Object)file));
                        badElement.setAttribute(badAttr);
                    }
                    if ((serviceRefLink = refs[i].getServiceRefLink()) == null) {
                        if (badElement == null) {
                            badElement = new WsExtBadElement("serviceRefs");
                        }
                        WsExtBadAttribute badAttr = new WsExtBadAttribute("serviceRefLink", null);
                        badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.ext.validator.validator", 1, "MSG_ERROR_MISSING_SERVICE_REF_LINK", new String[0], (Object)file));
                        badElement.setAttribute(badAttr);
                    } else if (standardServiceRefs.get(serviceRefLink) == null) {
                        EList portQnameBindingsList = refs[i].getPortQnameBindings();
                        boolean shouldValidate = true;
                        for (Object portQnameBindings : portQnameBindingsList) {
                            PortQnameBinding pqb = (PortQnameBinding)portQnameBindings;
                            String overriddenEndpointURI = pqb.getOverriddenEndpointURI();
                            if (overriddenEndpointURI != null && overriddenEndpointURI.trim().length() <= 0) continue;
                            shouldValidate = false;
                            break;
                        }
                        if (shouldValidate) {
                            if (badElement == null) {
                                badElement = new WsExtBadElement("serviceRefs");
                            }
                            WsExtBadAttribute badAttr = new WsExtBadAttribute("serviceRefLink", serviceRefLink);
                            badAttr.setMessage((IMessage)new Message("com.ibm.ast.ws.ext.validator.validator", 1, "MSG_ERROR_INVALID_SERVICE_REF_LINK", new String[]{serviceRefLink}, (Object)file));
                            badElement.setAttribute(badAttr);
                        }
                    }
                    if (badElement != null) {
                        badElements.add(badElement);
                    }
                    ++i;
                }
                if (badElements.size() > 0) {
                    this.reportBadElements(badElements, file, reporter);
                }
            }
            finally {
                if (wscddArtifactEdit != null) {
                    wscddArtifactEdit.dispose();
                }
            }
        }
        finally {
            if (wscbndArtifactEdit != null) {
                wscbndArtifactEdit.dispose();
            }
        }
    }

    private void validateEncryptionInfo(int severity, ArrayList badElements, IFile file, EList kList) {
        int iMessageSeverity = this.convertStatusToIMessageSeverity(severity);
        int k = 0;
        while (k < kList.size()) {
            EncryptionInfo encryptionInfo = (EncryptionInfo)kList.get(k);
            if (encryptionInfo != null) {
                String algorithm;
                IStatus status;
                KeyEncryptionMethod keyEncryptionMethod;
                String algorithm2;
                IStatus status2;
                DataEncryptionMethod dataEncryptionMethod = encryptionInfo.getEncryptionMethod();
                if (dataEncryptionMethod != null && (status2 = BSPComplianceUtils.validateDataAlgorithm(severity, algorithm2 = dataEncryptionMethod.getAlgorithm())).getSeverity() != 0) {
                    WsExtBadElement badElement = new WsExtBadElement("encryptionMethod");
                    WsExtBadAttribute badAttr = new WsExtBadAttribute("algorithm", algorithm2);
                    badAttr.setMessage((IMessage)new LocalizedMessage(iMessageSeverity, status2.getMessage(), (IResource)file));
                    badElement.setAttribute(badAttr);
                    badElements.add(badElement);
                }
                if ((keyEncryptionMethod = encryptionInfo.getKeyEncryptionMethod()) != null && (status = BSPComplianceUtils.validateKeyAlgorithm(severity, algorithm = keyEncryptionMethod.getAlgorithm())).getSeverity() != 0) {
                    WsExtBadElement badElement = new WsExtBadElement("keyEncryptionMethod");
                    WsExtBadAttribute badAttr = new WsExtBadAttribute("algorithm", algorithm);
                    badAttr.setMessage((IMessage)new LocalizedMessage(iMessageSeverity, status.getMessage(), (IResource)file));
                    badElement.setAttribute(badAttr);
                    badElements.add(badElement);
                }
            }
            ++k;
        }
    }

    private void validateSigningInfo(int severity, ArrayList badElements, IFile file, EList kList) {
        int iMessageSeverity = this.convertStatusToIMessageSeverity(severity);
        int k = 0;
        while (k < kList.size()) {
            SigningInfo signingInfo = (SigningInfo)kList.get(k);
            if (signingInfo != null) {
                String algorithm;
                IStatus status;
                SignatureMethod signatureMethod = signingInfo.getSignatureMethod();
                if (signatureMethod != null && (status = BSPComplianceUtils.validateSignatureAlgorithm(severity, algorithm = signatureMethod.getAlgorithm())).getSeverity() != 0) {
                    WsExtBadElement badElement = new WsExtBadElement("signatureMethod");
                    WsExtBadAttribute badAttr = new WsExtBadAttribute("algorithm", algorithm);
                    badAttr.setMessage((IMessage)new LocalizedMessage(iMessageSeverity, status.getMessage(), (IResource)file));
                    badElement.setAttribute(badAttr);
                    badElements.add(badElement);
                }
                EList lList = signingInfo.getPartReference();
                int l = 0;
                while (l < lList.size()) {
                    String algorithm2;
                    Transform transform;
                    PartReference partReference = (PartReference)lList.get(l);
                    EList mList = partReference.getTransform();
                    int m = 0;
                    while (m < mList.size()) {
                        transform = (Transform)mList.get(m);
                        algorithm2 = transform.getAlgorithm();
                        IStatus status2 = BSPComplianceUtils.validateTransformAlgorithm(severity, algorithm2);
                        if (status2.getSeverity() != 0) {
                            WsExtBadElement badElement = new WsExtBadElement("transform");
                            WsExtBadAttribute badAttr = new WsExtBadAttribute("algorithm", algorithm2);
                            badAttr.setMessage((IMessage)new LocalizedMessage(iMessageSeverity, status2.getMessage(), (IResource)file));
                            badElement.setAttribute(badAttr);
                            badElements.add(badElement);
                        }
                        ++m;
                    }
                    IStatus status3 = BSPComplianceUtils.validateSignatureTransformList(severity, mList);
                    if (status3.getSeverity() != 0) {
                        transform = (Transform)mList.get(mList.size() - 1);
                        algorithm2 = transform.getAlgorithm();
                        WsExtBadElement badElement = new WsExtBadElement("transform");
                        WsExtBadAttribute badAttr = new WsExtBadAttribute("algorithm", algorithm2);
                        badAttr.setMessage((IMessage)new LocalizedMessage(iMessageSeverity, status3.getMessage(), (IResource)file));
                        badElement.setAttribute(badAttr);
                        badElements.add(badElement);
                    }
                    ++l;
                }
            }
            ++k;
        }
    }

    private void validateKeyInfo(int severity, ArrayList badElements, IFile file, EList kList) {
        int iMessageSeverity = this.convertStatusToIMessageSeverity(severity);
        int k = 0;
        while (k < kList.size()) {
            String keyInfoType;
            IStatus status;
            KeyInfo keyInfo = (KeyInfo)kList.get(k);
            if (keyInfo != null && (status = BSPComplianceUtils.validateKeyInformationType(severity, keyInfoType = keyInfo.getType())).getSeverity() != 0) {
                WsExtBadElement badElement = new WsExtBadElement("keyInfo");
                WsExtBadAttribute badAttr = new WsExtBadAttribute("type", keyInfoType);
                badAttr.setMessage((IMessage)new LocalizedMessage(iMessageSeverity, status.getMessage(), (IResource)file));
                badElement.setAttribute(badAttr);
                badElements.add(badElement);
            }
            ++k;
        }
    }

    private void validateBndBSP(int severity, ArrayList badElements, IFile file, WSBinding wsBnd) {
        EList wsDescBinding = wsBnd.getWsdescBindings();
        int i = 0;
        while (i < wsDescBinding.size()) {
            WSDescBinding wSDescBinding = (WSDescBinding)wsDescBinding.get(i);
            EList jList = wSDescBinding.getPcBindings();
            int j = 0;
            while (j < jList.size()) {
                SecurityResponseGeneratorBindingConfig securityResponseGeneratorBindingConfig;
                PCBinding pCBinding = (PCBinding)jList.get(j);
                SecurityRequestConsumerBindingConfig securityRequestConsumerBindingConfig = pCBinding.getSecurityRequestConsumerBindingConfig();
                if (securityRequestConsumerBindingConfig != null) {
                    EList kList = securityRequestConsumerBindingConfig.getEncryptionInfo();
                    this.validateEncryptionInfo(severity, badElements, file, kList);
                    kList = securityRequestConsumerBindingConfig.getSigningInfo();
                    this.validateSigningInfo(severity, badElements, file, kList);
                    kList = securityRequestConsumerBindingConfig.getKeyInfo();
                    this.validateKeyInfo(severity, badElements, file, kList);
                }
                if ((securityResponseGeneratorBindingConfig = pCBinding.getSecurityResponseGeneratorBindingConfig()) != null) {
                    EList kList = securityResponseGeneratorBindingConfig.getEncryptionInfo();
                    this.validateEncryptionInfo(severity, badElements, file, kList);
                    kList = securityResponseGeneratorBindingConfig.getSigningInfo();
                    this.validateSigningInfo(severity, badElements, file, kList);
                    kList = securityResponseGeneratorBindingConfig.getKeyInfo();
                    this.validateKeyInfo(severity, badElements, file, kList);
                }
                ++j;
            }
            ++i;
        }
    }

    private void validateClientBndBSP(int severity, ArrayList badElements, IFile file, ServiceRef refs) {
        EList portQnameBindings = refs.getPortQnameBindings();
        int i = 0;
        while (i < portQnameBindings.size()) {
            SecurityResponseConsumerBindingConfig securityResponseConsumerBindingConfig;
            PortQnameBinding portQnameBinding = (PortQnameBinding)portQnameBindings.get(i);
            SecurityRequestGeneratorBindingConfig securityRequestGeneratorBindingConfig = portQnameBinding.getSecurityRequestGeneratorBindingConfig();
            if (securityRequestGeneratorBindingConfig != null) {
                EList kList = securityRequestGeneratorBindingConfig.getEncryptionInfo();
                this.validateEncryptionInfo(severity, badElements, file, kList);
                kList = securityRequestGeneratorBindingConfig.getSigningInfo();
                this.validateSigningInfo(severity, badElements, file, kList);
                kList = securityRequestGeneratorBindingConfig.getKeyInfo();
                this.validateKeyInfo(severity, badElements, file, kList);
            }
            if ((securityResponseConsumerBindingConfig = portQnameBinding.getSecurityResponseConsumerBindingConfig()) != null) {
                EList kList = securityResponseConsumerBindingConfig.getEncryptionInfo();
                this.validateEncryptionInfo(severity, badElements, file, kList);
                kList = securityResponseConsumerBindingConfig.getSigningInfo();
                this.validateSigningInfo(severity, badElements, file, kList);
                kList = securityResponseConsumerBindingConfig.getKeyInfo();
                this.validateKeyInfo(severity, badElements, file, kList);
            }
            ++i;
        }
    }

    private final void validateIbmWebServicesExtXmi(IFile file, IVirtualComponent component, IReporter reporter) {
        PersistentWSIBSPContext context = WSUIPlugin.getInstance().getWSIBSPContext();
        int severity = WSIComplianceUtils.getWSISeverity((IProject)component.getProject(), (PersistentWSIContext)context);
        ArrayList badElements = new ArrayList();
        reporter.removeAllMessages((IValidator)this, (Object)file);
        WsextArtifactEdit wsExtArtifactEdit = null;
        try {
            WebServiceInit.init();
            WebServiceWASInit.init();
            wsExtArtifactEdit = WsextArtifactEdit.getWSEXTArtifactEditForRead((IVirtualComponent)component);
            WsExtension wsExt = wsExtArtifactEdit.getWsExtension();
            if (severity != 1) {
                this.validateExtBSP(severity, badElements, file, wsExt);
            }
            if (badElements.size() > 0) {
                this.reportBadElements(badElements, file, reporter);
            }
        }
        finally {
            if (wsExtArtifactEdit != null) {
                wsExtArtifactEdit.dispose();
            }
        }
    }

    private void validateExtBSP(int severity, ArrayList badElements, IFile file, WsExtension wsExt) {
        EList wsDescExtList = wsExt.getWsDescExt();
        int i = 0;
        while (i < wsDescExtList.size()) {
            WsDescExt wsDescExt = (WsDescExt)wsDescExtList.get(i);
            EList jList = wsDescExt.getPcBinding();
            int j = 0;
            while (j < jList.size()) {
                PcBinding pcBinding = (PcBinding)jList.get(j);
                ServerServiceConfig serverServiceConfig = pcBinding.getServerServiceConfig();
                if (serverServiceConfig != null) {
                    SecurityResponseGeneratorServiceConfig securityResponseGeneratorServiceConfig;
                    SecurityRequestConsumerServiceConfig securityRequestConsumerServiceConfig = serverServiceConfig.getSecurityRequestConsumerServiceConfig();
                    if (securityRequestConsumerServiceConfig != null) {
                        EList kList = securityRequestConsumerServiceConfig.getRequiredConfidentiality();
                        this.validateRequiredConfidentiality(severity, badElements, file, kList);
                        kList = securityRequestConsumerServiceConfig.getRequiredIntegrity();
                        this.validateRequiredIntegrity(severity, badElements, file, kList);
                    }
                    if ((securityResponseGeneratorServiceConfig = serverServiceConfig.getSecurityResponseGeneratorServiceConfig()) != null) {
                        EList kList = securityResponseGeneratorServiceConfig.getConfidentiality();
                        this.validateConfidentiality(severity, badElements, file, kList);
                        kList = securityResponseGeneratorServiceConfig.getIntegrity();
                        this.validateIntegrity(severity, badElements, file, kList);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private final void validateIbmWebServicesClientExtXmi(IFile file, IVirtualComponent component, IReporter reporter) {
        PersistentWSIBSPContext context = WSUIPlugin.getInstance().getWSIBSPContext();
        int severity = WSIComplianceUtils.getWSISeverity((IProject)component.getProject(), (PersistentWSIContext)context);
        ArrayList badElements = new ArrayList();
        reporter.removeAllMessages((IValidator)this, (Object)file);
        WscextArtifactEdit wscExtArtifactEdit = null;
        try {
            WebServiceInit.init();
            WebServiceWASInit.init();
            wscExtArtifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForRead((IVirtualComponent)component);
            WsClientExtension wscExt = wscExtArtifactEdit.getWsClientExtension();
            EList serviceRefs = wscExt.getServiceRefs();
            EList componentScopedRefs = wscExt.getComponentScopedRefs();
            com.ibm.etools.webservice.wscext.ServiceRef[] refs = null;
            if (serviceRefs.size() > 0) {
                refs = new com.ibm.etools.webservice.wscext.ServiceRef[serviceRefs.size()];
                int i = 0;
                while (i < refs.length) {
                    refs[i] = (com.ibm.etools.webservice.wscext.ServiceRef)serviceRefs.get(i);
                    ++i;
                }
            } else {
                ArrayList<Object> scopedRefsList = new ArrayList<Object>();
                int i = 0;
                while (i < componentScopedRefs.size()) {
                    ComponentScopedRefs componentScopedRef = (ComponentScopedRefs)componentScopedRefs.get(i);
                    EList scopedRefs = componentScopedRef.getServiceRefs();
                    int j = 0;
                    while (j < scopedRefs.size()) {
                        scopedRefsList.add(scopedRefs.get(j));
                        ++j;
                    }
                    ++i;
                }
                refs = new com.ibm.etools.webservice.wscext.ServiceRef[scopedRefsList.size()];
                scopedRefsList.toArray(refs);
            }
            if (severity != 1) {
                int k = 0;
                while (k < refs.length) {
                    this.validateClientExtBSP(severity, badElements, file, refs[k]);
                    ++k;
                }
            }
            if (badElements.size() > 0) {
                this.reportBadElements(badElements, file, reporter);
            }
        }
        finally {
            if (wscExtArtifactEdit != null) {
                wscExtArtifactEdit.dispose();
            }
        }
    }

    private void validateClientExtBSP(int severity, ArrayList badElements, IFile file, com.ibm.etools.webservice.wscext.ServiceRef refs) {
        EList portQnameBindings = refs.getPortQnameBindings();
        int i = 0;
        while (i < portQnameBindings.size()) {
            com.ibm.etools.webservice.wscext.PortQnameBinding portQnameBinding = (com.ibm.etools.webservice.wscext.PortQnameBinding)portQnameBindings.get(i);
            ClientServiceConfig clientServiceConfig = portQnameBinding.getClientServiceConfig();
            if (clientServiceConfig != null) {
                SecurityResponseConsumerServiceConfig securityResponseConsumerServiceConfig;
                SecurityRequestGeneratorServiceConfig securityRequestGeneratorServiceConfig = clientServiceConfig.getSecurityRequestGeneratorServiceConfig();
                if (securityRequestGeneratorServiceConfig != null) {
                    EList kList = securityRequestGeneratorServiceConfig.getConfidentiality();
                    this.validateConfidentiality(severity, badElements, file, kList);
                    kList = securityRequestGeneratorServiceConfig.getIntegrity();
                    this.validateIntegrity(severity, badElements, file, kList);
                }
                if ((securityResponseConsumerServiceConfig = clientServiceConfig.getSecurityResponseConsumerServiceConfig()) != null) {
                    EList kList = securityResponseConsumerServiceConfig.getRequiredConfidentiality();
                    this.validateRequiredConfidentiality(severity, badElements, file, kList);
                    kList = securityResponseConsumerServiceConfig.getRequiredIntegrity();
                    this.validateRequiredIntegrity(severity, badElements, file, kList);
                }
            }
            ++i;
        }
    }

    private void validateConfidentiality(int severity, ArrayList badElements, IFile file, EList kList) {
        int k = 0;
        while (k < kList.size()) {
            Confidentiality integrity = (Confidentiality)kList.get(k);
            if (integrity != null) {
                this.validateMessageParts(severity, badElements, file, integrity.getMessageParts());
                this.validateNonce(severity, badElements, file, integrity.getNonce());
                this.validateTimestamp(severity, badElements, file, integrity.getTimestamp());
            }
            ++k;
        }
    }

    private void validateRequiredConfidentiality(int severity, ArrayList badElements, IFile file, EList kList) {
        int k = 0;
        while (k < kList.size()) {
            RequiredConfidentiality requiredConfidentiality = (RequiredConfidentiality)kList.get(k);
            if (requiredConfidentiality != null) {
                this.validateMessageParts(severity, badElements, file, requiredConfidentiality.getMessageParts());
                this.validateNonce(severity, badElements, file, requiredConfidentiality.getNonce());
                this.validateTimestamp(severity, badElements, file, requiredConfidentiality.getTimestamp());
            }
            ++k;
        }
    }

    private void validateIntegrity(int severity, ArrayList badElements, IFile file, EList kList) {
        int k = 0;
        while (k < kList.size()) {
            Integrity integrity = (Integrity)kList.get(k);
            if (integrity != null) {
                this.validateNonce(severity, badElements, file, integrity.getNonce());
                this.validateTimestamp(severity, badElements, file, integrity.getTimestamp());
            }
            ++k;
        }
    }

    private void validateRequiredIntegrity(int severity, ArrayList badElements, IFile file, EList kList) {
        int k = 0;
        while (k < kList.size()) {
            RequiredIntegrity requiredIntegrity = (RequiredIntegrity)kList.get(k);
            if (requiredIntegrity != null) {
                this.validateNonce(severity, badElements, file, requiredIntegrity.getNonce());
                this.validateTimestamp(severity, badElements, file, requiredIntegrity.getTimestamp());
            }
            ++k;
        }
    }

    private void validateMessageParts(int severity, ArrayList badElements, IFile file, EList lList) {
        int iMessageSeverity = this.convertStatusToIMessageSeverity(severity);
        int l = 0;
        while (l < lList.size()) {
            MessageParts messagePart = (MessageParts)lList.get(l);
            String messagePartKeyword = messagePart.getKeyword();
            IStatus status = BSPComplianceUtils.validateExtKeyword(severity, messagePartKeyword);
            if (status.getSeverity() != 0) {
                WsExtBadElement badElement = new WsExtBadElement("messageParts");
                WsExtBadAttribute badAttr = new WsExtBadAttribute("keyword", messagePartKeyword);
                badAttr.setMessage((IMessage)new LocalizedMessage(iMessageSeverity, status.getMessage(), (IResource)file));
                badElement.setAttribute(badAttr);
                badElements.add(badElement);
            }
            ++l;
        }
    }

    private void validateNonce(int severity, ArrayList badElements, IFile file, EList lList) {
        int iMessageSeverity = this.convertStatusToIMessageSeverity(severity);
        int l = 0;
        while (l < lList.size()) {
            Nonce nonce = (Nonce)lList.get(l);
            String nonceKeyword = nonce.getKeyword();
            IStatus status = BSPComplianceUtils.validateNonceTimestampKeyword(severity, nonceKeyword);
            if (status.getSeverity() != 0) {
                WsExtBadElement badElement = new WsExtBadElement("nonce");
                WsExtBadAttribute badAttr = new WsExtBadAttribute("keyword", nonceKeyword);
                badAttr.setMessage((IMessage)new LocalizedMessage(iMessageSeverity, status.getMessage(), (IResource)file));
                badElement.setAttribute(badAttr);
                badElements.add(badElement);
            }
            ++l;
        }
    }

    private void validateTimestamp(int severity, ArrayList badElements, IFile file, EList lList) {
        int iMessageSeverity = this.convertStatusToIMessageSeverity(severity);
        int l = 0;
        while (l < lList.size()) {
            Timestamp timestamp = (Timestamp)lList.get(l);
            String timestampKeyword = timestamp.getKeyword();
            IStatus status = BSPComplianceUtils.validateNonceTimestampKeyword(severity, timestampKeyword);
            if (status.getSeverity() != 0) {
                WsExtBadElement badElement = new WsExtBadElement("timestamp");
                WsExtBadAttribute badAttr = new WsExtBadAttribute("keyword", timestampKeyword);
                badAttr.setMessage((IMessage)new LocalizedMessage(iMessageSeverity, status.getMessage(), (IResource)file));
                badElement.setAttribute(badAttr);
                badElements.add(badElement);
            }
            ++l;
        }
    }

    private class EmptyRule
    implements ISchedulingRule {
        private EmptyRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

