/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.ext.validator;

import com.ibm.etools.webservice.wscommonbnd.Transform;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.command.internal.env.core.common.MessageUtils;

public class BSPComplianceUtils {
    private static MessageUtils msgUtils_ = null;
    public static final String SECURITY_TOKEN = "securitytoken";
    public static final String USERNAME_TOKEN = "usernametoken";
    public static final String DIGEST_VALUE = "digestvalue";
    public static final String AES_192_BIT_KEY_ENCRYPTION = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String AES_192_BIT_DATA_ENCRYPTION = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String SIGNING_INFO_XPATH_TRANSFORM = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final String SIGNING_INFO_DSA_SHA1_SIGNATURE = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    public static final String KEYNAME_KEY_INFO_TYPE = "KEYNAME";
    public static final String SIGNING_INFO_C14N_TRANSFORM = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String SIGNING_INFO_STR_TRANSFORM = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";

    private static String getMessage(String key, String[] parms) {
        if (msgUtils_ == null) {
            msgUtils_ = new MessageUtils("com.ibm.ast.ws.ext.validator.validator", BSPComplianceUtils.class.getClassLoader());
        }
        if (parms != null) {
            return msgUtils_.getMessage(key, (Object[])parms);
        }
        return msgUtils_.getMessage(key);
    }

    public static IStatus validateNonceTimestampKeyword(int severity, String keyword) {
        if (keyword.equalsIgnoreCase(SECURITY_TOKEN) || keyword.equalsIgnoreCase(USERNAME_TOKEN)) {
            return Status.OK_STATUS;
        }
        return new Status(severity, "com.ibm.ast.ws.ui", 0, BSPComplianceUtils.getMessage("MSG_NONCE_TIMESTAMP_KEYWORD", new String[]{keyword, SECURITY_TOKEN, USERNAME_TOKEN}), null);
    }

    public static IStatus validateExtKeyword(int severity, String keyword) {
        if (keyword.equalsIgnoreCase(DIGEST_VALUE)) {
            return new Status(severity, "com.ibm.ast.ws.ui", 0, BSPComplianceUtils.getMessage("MSG_EXT_KEYWORD", new String[]{keyword}), null);
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateKeyAlgorithm(int severity, String algorithm) {
        if (algorithm.equalsIgnoreCase(AES_192_BIT_KEY_ENCRYPTION)) {
            return new Status(severity, "com.ibm.ast.ws.ui", 0, BSPComplianceUtils.getMessage("MSG_KEY_ALGORITHM", null), null);
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateDataAlgorithm(int severity, String algorithm) {
        if (algorithm.equalsIgnoreCase(AES_192_BIT_DATA_ENCRYPTION)) {
            return new Status(severity, "com.ibm.ast.ws.ui", 0, BSPComplianceUtils.getMessage("MSG_DATA_ALGORITHM", null), null);
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateTransformAlgorithm(int severity, String algorithm) {
        if (algorithm.equalsIgnoreCase(SIGNING_INFO_XPATH_TRANSFORM)) {
            return new Status(severity, "com.ibm.ast.ws.ui", 0, BSPComplianceUtils.getMessage("MSG_TRANSFORM_ALGORITHM", new String[]{algorithm}), null);
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateSignatureAlgorithm(int severity, String algorithm) {
        if (algorithm.equalsIgnoreCase(SIGNING_INFO_DSA_SHA1_SIGNATURE)) {
            return new Status(severity, "com.ibm.ast.ws.ui", 0, BSPComplianceUtils.getMessage("MSG_SIGNATURE_ALGORITHM", new String[]{algorithm}), null);
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateKeyInformationType(int severity, String algorithm) {
        if (algorithm.equalsIgnoreCase(KEYNAME_KEY_INFO_TYPE)) {
            return new Status(severity, "com.ibm.ast.ws.ui", 0, BSPComplianceUtils.getMessage("MSG_KEY_INFORMATION_TYPE", new String[]{algorithm}), null);
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateSignatureTransformList(int severity, EList transformList) {
        Transform lastTransform;
        int transformListSize = transformList.size();
        Transform transform = lastTransform = transformListSize > 0 ? (Transform)transformList.get(transformListSize - 1) : null;
        if (lastTransform == null) {
            return Status.OK_STATUS;
        }
        if (lastTransform.getAlgorithm().equalsIgnoreCase(SIGNING_INFO_C14N_TRANSFORM) || lastTransform.getAlgorithm().equalsIgnoreCase(SIGNING_INFO_STR_TRANSFORM)) {
            return Status.OK_STATUS;
        }
        return new Status(severity, "com.ibm.ast.ws.ui", 0, BSPComplianceUtils.getMessage("MSG_SIGNATURE_TRANSFORM_LIST", new String[]{SIGNING_INFO_C14N_TRANSFORM, SIGNING_INFO_STR_TRANSFORM}), null);
    }
}

