/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.widgets;

import com.ibm.ast.ws.uddi.registry.context.PersistentInstalledUDDIRegistryContext;
import com.ibm.ast.ws.uddi.registry.datamodel.Category;
import com.ibm.ast.ws.uddi.registry.plugin.WebServiceUDDIRegistryPlugin;
import com.ibm.ast.ws.uddi.registry.widgets.PrivateUDDIConfigWidgetForDB2;
import com.ibm.ast.ws.uddi.registry.widgets.UserDefinedCategoryTable;
import com.ibm.ast.ws.uddi.registry.widgets.binding.WASPrivateUDDIRegistryType;
import java.util.List;
import java.util.Vector;
import org.eclipse.jst.ws.internal.uddiregistry.wizard.PrivateUDDIRegistryTypeRegistry;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class PrivateUDDIConfigWidgetForCloudscape
extends SimpleWidgetDataContributor {
    protected UserDefinedCategoryTable catTable_;
    protected Button createNewServerRadio_;
    protected Button useExistingServerRadio_;
    protected Combo serverCombo_;
    protected Button launchWSECheck_;
    protected Vector supportedServers_;
    protected Composite serverComposite;
    protected Composite serverComposite2;
    protected byte operation;
    protected WASPrivateUDDIRegistryType registryType;
    private final String INFOPOP_PUPR_PRIVATE_UDDI_CLOUDSCAPE_PAGE = "PUPR0001";
    private final String INFOPOP_PUPR_CREATE_NEW_SERVER = "PUPR0003";
    private final String INFOPOP_PUPR_USE_EXISTING_SERVER = "PUPR0004";
    private final String INFOPOP_PUPR_SERVER_NAME = "PUPR0005";
    private final String INFOPOP_PUPR_LAUNCH_WSE = "PUPR0006";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        if (!(this instanceof PrivateUDDIConfigWidgetForDB2)) {
            parent.setToolTipText(this.getMessage("TOOLTIP_PUPR_PRIVATE_UDDI_CLOUDSCAPE_PAGE"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "PUPR0001");
        }
        this.catTable_ = new UserDefinedCategoryTable();
        this.catTable_.addControls(parent, statusListener);
        this.serverComposite = this.getUIUtils().createComposite(parent, 1);
        this.createNewServerRadio_ = this.getUIUtils().createRadioButton(this.serverComposite, this.getMessage("%BUTTON_CREATE_NEW_SERVER"), this.getMessage("TOOLTIP_PUPR_CREATE_NEW_SERVER"), "PUPR0003");
        this.createNewServerRadio_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrivateUDDIConfigWidgetForCloudscape.this.serverCombo_.setEnabled(false);
            }
        });
        this.useExistingServerRadio_ = this.getUIUtils().createRadioButton(this.serverComposite, this.getMessage("BUTTON_USE_EXISTING_SERVER"), this.getMessage("TOOLTIP_PUPR_USE_EXISTING_SERVER"), "PUPR0004");
        this.useExistingServerRadio_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrivateUDDIConfigWidgetForCloudscape.this.serverCombo_.setEnabled(true);
            }
        });
        this.serverComposite2 = this.getUIUtils().createComposite(this.serverComposite, 2);
        this.serverCombo_ = this.getUIUtils().createCombo(this.serverComposite2, this.getMessage("LABEL_SERVER_NAME"), this.getMessage("TOOLTIP_PUPR_SERVER_NAME"), "PUPR0005", 12);
        this.launchWSECheck_ = this.getUIUtils().createCheckbox(parent, this.getMessage("BUTTON_LAUNCH_WSE"), this.getMessage("TOOLTIP_PUPR_LAUNCH_WSE"), "PUPR0006");
        this.launchWSECheck_.setSelection(true);
        return this;
    }

    protected void addServerInstancesToCombo() {
        this.serverCombo_.removeAll();
        String[] serverIDs = PrivateUDDIRegistryTypeRegistry.getInstance().getSupportedServerFactoryIDByID(this.registryType.getID());
        IServer[] serverInstances = ServerCore.getServers();
        this.supportedServers_ = new Vector();
        int i = 0;
        while (i < serverIDs.length) {
            this.supportedServers_.addAll(this.getServersByFactoryID(serverInstances, serverIDs[i]));
            ++i;
        }
        int j = 0;
        while (j < this.supportedServers_.size()) {
            IServer server = (IServer)this.supportedServers_.elementAt(j);
            this.serverCombo_.add(server.getName());
            ++j;
        }
        if (this.serverCombo_.getItemCount() > 0) {
            this.useExistingServerRadio_.setSelection(true);
            if (this.operation == 2 || this.operation == 1) {
                PersistentInstalledUDDIRegistryContext context = WebServiceUDDIRegistryPlugin.getInstance().getInstalledRegistryContext();
                String serverID = context.getServerID();
                if (this.serverCombo_.indexOf(serverID) > -1) {
                    this.serverCombo_.setText(serverID);
                } else {
                    this.serverCombo_.select(0);
                }
            } else {
                this.serverCombo_.select(0);
            }
        } else {
            this.createNewServerRadio_.setSelection(true);
            this.useExistingServerRadio_.setEnabled(false);
            this.serverComposite2.setEnabled(false);
        }
    }

    private List getServersByFactoryID(IServer[] availableServers, String id) {
        Vector<IServer> servers = new Vector<IServer>();
        int i = 0;
        while (i < availableServers.length) {
            if (availableServers[i].getServerType().getId().equals(id)) {
                servers.add(availableServers[i]);
            }
            ++i;
        }
        return servers;
    }

    protected void enableAllControls(boolean enable) {
        this.catTable_.setEnabled(enable);
        this.serverComposite.setEnabled(enable);
        this.serverComposite2.setEnabled(enable);
        this.launchWSECheck_.setEnabled(enable);
        this.launchWSECheck_.setSelection(enable);
    }

    public void setOperationType(byte operation) {
        this.operation = operation;
        if (this.registryType != null) {
            switch (operation) {
                case 0: {
                    this.enableAllControls(true);
                    this.addServerInstancesToCombo();
                    break;
                }
                case 2: {
                    this.enableAllControls(false);
                    break;
                }
                case 1: {
                    this.enableAllControls(true);
                    this.serverComposite.setEnabled(false);
                    this.catTable_.populateWithSavedCategories(this.registryType.getCategoriesDirectory());
                }
            }
        }
    }

    public void setRegistryType(WASPrivateUDDIRegistryType type) {
        this.registryType = type;
        if (this.operation != -1) {
            switch (this.operation) {
                case 0: {
                    this.enableAllControls(true);
                    this.addServerInstancesToCombo();
                    break;
                }
                case 2: {
                    this.enableAllControls(false);
                    this.addServerInstancesToCombo();
                    break;
                }
                case 1: {
                    this.enableAllControls(true);
                    this.serverComposite.setEnabled(false);
                    this.addServerInstancesToCombo();
                    this.catTable_.populateWithSavedCategories(this.registryType.getCategoriesDirectory());
                }
            }
        }
    }

    public boolean getLaunchWSExplorer() {
        return this.launchWSECheck_.getSelection();
    }

    public Category[] getCategories() {
        return this.catTable_.getCategories();
    }

    public String getServerID() {
        return this.serverCombo_.getText();
    }

    public IServer getServer() {
        return this.createNewServerRadio_.getSelection() ? null : (IServer)this.supportedServers_.elementAt(this.serverCombo_.getSelectionIndex());
    }

    protected String getMessage(String key) {
        return WebServiceUDDIRegistryPlugin.getMessage(key);
    }

    protected UIUtils getUIUtils() {
        return WebServiceUDDIRegistryPlugin.getUiUtils();
    }
}

