/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.preferences;

import com.ibm.ast.ws.uddi.registry.plugin.WebServiceUDDIRegistryPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.ws.internal.context.UDDIPreferenceContext;
import org.eclipse.jst.ws.internal.context.UDDIPreferenceDefaults;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class PrivateUDDIPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String INFOPOP_PPWE_PAGE = "com.ibm.ast.ws.uddi.registry.PPWE0001";
    private Text uddiCatDataColumnDelimText;
    private Text uddiCatDataStringDelimText;
    private final String INFOPOP_PPWE_UDDI_CAT_DATA_COLUMN_DELIM = "com.ibm.ast.ws.uddi.registry.PPWE0005";
    private final String INFOPOP_PPWE_UDDI_CAT_DATA_STRING_DELIM = "com.ibm.ast.ws.uddi.registry.PPWE0006";

    protected Control createContents(Composite superparent) {
        Composite parent = new Composite(superparent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 5;
        gl.marginWidth = 5;
        parent.setLayout((Layout)gl);
        parent.setToolTipText(WebServiceUDDIRegistryPlugin.getMessage("%TOOLTIP_PPWE_PAGE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.ast.ws.uddi.registry.PPWE0001");
        parent.setLayoutData((Object)new GridData(768));
        this.uddiCatDataColumnDelimText = this.createDelimControl(parent, WebServiceUDDIRegistryPlugin.getMessage("%LABEL_UDDI_CAT_DATA_COLUMN_DELIM"), WebServiceUDDIRegistryPlugin.getMessage("%TOOLTIP_PPWE_UDDI_CAT_DATA_COLUMN_DELIM"), "com.ibm.ast.ws.uddi.registry.PPWE0005");
        this.uddiCatDataStringDelimText = this.createDelimControl(parent, WebServiceUDDIRegistryPlugin.getMessage("%LABEL_UDDI_CAT_DATA_STRING_DELIM"), WebServiceUDDIRegistryPlugin.getMessage("%TOOLTIP_PPWE_UDDI_CAT_DATA_STRING_DELIM"), "com.ibm.ast.ws.uddi.registry.PPWE0006");
        this.initializeValues();
        Dialog.applyDialogFont((Control)superparent);
        return parent;
    }

    private final Text createDelimControl(Composite parent, String label, String toolTipText, String infoPopKey) {
        Label delimLabel = new Label(parent, 16384);
        delimLabel.setText(label);
        delimLabel.setLayoutData((Object)new GridData(4));
        Text delimTextControl = new Text(parent, 18432);
        delimTextControl.setTextLimit(1);
        GridData grData = new GridData(4);
        grData.widthHint = this.convertWidthInCharsToPixels(2);
        delimTextControl.setLayoutData((Object)grData);
        delimTextControl.setToolTipText(toolTipText);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)delimTextControl, infoPopKey);
        return delimTextControl;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        if (this.uddiCatDataColumnDelimText.getText().equals(this.uddiCatDataStringDelimText.getText())) {
            MessageBox mb = new MessageBox(this.getShell(), 33);
            mb.setMessage(WebServiceUDDIRegistryPlugin.getMessage("%MSG_ERROR_COLUMN_STRING_DELIMS_IDENTICAL"));
            mb.open();
            return false;
        }
        this.storeValues();
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        this.uddiCatDataColumnDelimText.setText(UDDIPreferenceDefaults.getUddiCatDataColumnDelimiter());
        this.uddiCatDataStringDelimText.setText(UDDIPreferenceDefaults.getUddiCatDataStringDelimiter());
    }

    private void initializeValues() {
        String stringDelimiter;
        UDDIPreferenceContext uddiContext = WebServicePlugin.getInstance().getUDDIPreferenceContext();
        String columnDelimiter = uddiContext.getUddiCatDataColumnDelimiter();
        if (columnDelimiter == null || columnDelimiter.length() <= 0) {
            columnDelimiter = UDDIPreferenceDefaults.getUddiCatDataColumnDelimiter();
        }
        if ((stringDelimiter = uddiContext.getUddiCatDataStringDelimiter()) == null || stringDelimiter.length() <= 0) {
            stringDelimiter = UDDIPreferenceDefaults.getUddiCatDataStringDelimiter();
        }
        this.uddiCatDataColumnDelimText.setText(columnDelimiter);
        this.uddiCatDataStringDelimText.setText(stringDelimiter);
    }

    private void storeValues() {
        UDDIPreferenceContext uddiContext = WebServicePlugin.getInstance().getUDDIPreferenceContext();
        uddiContext.setUddiCatDataColumnDelimiter(this.uddiCatDataColumnDelimText.getText());
        uddiContext.setUddiCatDataStringDelimiter(this.uddiCatDataStringDelimText.getText());
    }
}

