/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.command;

import com.ibm.ast.ws.uddi.registry.datamodel.Category;
import com.ibm.ast.ws.uddi.registry.plugin.WebServiceUDDIRegistryPlugin;
import com.ibm.ast.ws.uddi.registry.widgets.binding.WASPrivateUDDIRegistryType;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class UpdateCategoryDataCommand
extends AbstractDataModelOperation {
    private Category[] categories;
    private WASPrivateUDDIRegistryType registryType;
    private String profileLocation;

    public UpdateCategoryDataCommand(WASPrivateUDDIRegistryType registryType) {
        this.registryType = registryType;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        monitor.beginTask(WebServiceUDDIRegistryPlugin.getMessage("PROG_MSG_INIT_UDDI_REGISTRY"), -1);
        try {
            File[] categoryPropertiesFiles;
            Hashtable<String, Boolean> categoriesHash = new Hashtable<String, Boolean>();
            File categoriesDirectoryFile = new File(this.registryType.getCategoriesDirectory(this.profileLocation));
            if (!categoriesDirectoryFile.exists()) {
                categoriesDirectoryFile.mkdirs();
            }
            String categoriesDirectoryPath = categoriesDirectoryFile.getAbsolutePath();
            if (this.categories != null) {
                StringBuffer categoryPropertiesFileFullPathName = new StringBuffer();
                StringBuffer categoryPropertiesFileName = new StringBuffer();
                int i = 0;
                while (i < this.categories.length) {
                    Properties categoryProperties = new Properties();
                    categoryPropertiesFileFullPathName.setLength(0);
                    categoryPropertiesFileName.setLength(0);
                    categoryPropertiesFileName.append(this.categories[i].getName()).append(".properties");
                    categoryPropertiesFileFullPathName.append(categoriesDirectoryPath).append(File.separatorChar).append(categoryPropertiesFileName.toString());
                    categoryProperties.setProperty("wsad.name", this.categories[i].getName());
                    categoryProperties.setProperty("wsad.dataFile", this.categories[i].getDataFile());
                    categoryProperties.setProperty("wsad.categoryKey", this.categories[i].getKey());
                    categoriesHash.put(categoryPropertiesFileName.toString(), Boolean.TRUE);
                    FileOutputStream fout = new FileOutputStream(categoryPropertiesFileFullPathName.toString());
                    categoryProperties.store(fout, null);
                    fout.close();
                    ++i;
                }
            }
            if ((categoryPropertiesFiles = categoriesDirectoryFile.listFiles()) != null && categoryPropertiesFiles.length > 0) {
                int i = 0;
                while (i < categoryPropertiesFiles.length) {
                    String categoryPropertiesFileName = categoryPropertiesFiles[i].getName();
                    if (categoryPropertiesFileName.endsWith(".properties") && categoriesHash.get(categoryPropertiesFileName) == null) {
                        categoryPropertiesFiles[i].delete();
                    }
                    ++i;
                }
            }
            return Status.OK_STATUS;
        }
        catch (Throwable e) {
            Status status = new Status(4, "com.ibm.ast.ws.uddi.registry", 0, WebServiceUDDIRegistryPlugin.getMessage("%MSG_ERROR_UPDATE_CATEGORY_DATA"), e);
            this.getEnvironment().getStatusHandler().reportError((IStatus)status);
            return status;
        }
    }

    public Category[] getCategories() {
        return this.categories;
    }

    public void setCategories(Category[] categories) {
        this.categories = categories;
    }

    public void setProfileLocation(String profileLocation) {
        this.profileLocation = profileLocation;
    }
}

