/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.command;

import com.ibm.ast.ws.uddi.registry.command.ExecuteCommandLine;
import com.ibm.ast.ws.uddi.registry.plugin.WebServiceUDDIRegistryPlugin;
import com.ibm.ast.ws.uddi.registry.widgets.binding.WASPrivateUDDIRegistryType;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class StartUDDIApplicationCommand
extends AbstractDataModelOperation {
    protected final String UDDI_SCRIPT_START_UDDI = "startUDDIApplication.jacl";
    protected final String UDDI_LOG_START_UDDI = "startUDDIApplication.log";
    private String nodeName;
    private String serverName;
    private WASPrivateUDDIRegistryType registryType;
    protected boolean secureServer;
    protected String serverUserName;
    protected String serverPassword;
    protected String soapPort;
    protected String profileName;

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public StartUDDIApplicationCommand(WASPrivateUDDIRegistryType type) {
        this.registryType = type;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        String[] commandWindows;
        monitor.beginTask(WebServiceUDDIRegistryPlugin.getMessage("PROG_MSG_START_UDDI_APP"), -1);
        String[] command = null;
        StringBuffer scriptPath = new StringBuffer(this.registryType.getScriptsDirectory());
        scriptPath.append("startUDDIApplication.jacl");
        if (System.getProperty("os.name").toLowerCase().indexOf("win") < 0) {
            String[] commandLinux;
            if (this.secureServer) {
                commandLinux = new String[]{"/bin/sh", this.registryType.SERVER_WSADMIN_SH, "-profileName", this.profileName, "-user", this.serverUserName, "-password", this.serverPassword, "-f", scriptPath.toString(), this.nodeName, this.serverName, "-port", this.soapPort};
                command = commandLinux;
            } else {
                commandLinux = new String[]{"/bin/sh", this.registryType.SERVER_WSADMIN_SH, "-profileName", this.profileName, "-f", scriptPath.toString(), this.nodeName, this.serverName, "-port", this.soapPort};
                command = commandLinux;
            }
        } else if (this.secureServer) {
            commandWindows = new String[]{"cmd", "/c", this.registryType.SERVER_WSADMIN_BAT, "-profileName", this.profileName, "-user", this.serverUserName, "-password", this.serverPassword, "-f", scriptPath.toString(), this.nodeName, this.serverName, "-port", this.soapPort, ">", "startUDDIApplication.log"};
            command = commandWindows;
        } else {
            commandWindows = new String[]{"cmd", "/c", this.registryType.SERVER_WSADMIN_BAT, "-profileName", this.profileName, "-f", scriptPath.toString(), this.nodeName, this.serverName, "-port", this.soapPort, ">", "startUDDIApplication.log"};
            command = commandWindows;
        }
        ExecuteCommandLine startApp = new ExecuteCommandLine(command, String.valueOf(this.registryType.getServerInstallationDirectory()) + this.registryType.SERVER_BIN_DIR);
        IStatus status = startApp.execute(monitor, adaptable);
        if (status.getSeverity() != 0) {
            this.getEnvironment().getStatusHandler().reportError(status);
        }
        return status;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setSecureServer(boolean secureServer) {
        this.secureServer = secureServer;
    }

    public void setServerPassword(String serverPassword) {
        this.serverPassword = serverPassword;
    }

    public void setServerUserName(String serverUserName) {
        this.serverUserName = serverUserName;
    }

    public void setSoapPort(String soapPort) {
        this.soapPort = soapPort;
    }
}

