/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.command;

import com.ibm.ast.ws.uddi.registry.command.ExecuteCommandLine;
import com.ibm.ast.ws.uddi.registry.context.PersistentInstalledUDDIRegistryContext;
import com.ibm.ast.ws.uddi.registry.plugin.WebServiceUDDIRegistryPlugin;
import com.ibm.ast.ws.uddi.registry.widgets.binding.WASPrivateUDDIRegistryType;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class RemoveUDDIDB2DatabaseCommand
extends AbstractDataModelOperation {
    private final String DB2_LINUX_DROP_DB_SCRIPT = "removeDBWrapper.sh";
    private String userID;
    private WASPrivateUDDIRegistryType registryType;

    public RemoveUDDIDB2DatabaseCommand(WASPrivateUDDIRegistryType type) {
        this.registryType = type;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        monitor.beginTask(WebServiceUDDIRegistryPlugin.getMessage("PROG_MSG_REMOVING_UDDI_DB"), -1);
        String[] command = System.getProperty("os.name").toLowerCase().indexOf("win") < 0 ? this.getLinuxCommand() : this.getWinCommand();
        ExecuteCommandLine dropCommand = new ExecuteCommandLine(command);
        IStatus status = dropCommand.execute(monitor, adaptable);
        if (status.getSeverity() == 0) {
            PersistentInstalledUDDIRegistryContext context = WebServiceUDDIRegistryPlugin.getInstance().getInstalledRegistryContext();
            context.setInstallingServer("");
            return status;
        }
        status = new Status(4, "com.ibm.ast.ws.uddi.registry", 0, WebServiceUDDIRegistryPlugin.getMessage("%MSG_ERROR_REMOVE_DATABASE"), status.getException());
        this.getEnvironment().getStatusHandler().reportError(status);
        return status;
    }

    private String[] getWinCommand() {
        String[] command = new String[]{"db2cmd", "/i", "/w", "/c", "db2", "-o-", "drop", "database", "UDDI30"};
        return command;
    }

    private String[] getLinuxCommand() {
        String[] command = new String[]{"/bin/sh", String.valueOf(this.registryType.getScriptsDirectory()) + "removeDBWrapper.sh", this.userID, "UDDI30"};
        return command;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }
}

