/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.command;

import com.ibm.ast.ws.uddi.registry.command.ExecuteCommandLine;
import com.ibm.ast.ws.uddi.registry.context.PersistentInstalledUDDIRegistryContext;
import com.ibm.ast.ws.uddi.registry.plugin.WebServiceUDDIRegistryPlugin;
import com.ibm.ast.ws.uddi.registry.widgets.binding.WASPrivateUDDIRegistryType;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class DeployUDDIRegistryCommand
extends AbstractDataModelOperation {
    protected final String UDDI_SCRIPT_DEPLOY = "uddiDeploy.jacl";
    protected final String UDDI_LOG_DEPLOY = "uddiDeploy.log";
    protected String serverName;
    protected String nodeName;
    protected WASPrivateUDDIRegistryType registryType;
    protected boolean secureServer;
    protected String serverUserName;
    protected String serverPassword;
    protected String soapPort;
    protected String profileName;
    protected String serverID;

    public void setServerID(String serverID) {
        this.serverID = serverID;
    }

    public DeployUDDIRegistryCommand(WASPrivateUDDIRegistryType type) {
        this.registryType = type;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        monitor.beginTask(WebServiceUDDIRegistryPlugin.getMessage("PROG_MSG_DEPLOY_UDDI"), -1);
        String[] command = System.getProperty("os.name").toLowerCase().indexOf("win") < 0 ? this.getLinuxCommand() : this.getWinCommand();
        ExecuteCommandLine deploy = new ExecuteCommandLine(command, String.valueOf(this.registryType.getServerInstallationDirectory()) + this.registryType.SERVER_BIN_DIR);
        IStatus status = deploy.execute(monitor, adaptable);
        if (status.getSeverity() != 0) {
            status = new Status(4, "com.ibm.ast.ws.uddi.registry", 0, WebServiceUDDIRegistryPlugin.getMessage("%MSG_ERROR_DEPLOY_REGISTRY"), status.getException());
            this.getEnvironment().getStatusHandler().reportError(status);
        }
        PersistentInstalledUDDIRegistryContext context = WebServiceUDDIRegistryPlugin.getInstance().getInstalledRegistryContext();
        context.setServerID(this.serverID);
        return status;
    }

    protected String[] getLinuxCommand() {
        if (this.secureServer) {
            String[] command = new String[]{"/bin/sh", this.registryType.SERVER_WSADMIN_SH, "-profileName", this.profileName, "-user", this.serverUserName, "-password", this.serverPassword, "-f", "uddiDeploy.jacl", this.nodeName, this.serverName, "-port", this.soapPort};
            return command;
        }
        String[] command = new String[]{"/bin/sh", this.registryType.SERVER_WSADMIN_SH, "-profileName", this.profileName, "-f", "uddiDeploy.jacl", this.nodeName, this.serverName, "-port", this.soapPort};
        return command;
    }

    protected String[] getWinCommand() {
        if (this.secureServer) {
            String[] command = new String[]{"cmd", "/c", this.registryType.SERVER_WSADMIN_BAT, "-profileName", this.profileName, "-user", this.serverUserName, "-password", this.serverPassword, "-f", "uddiDeploy.jacl", this.nodeName, this.serverName, "-port", this.soapPort};
            return command;
        }
        String[] command = new String[]{"cmd", "/c", this.registryType.SERVER_WSADMIN_BAT, "-profileName", this.profileName, "-f", "uddiDeploy.jacl", this.nodeName, this.serverName, "-port", this.soapPort};
        return command;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setSecureServer(boolean secureServer) {
        this.secureServer = secureServer;
    }

    public void setServerPassword(String serverPassword) {
        this.serverPassword = serverPassword;
    }

    public void setServerUserName(String serverUserName) {
        this.serverUserName = serverUserName;
    }

    public void setSoapPort(String soapPort) {
        this.soapPort = soapPort;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }
}

