/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.uddi.registry.command;

import com.ibm.ast.ws.uddi.registry.command.ExecuteCommandLine;
import com.ibm.ast.ws.uddi.registry.context.PersistentInstalledUDDIRegistryContext;
import com.ibm.ast.ws.uddi.registry.plugin.WebServiceUDDIRegistryPlugin;
import com.ibm.ast.ws.uddi.registry.widgets.binding.WASPrivateUDDIRegistryType;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CreateUDDIDB2DatabaseCommand
extends AbstractDataModelOperation {
    private final String DB2_SCRIPT_LOCATION = "/UDDIReg/databaseScripts";
    private final String DB2_WIN_CREATE_DB_SCRIPT = "wrapper.bat";
    private final String DB2_WIN_CREATE_DB_LOG = "wrapper.log";
    private final String DB2_LINUX_CREATE_DB_SCRIPT = "wrapper.sh";
    private String userID;
    private String password;
    private WASPrivateUDDIRegistryType registryType;

    public CreateUDDIDB2DatabaseCommand(WASPrivateUDDIRegistryType type) {
        this.registryType = type;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        monitor.beginTask(WebServiceUDDIRegistryPlugin.getMessage("PROG_MSG_CREATE_UDDI_DB"), -1);
        String[] command = System.getProperty("os.name").toLowerCase().indexOf("win") < 0 ? this.createLinuxDatabase() : this.createWinDatabase();
        ExecuteCommandLine deploy = new ExecuteCommandLine(command, this.registryType.getScriptsDirectory());
        IStatus status = deploy.execute(monitor, adaptable);
        if (status.getSeverity() != 0) {
            status = new Status(4, "com.ibm.ast.ws.uddi.registry", 0, WebServiceUDDIRegistryPlugin.getMessage("%MSG_ERROR_CREATE_DATABASE"), status.getException());
            this.getEnvironment().getStatusHandler().reportError(status);
            return status;
        }
        PersistentInstalledUDDIRegistryContext context = WebServiceUDDIRegistryPlugin.getInstance().getInstalledRegistryContext();
        context.setInstallingServer(this.registryType.getID());
        return status;
    }

    private String[] createLinuxDatabase() {
        String[] command = new String[]{"/bin/sh", String.valueOf(this.registryType.getScriptsDirectory()) + "wrapper.sh", new StringBuffer(this.registryType.getServerInstallationDirectory()).append("/UDDIReg/databaseScripts").toString(), "UDDI30", this.userID, this.password, "default", this.registryType.getScriptsDirectory(), ">", "wrapper.log"};
        return command;
    }

    private String[] createWinDatabase() {
        String[] command = new String[]{"cmd", "/c", "wrapper.bat", new StringBuffer("\"").append(this.registryType.getServerInstallationDirectory()).append("/UDDIReg/databaseScripts").append("\"").toString(), "UDDI30", this.userID, this.password, "default", ">", "wrapper.log"};
        return command;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }
}

