/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.service.policy.ui;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;

public class ServiceUtils {
    public static List<IServicePolicy> getPolicySets() {
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        IServicePolicy wasV61ServiceCategory = platform.getServicePolicy("com.ibm.ast.ws.service.policy.ui.policyset.category");
        IServicePolicy wasV70ServiceCategory = platform.getServicePolicy("com.ibm.ast.ws.service.policy.ui.policyset.category70");
        IServicePolicy wasSysServiceCategory = platform.getServicePolicy("com.ibm.ast.ws.service.policy.ui.policyset.category70.sys");
        Vector<IServicePolicy> result = new Vector<IServicePolicy>();
        result.addAll(wasV61ServiceCategory.getChildren());
        result.addAll(wasV70ServiceCategory.getChildren());
        result.addAll(wasSysServiceCategory.getChildren());
        return result;
    }

    public static String getNewPath(IPath currentPath, String policySetName) {
        IPath lastPart = currentPath.removeFirstSegments(2);
        Path newPath = new Path(currentPath.segment(0));
        newPath = newPath.append(policySetName);
        newPath = newPath.append(lastPart);
        return newPath.toString();
    }

    public static Set<String> getPolicySetNames(List<IServicePolicy> policySets) {
        HashSet<String> result = new HashSet<String>();
        for (IServicePolicy policy : policySets) {
            result.add(policy.getDescriptor().getShortName());
        }
        return result;
    }

    public static String findUniqueName(Set<String> names, String baseName) {
        String result = baseName;
        if (names.contains(baseName)) {
            String strippedName = baseName.replaceFirst("\\d*$", "");
            int count = 1;
            result = String.valueOf(strippedName) + count;
            while (names.contains(result)) {
                result = String.valueOf(strippedName) + ++count;
            }
        }
        return result;
    }
}

