/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.internal.service.policy.ui.utils;

import com.ibm.ast.ws.internal.service.policy.ui.Messages;
import com.ibm.ast.ws.internal.service.policy.ui.utils.ExportEntry;
import com.ibm.ast.ws.internal.service.policy.ui.utils.ImportEntry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ZipUtils {
    public static void getPolicyEntries(ZipFile zipfile, Map<String, ImportEntry> policySetTable) throws ZipException {
        Enumeration<? extends ZipEntry> entries = zipfile.entries();
        while (entries.hasMoreElements()) {
            String xmlFileName;
            String policySetName;
            ImportEntry policyEntry;
            Path path;
            String extension;
            ZipEntry zipentry = entries.nextElement();
            String name = zipentry.getName();
            if (name.indexOf(92) != -1) {
                name = name.replaceAll("\\\\", "/");
            }
            if ((extension = (path = new Path(name)).getFileExtension()) == null || !extension.equals("xml")) continue;
            if (path.segmentCount() <= 2 || !path.segment(0).equals("PolicySets")) {
                ZipUtils.invalidPath(name);
            }
            if ((policyEntry = policySetTable.get(policySetName = path.segment(1))) == null) {
                policyEntry = new ImportEntry();
                policyEntry.setName(policySetName);
                policySetTable.put(policySetName, policyEntry);
            }
            if ((xmlFileName = path.lastSegment()) == null) {
                ZipUtils.invalidPath(name);
            }
            if (xmlFileName.equals("policySet.xml")) {
                policyEntry.setPolicySetEntry(zipentry);
                continue;
            }
            if (xmlFileName.equals("policy.xml")) {
                policyEntry.getPolicyTypes().add(zipentry);
                continue;
            }
            ZipUtils.invalidPath(name);
        }
    }

    public static void getBindingsEntries(ZipFile zipfile, Map<String, ImportEntry> namedBindingsTable) throws ZipException {
        Enumeration<? extends ZipEntry> entries = zipfile.entries();
        while (entries.hasMoreElements()) {
            String xmlFileName;
            String namedBindingName;
            ImportEntry policyEntry;
            ZipEntry zipentry = entries.nextElement();
            String name = zipentry.getName();
            Path path = new Path(name);
            String extension = path.getFileExtension();
            if (extension == null || !extension.equals("xml")) continue;
            if (path.segmentCount() <= 2 || !path.segment(0).equals("bindings")) {
                ZipUtils.invalidPath(name);
            }
            if ((policyEntry = namedBindingsTable.get(namedBindingName = path.segment(1))) == null) {
                policyEntry = new ImportEntry();
                policyEntry.setName(namedBindingName);
                namedBindingsTable.put(namedBindingName, policyEntry);
            }
            if ((xmlFileName = path.lastSegment()) == null) {
                ZipUtils.invalidPath(name);
            }
            if (xmlFileName.equals("bindingDefinition.xml")) {
                policyEntry.setPolicySetEntry(zipentry);
                continue;
            }
            if (xmlFileName.equals("bindings.xml")) {
                policyEntry.getPolicyTypes().add(zipentry);
                continue;
            }
            ZipUtils.invalidPath(name);
        }
    }

    public static String[] getPolicySetInfo(ZipFile zipFile, ImportEntry entry) throws IOException {
        String[] result = new String[]{"", "", ""};
        try {
            ZipEntry zipEntry = entry.getPolicySetEntry();
            InputStream sourceStream = zipFile.getInputStream(zipEntry);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(sourceStream);
            Element rootElement = doc.getDocumentElement();
            String typeAttrValue = rootElement.getAttribute("type");
            String versionAttrValue = rootElement.getAttribute("version");
            String descriptionValue = rootElement.getAttribute("description");
            if (typeAttrValue != null) {
                result[0] = typeAttrValue;
            }
            if (versionAttrValue != null) {
                result[1] = versionAttrValue;
            }
            if (descriptionValue != null) {
                result[2] = descriptionValue;
            }
        }
        catch (Exception exc) {
            throw new IOException(exc.getMessage());
        }
        return result;
    }

    public static boolean isProviderNamedBinding(ZipFile zipFile, ImportEntry entry) throws IOException {
        boolean result = true;
        try {
            ZipEntry zipEntry = entry.getPolicySetEntry();
            InputStream sourceStream = zipFile.getInputStream(zipEntry);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(sourceStream);
            Element rootElement = doc.getDocumentElement();
            String attrValue = rootElement.getAttribute("type");
            result = attrValue != null && attrValue.equals("provider");
        }
        catch (Exception exc) {
            throw new IOException(exc.getMessage());
        }
        return result;
    }

    public static void writeEntry(ZipFile zipfile, ZipEntry entry, File targetFile) throws IOException {
        File parentFile = targetFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        InputStream sourceStream = zipfile.getInputStream(entry);
        FileOutputStream outputStream = new FileOutputStream(targetFile);
        ZipUtils.copyStreams(sourceStream, outputStream);
    }

    public static boolean createZipFile(Shell shell, String rootPathName, String zipFileName, Collection<ExportEntry> entries) {
        boolean result;
        block23: {
            result = true;
            ZipOutputStream zipStream = null;
            if (zipFileName == null || zipFileName.equals("")) {
                return false;
            }
            File zipFile = new File(zipFileName);
            if (zipFile.exists()) {
                result = MessageDialog.openConfirm((Shell)shell, (String)Messages.ZipUtils_0, (String)Messages.bind((String)Messages.ZipUtils_1, (Object)zipFileName));
            }
            if (result) {
                try {
                    try {
                        List<File> files = ZipUtils.findAllFiles(entries);
                        FileOutputStream stream = new FileOutputStream(zipFile);
                        byte[] buffer = new byte[4096];
                        int bytesRead = 0;
                        zipStream = new ZipOutputStream(stream);
                        for (File file : files) {
                            String path = ZipUtils.getRelativePath(rootPathName, file.getAbsolutePath());
                            ZipEntry zipEntry = new ZipEntry(path);
                            FileInputStream fileStream = new FileInputStream(file);
                            try {
                                zipStream.putNextEntry(zipEntry);
                                while ((bytesRead = fileStream.read(buffer)) != -1) {
                                    zipStream.write(buffer, 0, bytesRead);
                                }
                            }
                            finally {
                                if (fileStream != null) {
                                    fileStream.close();
                                }
                            }
                        }
                    }
                    catch (Exception exc) {
                        String message = exc.getMessage();
                        String errorMessage = message == null ? exc.getClass().getName() : message;
                        Status status = new Status(4, "id", message);
                        ErrorDialog.openError((Shell)shell, (String)Messages.ZipUtils_2, (String)errorMessage, (IStatus)status);
                        result = false;
                        try {
                            if (zipStream != null) {
                                zipStream.close();
                            }
                            break block23;
                        }
                        catch (IOException exc2) {
                            String message2 = exc2.getMessage();
                            String errorMessage2 = message2 == null ? exc2.getClass().getName() : message2;
                            Status status2 = new Status(4, "id", errorMessage2);
                            ErrorDialog.openError((Shell)shell, (String)Messages.ZipUtils_2, (String)errorMessage2, (IStatus)status2);
                            result = false;
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (zipStream != null) {
                            zipStream.close();
                        }
                    }
                    catch (IOException exc) {
                        String message = exc.getMessage();
                        String errorMessage = message == null ? exc.getClass().getName() : message;
                        Status status = new Status(4, "id", errorMessage);
                        ErrorDialog.openError((Shell)shell, (String)Messages.ZipUtils_2, (String)errorMessage, (IStatus)status);
                        result = false;
                    }
                    throw throwable;
                }
                try {
                    if (zipStream != null) {
                        zipStream.close();
                    }
                }
                catch (IOException exc) {
                    String message = exc.getMessage();
                    String errorMessage = message == null ? exc.getClass().getName() : message;
                    Status status = new Status(4, "id", errorMessage);
                    ErrorDialog.openError((Shell)shell, (String)Messages.ZipUtils_2, (String)errorMessage, (IStatus)status);
                    result = false;
                }
            }
        }
        return result;
    }

    private static String getRelativePath(String rootDirectory, String absolutePath) {
        Path path = new Path(absolutePath);
        String[] segments = path.segments();
        int index = 0;
        path = ZipUtils.removeProtocol((IPath)path);
        while (index < segments.length) {
            if (segments[index].equals(rootDirectory)) break;
            ++index;
        }
        return path.removeFirstSegments(index).toString().replace('\\', '/');
    }

    private static IPath removeProtocol(IPath path) {
        String strPath = path.toString();
        int colonIndex = strPath.indexOf(58);
        if (colonIndex == -1) {
            return path;
        }
        return new Path(strPath.substring(colonIndex + 1));
    }

    private static List<File> findAllFiles(Collection<ExportEntry> entries) {
        Vector<File> files = new Vector<File>();
        Bundle bundle = Platform.getBundle((String)"com.ibm.ast.ws.service.policy.ui");
        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
        File rootFile = new File(stateLocation.toString());
        for (ExportEntry exportEntry : entries) {
            if (!exportEntry.isSelected()) continue;
            IPath path = exportEntry.getPolicySetPath();
            path = ZipUtils.removeProtocol(path).removeLastSegments(1);
            ZipUtils.findFiles(files, new File(rootFile, path.toString()));
        }
        return files;
    }

    private static void findFiles(List<File> files, File aFile) {
        File[] children;
        File[] fileArray = children = aFile.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                ZipUtils.findFiles(files, child);
            } else {
                files.add(child);
            }
            ++n2;
        }
    }

    public static void invalidPath(String path) throws ZipException {
        throw new ZipException(Messages.bind((String)Messages.ZipUtils_3, (Object)path));
    }

    private static void copyStreams(InputStream is, OutputStream os) throws IOException {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream(os);
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            while ((bytesRead = bis.read(buffer)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, bytesRead);
            }
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }
}

