/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.widgets;

import com.ibm.ast.ws.security.ui.common.MessagePartItem;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.v6.ui.editor.common.ManagedTableViewerEditor;
import com.ibm.etools.webservice.atk.was.v6.ui.editor.common.TableModifyListener;
import com.ibm.etools.webservice.atk.was.v6.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscommonext.WscommonextFactory;
import com.ibm.etools.webservice.wscommonext.WscommonextPackage;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class MessagePartsTableWidget
extends SimpleWidgetDataContributor {
    protected Listener statusListener_;
    protected Vector messageParts = null;
    protected ManagedTableViewerEditor messagePartsTable;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener_ = statusListener;
        WscommonextPackage pkg = WscommonextFactory.eINSTANCE.getWscommonextPackage();
        String[] messagePartsTableColumns = new String[]{ATKWASUIPlugin.getMessage((String)"%LABEL_EXT_MESSAGE_PARTS_DIALECT"), ATKWASUIPlugin.getMessage((String)"%LABEL_EXT_MESSAGE_PARTS_KEYWORD")};
        EStructuralFeature[] messagePartsTableFeatures = new EStructuralFeature[]{pkg.getMessageParts_Dialect(), pkg.getMessageParts_Keyword()};
        this.messagePartsTable = new ManagedTableViewerEditor(parent, messagePartsTableColumns, pkg.getMessageParts(), messagePartsTableFeatures, null, null);
        this.messagePartsTable.refresh();
        this.messagePartsTable.addTableModifyListener((TableModifyListener)new MessagePartsTableListener());
        return this;
    }

    public IStatus getStatus() {
        if (this.messagePartsTable.getItems().length == 0) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("%ERROR_MISSING_MESSAGE_PARTS"), null);
        }
        return Status.OK_STATUS;
    }

    public Vector getMessageParts() {
        TableItem[] items = this.messagePartsTable.getItems();
        this.messageParts = new Vector();
        int i = 0;
        while (i < items.length) {
            this.messageParts.add(new MessagePartItem(items[i].getText(0), items[i].getText(1)));
            ++i;
        }
        return this.messageParts;
    }

    public void setMessageParts(Vector newMessageParts) {
        if (this.messageParts != null && this.messageParts.size() > 0) {
            return;
        }
        this.messageParts = newMessageParts;
        int i = 0;
        while (i < this.messageParts.size()) {
            MessagePartItem part = (MessagePartItem)this.messageParts.get(i);
            this.messagePartsTable.addConfiguredItem(new String[]{part.getDialect(), part.getKeyword()});
            ++i;
        }
    }

    public void setKeywords(String[] keywords) {
        Object[] messagePartsTableFeatureValues = new String[]{ATKWASUIConstants.getDialects()[0], keywords[0]};
        String[][] valuesArray = new String[][]{ATKWASUIConstants.getDialects(), keywords};
        this.messagePartsTable.setFeatureValues_(messagePartsTableFeatureValues);
        this.messagePartsTable.setItemsForColumn_(valuesArray);
    }

    protected class MessagePartsTableListener
    implements TableModifyListener {
        protected MessagePartsTableListener() {
        }

        public void tableCellSelected(String text, int row, int column) {
            MessagePartsTableWidget.this.statusListener_.handleEvent(null);
        }

        public void tableItemRemoved(Object object, EStructuralFeature[] features) {
            MessagePartsTableWidget.this.statusListener_.handleEvent(null);
        }
    }
}

