/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.widgets;

import com.ibm.ast.ws.security.ui.common.KeyStoreInformation;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.ast.ws.ui.plugin.WSUIPlugin;
import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class KeyStoreInformationWidget
extends SimpleWidgetDataContributor {
    protected Listener statusListener_;
    private Text keyStorePass_;
    private Text keyStorePath_;
    private Combo keyStoreType_;
    private Button useKey_;
    private Text alias_;
    private Text keyPass_;
    private KeyStoreInformation keyStore;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener_ = statusListener;
        final Composite theParent = parent;
        UIUtils uiUtils = WSSecurityUIPlugin.getUiUtils();
        Group keyInfoGroup = uiUtils.createGroup(parent, WSSecurityUIPlugin.getMessage("LABEL_KEY_STORE_GROUP"), null, null);
        keyInfoGroup.setLayout((Layout)new GridLayout(3, false));
        ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
        TextModifyListener modifyListener = new TextModifyListener();
        int style = WSUIPlugin.getInstance().getWASSecurityContext().isStarPassword() ? 0x400844 : 2116;
        this.keyStorePass_ = uiUtils.createText((Composite)keyInfoGroup, WSSecurityUIPlugin.getMessage("%LABEL_KEYSTORE_PASS"), null, null, style);
        this.keyStorePass_.addModifyListener((ModifyListener)modifyListener);
        new Label((Composite)keyInfoGroup, 256);
        this.keyStorePath_ = WSSecurityUIPlugin.getUiUtils().createText((Composite)keyInfoGroup, WSSecurityUIPlugin.getMessage("%LABEL_KEYSTORE_PATH"), null, null, 2048);
        Button browsePath = uiUtils.createPushButton((Composite)keyInfoGroup, WSSecurityUIPlugin.getMessage("%BUTTON_BROWSE"), null, null);
        browsePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(theParent.getShell());
                String keyStorePathText = fileDialog.open();
                if (keyStorePathText != null) {
                    KeyStoreInformationWidget.this.keyStorePath_.setText(keyStorePathText);
                }
            }
        });
        this.keyStorePath_.addModifyListener((ModifyListener)modifyListener);
        this.keyStoreType_ = uiUtils.createCombo((Composite)keyInfoGroup, WSSecurityUIPlugin.getMessage("%LABEL_KEYSTORE_TYPE"), null, null, 2060);
        this.keyStoreType_.setItems(atkWasUiConstants.getKeyStoreTypes());
        this.keyStoreType_.select(1);
        this.keyStoreType_.addModifyListener((ModifyListener)modifyListener);
        new Label((Composite)keyInfoGroup, 256);
        this.useKey_ = uiUtils.createCheckbox((Composite)keyInfoGroup, WSSecurityUIPlugin.getMessage("LABEL_KEY"), null, null);
        this.useKey_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyStoreInformationWidget.this.enableKeyUsage(KeyStoreInformationWidget.this.useKey_.getSelection());
                KeyStoreInformationWidget.this.statusListener_.handleEvent(null);
            }
        });
        new Label((Composite)keyInfoGroup, 256);
        new Label((Composite)keyInfoGroup, 256);
        this.alias_ = WSSecurityUIPlugin.getUiUtils().createText((Composite)keyInfoGroup, WSSecurityUIPlugin.getMessage("%LABEL_KEY_ALIAS"), null, null, 2116);
        this.alias_.addModifyListener((ModifyListener)modifyListener);
        new Label((Composite)keyInfoGroup, 256);
        this.keyPass_ = WSSecurityUIPlugin.getUiUtils().createText((Composite)keyInfoGroup, WSSecurityUIPlugin.getMessage("%LABEL_KEY_PASS"), null, null, style);
        this.keyPass_.addModifyListener((ModifyListener)modifyListener);
        this.enableKeyUsage(false);
        return this;
    }

    private void enableKeyUsage(boolean enableKey) {
        this.alias_.setEnabled(enableKey);
        this.keyPass_.setEnabled(enableKey);
    }

    public IStatus getStatus() {
        if (this.keyStorePass_.getText().equals("") || this.keyStorePath_.getText().equals("") || this.keyStoreType_.getText().equals("") || this.useKey_.getSelection() && (this.alias_.getText().equals("") || this.keyPass_.getText().equals(""))) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, "", null);
        }
        return Status.OK_STATUS;
    }

    public boolean canFinish() {
        return true;
    }

    public void setKeyStore(KeyStoreInformation newkeyStore) {
        if (this.keyStore == null) {
            this.keyStore = newkeyStore;
            if (this.keyStore.getKey() != null) {
                this.alias_.setText(this.keyStore.getKeyAlias());
                this.keyPass_.setText(this.keyStore.getKeyPass());
            }
            this.keyStoreType_.setText(this.keyStore.getKeyStoreType());
            this.keyStorePass_.setText(this.keyStore.getKeyStoreStorePass());
            this.keyStorePath_.setText(this.keyStore.getKeyStorePath());
        }
        this.setFocus();
    }

    public KeyStoreInformation getKeyStore() {
        this.keyStore.setKeyStore(this.keyStorePass_.getText(), this.keyStorePath_.getText(), this.keyStoreType_.getText());
        if (this.useKey_.getSelection()) {
            this.keyStore.setKey(this.alias_.getText(), this.keyPass_.getText(), this.alias_.getText());
        } else {
            this.keyStore.setKey(null);
        }
        return this.keyStore;
    }

    private void setFocus() {
        if (this.keyStorePass_.getText().equals("")) {
            this.keyStorePass_.setFocus();
        } else if (this.keyStorePath_.getText().equals("")) {
            this.keyStorePath_.setFocus();
        } else if (this.useKey_.getSelection()) {
            if (this.alias_.getText().equals("")) {
                this.alias_.setFocus();
            } else if (this.keyPass_.getText().equals("")) {
                this.keyPass_.setFocus();
            }
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            KeyStoreInformationWidget.this.statusListener_.handleEvent(null);
        }
    }
}

